/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import org.apache.kafka.common.network.netty.EchoStreamHandler;
import org.apache.kafka.common.network.netty.NettyServer;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.TestUtils;
import org.apache.kafka.common.utils.LogContext;

public class NettyHttp2EchoServer {
    private NettyServer nettyServer;
    private InetSocketAddress listeningAddress;

    void start(boolean ssl, boolean flowControlEnabled) throws Exception {
        LogContext logContext = new LogContext("[NettyHttp2EchoServer]");
        this.nettyServer = NettyServer.Builder.newServerBuilder((LogContext)logContext, (String)"echo-server", (SslContext)(ssl ? TestUtils.buildServerSslContext() : null), (stream, headers) -> new EchoStreamHandler((NettyStream)stream, logContext), (NettyServer.NettyServerProtocol)NettyServer.NettyServerProtocol.HTTP2, (boolean)true).withWorkerThreads(1).withOption(ChannelOption.SO_BACKLOG, (Object)100).withHandler((ChannelHandler)new LoggingHandler(LogLevel.INFO)).withHttp2Settings(new Http2Settings()).withFlowControlEnabled(flowControlEnabled).build();
        this.nettyServer.start(0).get();
        this.listeningAddress = (InetSocketAddress)this.nettyServer.localAddress().get();
    }

    public void start(boolean ssl) throws Exception {
        this.start(ssl, true);
    }

    public void stop() {
        if (this.nettyServer != null) {
            this.nettyServer.shutdown().join();
        }
        this.nettyServer = null;
    }

    public void beginStop() {
        if (this.nettyServer != null) {
            this.nettyServer.shutdown();
        }
    }

    public InetSocketAddress address() {
        return this.listeningAddress;
    }

    public ChannelGroup trackedChannels() {
        return this.nettyServer.trackedChannels();
    }
}

