/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.ByteBufReceive;
import org.apache.kafka.common.network.netty.NettyHttp2Selector;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.TestUtils;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class NettyHttp2SelectorStreamChannelTest {
    private static final String CONNECTION_ID = "test_connection";
    private static EventLoopGroup eventLoopGroup;
    private NettyHttp2Selector.StreamChannel streamChannel;
    private NettyHttp2Selector nettyHttp2Selector;
    private ByteBuffer serializedResponse;

    @BeforeAll
    public static void start() {
        eventLoopGroup = new DefaultEventLoop();
    }

    @BeforeEach
    public void setup() {
        LogContext logContext = new LogContext("[NettyHttp2SelectorStreamChannelTest]");
        SslContext sslContext = (SslContext)Mockito.mock(SslContext.class);
        NettyHttp2Selector nettyHttp2Selector = this.nettyHttp2Selector = new NettyHttp2Selector(eventLoopGroup, sslContext, new LogContext());
        Objects.requireNonNull(nettyHttp2Selector);
        this.streamChannel = new NettyHttp2Selector.StreamChannel(nettyHttp2Selector, CONNECTION_ID, logContext);
        Http2StreamChannel http2StreamChannel = (Http2StreamChannel)Mockito.mock(Http2StreamChannel.class);
        Channel parentChannel = TestUtils.mockConnectionChannel();
        Mockito.when((Object)http2StreamChannel.parent()).thenReturn((Object)parentChannel);
        Mockito.when((Object)http2StreamChannel.eventLoop()).thenReturn((Object)eventLoopGroup.next());
        Http2FrameStream frameStream = (Http2FrameStream)Mockito.mock(Http2FrameStream.class);
        Mockito.when((Object)frameStream.id()).thenReturn((Object)1);
        Mockito.when((Object)http2StreamChannel.stream()).thenReturn((Object)frameStream);
        ChannelPipeline streamPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        Mockito.when((Object)http2StreamChannel.pipeline()).thenReturn((Object)streamPipeline);
        ChannelFuture closeFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)http2StreamChannel.closeFuture()).thenReturn((Object)closeFuture);
        ChannelFuture closeMethodFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)http2StreamChannel.close()).thenReturn((Object)closeMethodFuture);
        ChannelConfig config = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)http2StreamChannel.config()).thenReturn((Object)config);
        Mockito.when((Object)config.setOption((ChannelOption)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)true);
        NettyHttp2Stream nettyStream = new NettyHttp2Stream(http2StreamChannel, logContext);
        this.streamChannel.stream((NettyStream)nettyStream);
    }

    @AfterEach
    public void clean() {
        this.nettyHttp2Selector.close();
    }

    @AfterAll
    public static void stop() {
        eventLoopGroup.shutdownGracefully();
    }

    @BeforeEach
    public void serializeResponse() throws IOException {
        short apiVersion = 2;
        short headerVersion = ApiKeys.ALTER_CONFIGS.responseHeaderVersion(apiVersion);
        ResponseHeader header = new ResponseHeader(1, headerVersion);
        AlterConfigsResponseData alterConfigsResponseData = new AlterConfigsResponseData();
        AlterConfigsResponseData.AlterConfigsResourceResponse response = new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.NONE.code()).setErrorMessage("").setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("test");
        alterConfigsResponseData.setResponses(Collections.singletonList(response));
        AlterConfigsResponse alterConfigsResponse = new AlterConfigsResponse(alterConfigsResponseData);
        Send send = alterConfigsResponse.toSend(header, apiVersion);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)channel);
        this.serializedResponse = channel.buffer();
        this.serializedResponse.flip();
    }

    @Test
    public void testHandleDataEmptyBuffer() {
        ByteBuf data = (ByteBuf)Mockito.spy((Object)Unpooled.EMPTY_BUFFER);
        this.streamChannel.handleData(data);
        ((ByteBuf)Mockito.verify((Object)data)).isReadable();
        Assertions.assertEquals((int)1, (int)data.refCnt());
        Assertions.assertFalse((boolean)data.isReadable());
        data.release();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testHandleDataPartialResponseBuffer(boolean addEmptyBuffer) {
        int totalSize = this.serializedResponse.limit();
        int midIdx = totalSize / 2;
        ByteBuf data = Unpooled.wrappedBuffer((ByteBuffer)this.serializedResponse);
        ByteBuf firstBuf = data.slice(0, midIdx);
        ByteBuf secondBuf = data.slice(midIdx, totalSize - midIdx);
        this.streamChannel.handleData(firstBuf);
        ByteBufReceive pendingReceive = this.streamChannel.pendingReceive();
        Assertions.assertNotNull((Object)pendingReceive);
        Assertions.assertFalse((boolean)pendingReceive.complete());
        Assertions.assertEquals((int)this.serializedResponse.limit(), (int)pendingReceive.size());
        if (addEmptyBuffer) {
            this.streamChannel.handleData(Unpooled.EMPTY_BUFFER);
        }
        this.streamChannel.handleData(secondBuf);
        Assertions.assertNull((Object)this.streamChannel.pendingReceive());
        this.nettyHttp2Selector.poll(0L);
        Collection completedReceives = this.nettyHttp2Selector.completedReceives();
        Assertions.assertEquals((int)1, (int)completedReceives.size());
        Assertions.assertEquals((int)this.serializedResponse.limit(), (int)((NetworkReceive)completedReceives.iterator().next()).size());
    }

    @Test
    public void testHandleDataCompleteResponseBuffer() {
        ByteBuf data = Unpooled.wrappedBuffer((ByteBuffer)this.serializedResponse);
        this.streamChannel.handleData(data);
        Assertions.assertNull((Object)this.streamChannel.pendingReceive());
        this.nettyHttp2Selector.poll(0L);
        Collection completedReceives = this.nettyHttp2Selector.completedReceives();
        Assertions.assertEquals((int)1, (int)completedReceives.size());
        Assertions.assertEquals((int)this.serializedResponse.limit(), (int)((NetworkReceive)completedReceives.iterator().next()).size());
    }

    @Test
    public void testInitialized() {
        this.streamChannel.stream(null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.streamChannel.checkInitialized());
        NettyStream stream = (NettyStream)Mockito.mock(NettyHttp2Stream.class);
        this.streamChannel.stream(stream);
        Assertions.assertEquals((Object)this.streamChannel, (Object)this.streamChannel.checkInitialized());
    }

    @Test
    public void testHandleClose() {
        Map streams = this.nettyHttp2Selector.streams();
        streams.put(CONNECTION_ID, this.streamChannel);
        this.streamChannel.handleClose();
        Assertions.assertEquals((int)1, (int)this.nettyHttp2Selector.pollTasks().size());
        this.nettyHttp2Selector.poll(0L);
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.streams().isEmpty());
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.pollTasks().isEmpty());
        Assertions.assertEquals((Object)ChannelState.LOCAL_CLOSE, this.nettyHttp2Selector.disconnected().get(CONNECTION_ID));
        this.streamChannel.handleClose();
        this.nettyHttp2Selector.poll(0L);
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.pollTasks().isEmpty());
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.disconnected().isEmpty());
    }

    @Test
    public void testHandleException() {
        Map streams = this.nettyHttp2Selector.streams();
        streams.put(CONNECTION_ID, this.streamChannel);
        this.streamChannel.handleException(new Throwable("Test exception"));
        Assertions.assertEquals((int)1, (int)this.nettyHttp2Selector.pollTasks().size());
        this.nettyHttp2Selector.poll(0L);
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.streams().isEmpty());
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.pollTasks().isEmpty());
        Assertions.assertEquals((Object)ChannelState.LOCAL_CLOSE, this.nettyHttp2Selector.disconnected().get(CONNECTION_ID));
        this.streamChannel.handleException(new Throwable("Test exception"));
        this.nettyHttp2Selector.poll(0L);
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.pollTasks().isEmpty());
        Assertions.assertTrue((boolean)this.nettyHttp2Selector.disconnected().isEmpty());
    }

    @Test
    public void testStartSend() throws InterruptedException {
        NettyStream originalNettyStream = this.streamChannel.stream();
        NettyStream nettyStream = (NettyStream)Mockito.spy((Object)originalNettyStream);
        Mockito.when((Object)nettyStream.isReadyForSending()).thenReturn((Object)false);
        this.streamChannel.stream(nettyStream);
        NetworkSend send = (NetworkSend)Mockito.mock(NetworkSend.class);
        this.streamChannel.startSend(send);
        org.apache.kafka.test.TestUtils.waitForCondition(() -> send == this.streamChannel.pendingSend(), "Pending send is not same as the send we sent.");
        NetworkSend send2 = (NetworkSend)Mockito.mock(NetworkSend.class);
        this.streamChannel.startSend(send2);
        Assertions.assertEquals((Object)send, (Object)this.streamChannel.pendingSend());
    }
}

