/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.network.netty.NettyClient;
import org.apache.kafka.common.network.netty.NettyClientTestBase;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.TestNettyStreamHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NettyHttp2StreamClientHandlerTest
extends NettyClientTestBase {
    private NettyClient client;
    private NettyHttp2Stream stream;
    private NettyHttp2Stream.NettyHttp2StreamHandler streamHandler;
    TestNettyStreamHandler handler;

    @BeforeEach
    public void setup() throws Exception {
        this.client = new NettyClient(NettyHttp2StreamClientHandlerTest.acceptAllSslContext(), this.eventLoopGroup, logContext);
        this.handler = new TestNettyStreamHandler(new CountDownLatch(1));
        this.stream = (NettyHttp2Stream)this.client.createStream(NettyHttp2StreamClientHandlerTest.serverAddress(), Integer.valueOf(0x100000), Integer.valueOf(0x100000), (NettyStream.StreamHandler)this.handler, (Http2Headers)new DefaultHttp2Headers()).get();
        this.streamHandler = (NettyHttp2Stream.NettyHttp2StreamHandler)this.stream.channel().pipeline().first();
    }

    @AfterEach
    public void close() {
        if (this.stream.isOpen()) {
            this.stream.closeStream().awaitUninterruptibly();
        }
        this.client.shutdown().join();
    }

    @Test
    public void testHasCorrectNettyStreamHandler() {
        Assertions.assertEquals((Object)this.handler, (Object)this.streamHandler.streamHandler());
    }
}

