/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.network.netty.NettyRawBytesConnectionInitializer;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class NettyRawBytesConnectionInitializerTest {
    private static final LogContext logContext = new LogContext("[NettyRawBytesConnectionInitializerTest]");
    private EmbeddedChannel channel;

    NettyRawBytesConnectionInitializerTest() {
    }

    @BeforeEach
    void setUp() {
        this.channel = new EmbeddedChannel();
    }

    @Test
    void testSslSessionEmpty() {
        DefaultChannelGroup trackedChannels = new DefaultChannelGroup((EventExecutor)this.channel.eventLoop());
        SslContext mockSslContext = (SslContext)Mockito.mock(SslContext.class);
        SslHandler mockSslHandler = (SslHandler)Mockito.mock(SslHandler.class);
        Mockito.when((Object)mockSslContext.newHandler((ByteBufAllocator)ArgumentMatchers.any())).thenReturn((Object)mockSslHandler);
        Mockito.when((Object)mockSslHandler.engine()).thenReturn((Object)((SSLEngine)Mockito.mock(SSLEngine.class)));
        Mockito.when((Object)mockSslHandler.engine().getSession()).thenReturn(null);
        NettyRawBytesConnectionInitializer initializer = new NettyRawBytesConnectionInitializer((ChannelGroup)trackedChannels, mockSslContext, (BiFunction)Mockito.mock(BiFunction.class), logContext, false, false);
        initializer.initChannel((Channel)this.channel);
        Assertions.assertTrue((boolean)Utils.sslSession((Channel)this.channel).isEmpty());
    }

    @Test
    void testSslSessionPresent() {
        DefaultChannelGroup trackedChannels = new DefaultChannelGroup((EventExecutor)this.channel.eventLoop());
        SslContext mockSslContext = (SslContext)Mockito.mock(SslContext.class);
        SslHandler mockSslHandler = (SslHandler)Mockito.mock(SslHandler.class);
        Mockito.when((Object)mockSslContext.newHandler((ByteBufAllocator)ArgumentMatchers.any())).thenReturn((Object)mockSslHandler);
        Mockito.when((Object)mockSslHandler.engine()).thenReturn((Object)((SSLEngine)Mockito.mock(SSLEngine.class)));
        Mockito.when((Object)mockSslHandler.engine().getSession()).thenReturn((Object)((SSLSession)Mockito.mock(SSLSession.class)));
        NettyRawBytesConnectionInitializer initializer = new NettyRawBytesConnectionInitializer((ChannelGroup)trackedChannels, mockSslContext, (BiFunction)Mockito.mock(BiFunction.class), logContext, false, false);
        initializer.initChannel((Channel)this.channel);
        Assertions.assertTrue((boolean)Utils.sslSession((Channel)this.channel).isPresent());
    }
}

