/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.Tag;
import net.jqwik.api.Tuple;
import net.jqwik.api.statistics.Histogram;
import net.jqwik.api.statistics.StatisticsReport;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.ByteBufReceive;
import org.apache.kafka.common.network.netty.ReadableByteBuf;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.junit.jupiter.api.Assertions;

@Tag(value="propertybased")
public class ReadableByteBufRequestMultipleBufferTestPBT {
    private static final int MAX_RECEIVE_SIZE = 0x100000;
    private static final int CORRELATION_ID = 100;
    private static final String CLIENT_ID = "test_client_id";

    @Property
    @StatisticsReport(format=Histogram.class)
    public void testSingleRequest(@ForAll(value="singleRequest") Tuple.Tuple2<AbstractRequest, List<ByteBuf>> request) {
        ByteBufReceive requestBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        ((List)request.get2()).forEach(arg_0 -> ((ByteBufReceive)requestBuf).readFrom(arg_0));
        ReadableByteBuf readableByteBuf = requestBuf.payload();
        AbstractRequest sourceRequest = (AbstractRequest)request.get1();
        int expectedSize = requestBuf.requestSize();
        RequestHeader header = RequestHeader.parse((ByteBuffer)readableByteBuf.readByteBuffer(expectedSize));
        Assertions.assertEquals((Object)sourceRequest.apiKey(), (Object)header.apiKey());
        Assertions.assertEquals((short)sourceRequest.version(), (short)header.apiVersion());
        Assertions.assertEquals((Object)CLIENT_ID, (Object)header.clientId());
        Assertions.assertEquals((int)100, (int)header.correlationId());
        readableByteBuf.position(header.size());
        RequestAndSize parsedRequest = AbstractRequest.parseRequest((ApiKeys)sourceRequest.apiKey(), (short)sourceRequest.version(), (Readable)readableByteBuf, (MessageContext)MessageContext.IDENTITY);
        if (sourceRequest.apiKey() != ApiKeys.FETCH) {
            Assertions.assertEquals((Object)sourceRequest.data(), (Object)parsedRequest.request.data());
        } else {
            Assertions.assertInstanceOf(FetchRequest.class, (Object)parsedRequest.request);
            FetchRequest fetchRequest = (FetchRequest)parsedRequest.request;
            Assertions.assertEquals((Object)ApiKeys.FETCH, (Object)fetchRequest.apiKey());
            List topics = fetchRequest.data().topics();
            Assertions.assertEquals((int)1, (int)topics.size());
        }
        readableByteBuf.close();
        requestBuf.close();
        Assertions.assertEquals((int)0, (int)requestBuf.refCnt());
        ((List)request.get2()).forEach(byteBuf -> Assertions.assertEquals((int)1, (int)byteBuf.refCnt()));
        for (ByteBuf byteBuf2 : (List)request.get2()) {
            if (byteBuf2.refCnt() <= 0) continue;
            byteBuf2.release();
        }
    }

    @Property
    @StatisticsReport(format=Histogram.class)
    public void testMultipleRequests(@ForAll(value="twoRequests") Tuple.Tuple3<AbstractRequest, AbstractRequest, List<ByteBuf>> requests) {
        int i;
        AbstractRequest firstRequest = (AbstractRequest)requests.get1();
        AbstractRequest secondRequest = (AbstractRequest)requests.get2();
        List serializedRequests = (List)requests.get3();
        ByteBufReceive requestBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        int idx = 0;
        boolean bufferConsumed = true;
        while (!requestBuf.complete()) {
            ByteBuf buf = (ByteBuf)serializedRequests.get(idx++);
            requestBuf.readFrom(buf);
            bufferConsumed = !buf.isReadable();
        }
        if (!bufferConsumed) {
            --idx;
        }
        int firstRequestEndIdx = idx;
        int expectedSize = requestBuf.requestSize();
        ReadableByteBuf readableByteBuf = requestBuf.payload();
        RequestHeader header = RequestHeader.parse((ByteBuffer)readableByteBuf.readByteBuffer(expectedSize));
        Assertions.assertEquals((Object)firstRequest.apiKey(), (Object)header.apiKey());
        readableByteBuf.position(header.size());
        RequestAndSize parsedRequest = AbstractRequest.parseRequest((ApiKeys)firstRequest.apiKey(), (short)firstRequest.version(), (Readable)readableByteBuf, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)firstRequest.apiKey(), (Object)parsedRequest.request.apiKey());
        readableByteBuf.close();
        requestBuf.close();
        Assertions.assertEquals((int)0, (int)requestBuf.refCnt());
        for (i = 0; i < firstRequestEndIdx; ++i) {
            Assertions.assertEquals((int)1, (int)((ByteBuf)serializedRequests.get(i)).refCnt());
        }
        requestBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        while (!requestBuf.complete()) {
            requestBuf.readFrom((ByteBuf)serializedRequests.get(idx++));
        }
        expectedSize = requestBuf.requestSize();
        readableByteBuf = requestBuf.payload();
        header = RequestHeader.parse((ByteBuffer)readableByteBuf.readByteBuffer(expectedSize));
        Assertions.assertEquals((Object)secondRequest.apiKey(), (Object)header.apiKey());
        readableByteBuf.position(header.size());
        parsedRequest = AbstractRequest.parseRequest((ApiKeys)secondRequest.apiKey(), (short)secondRequest.version(), (Readable)readableByteBuf, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)secondRequest.apiKey(), (Object)parsedRequest.request.apiKey());
        readableByteBuf.close();
        requestBuf.close();
        Assertions.assertEquals((int)0, (int)requestBuf.refCnt());
        for (i = firstRequestEndIdx; i < serializedRequests.size(); ++i) {
            Assertions.assertEquals((int)1, (int)((ByteBuf)serializedRequests.get(i)).refCnt());
        }
        for (ByteBuf byteBuf : serializedRequests) {
            if (byteBuf.refCnt() <= 0) continue;
            byteBuf.release();
        }
    }

    @Provide
    private Arbitrary<Tuple.Tuple2<AbstractRequest, List<ByteBuf>>> singleRequest() {
        return this.request().flatMap(request -> {
            byte[] serializedRequest = ReadableByteBufRequestMultipleBufferTestPBT.serializedRequest(request);
            return Arbitraries.integers().between(1, serializedRequest.length - 1).map(chunkSize -> Tuple.of((Object)request, ReadableByteBufRequestMultipleBufferTestPBT.splitRequest(serializedRequest, chunkSize)));
        });
    }

    @Provide
    private Arbitrary<Tuple.Tuple3<AbstractRequest, AbstractRequest, List<ByteBuf>>> twoRequests() {
        Arbitrary serializedRequests = Builders.withBuilder(() -> new TwoRequestBuilder()).use(this.request()).in(TwoRequestBuilder::firstRequest).use(this.request()).in(TwoRequestBuilder::secondRequest).build(TwoRequestBuilder::build);
        return serializedRequests.flatMap(serializedRequest -> Arbitraries.integers().between(1, ((byte[])serializedRequest.get3()).length - 1).map(chunkSize -> Tuple.of((Object)((AbstractRequest)serializedRequest.get1()), (Object)((AbstractRequest)serializedRequest.get2()), ReadableByteBufRequestMultipleBufferTestPBT.splitRequest((byte[])serializedRequest.get3(), chunkSize))));
    }

    private Arbitrary<AbstractRequest> request() {
        return Arbitraries.oneOf(this.apiVersionsRequest(), (Arbitrary[])new Arbitrary[]{this.metadataRequest(), this.fetchRequest(), this.produceRequest()});
    }

    private Arbitrary<AbstractRequest> apiVersionsRequest() {
        return Arbitraries.just((Object)new ApiVersionsRequest.Builder().build((short)4));
    }

    private Arbitrary<AbstractRequest> metadataRequest() {
        MetadataRequestData data = new MetadataRequestData().setTopics(List.of()).setAllowAutoTopicCreation(true);
        return Arbitraries.just((Object)new MetadataRequest.Builder(data).build((short)13));
    }

    private Arbitrary<AbstractRequest> fetchRequest() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(Uuid.randomUuid(), 0L, 0L, 100, Optional.empty(), Optional.empty(), Optional.empty());
        return Arbitraries.just((Object)new FetchRequest.Builder(0, 10, -1, -1L, Integer.MAX_VALUE, 0, Map.of(topicPartition, partitionData)).build((short)18));
    }

    private Arbitrary<AbstractRequest> produceRequest() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("woot".getBytes())});
        short version = 13;
        ProduceRequestData.TopicProduceData produceData = new ProduceRequestData.TopicProduceData().setTopicId(Uuid.randomUuid()).setPartitionData(List.of(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)records)));
        ProduceRequestData.TopicProduceDataCollection topicDataCollection = new ProduceRequestData.TopicProduceDataCollection(List.of(produceData).iterator());
        return Arbitraries.just((Object)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(topicDataCollection).setAcks((short)1).setTimeoutMs(5000).setTransactionalId("transactionalId")).build(version));
    }

    private static byte[] serializedRequest(AbstractRequest request) {
        try {
            RequestHeader requestHeader = new RequestHeader(request.apiKey(), request.version(), CLIENT_ID, 100);
            Send send = request.toSend(requestHeader);
            ByteBufferChannel channel = new ByteBufferChannel(send.size());
            send.writeTo((TransferableChannel)channel);
            return channel.buffer().array();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ByteBuf> splitRequest(byte[] request, int chunkSize) {
        ArrayList<ByteBuf> ret = new ArrayList<ByteBuf>(request.length / chunkSize + 1);
        for (int i = 0; i < request.length; i += chunkSize) {
            byte[] chunk = Arrays.copyOfRange(request, i, Math.min(request.length, i + chunkSize));
            ret.add(Unpooled.copiedBuffer((byte[])chunk));
        }
        return ret;
    }

    private static class TwoRequestBuilder {
        private AbstractRequest firstRequest;
        private AbstractRequest secondRequest;

        private TwoRequestBuilder() {
        }

        public TwoRequestBuilder firstRequest(AbstractRequest firstRequest) {
            this.firstRequest = firstRequest;
            return this;
        }

        public TwoRequestBuilder secondRequest(AbstractRequest secondRequest) {
            this.secondRequest = secondRequest;
            return this;
        }

        public Tuple.Tuple3<AbstractRequest, AbstractRequest, byte[]> build() {
            byte[] firstRequestBytes = ReadableByteBufRequestMultipleBufferTestPBT.serializedRequest(this.firstRequest);
            byte[] secondRequestBytes = ReadableByteBufRequestMultipleBufferTestPBT.serializedRequest(this.secondRequest);
            byte[] combined = new byte[firstRequestBytes.length + secondRequestBytes.length];
            System.arraycopy(firstRequestBytes, 0, combined, 0, firstRequestBytes.length);
            System.arraycopy(secondRequestBytes, 0, combined, firstRequestBytes.length, secondRequestBytes.length);
            return Tuple.of((Object)this.firstRequest, (Object)this.secondRequest, (Object)combined);
        }
    }
}

