/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.ByteBufReceive;
import org.apache.kafka.common.network.netty.ReadableByteBuf;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ReadableBuf;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.RequestHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReadableByteBufSingleRequestBufferTest {
    private static final int MAX_RECEIVE_SIZE = 0x100000;
    private static final int REQUEST_SIZE_BYTES = 4;
    private static final short API_VERSION = 1;
    private static final ApiVersionsRequest API_VERSIONS_REQUEST = new ApiVersionsRequest.Builder().build((short)1);
    private static byte[] serializedRequest;
    private ReadableByteBuf requestBuf;
    private ByteBufReceive receiveBuf;

    @BeforeAll
    public static void beforeAll() throws IOException {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.API_VERSIONS, 1, "test_client_id", 100);
        Send send = API_VERSIONS_REQUEST.toSend(requestHeader);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)channel);
        serializedRequest = channel.buffer().array();
    }

    @BeforeEach
    public void beforeEach() {
        this.receiveBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        this.receiveBuf.readFrom(Unpooled.wrappedBuffer((byte[])serializedRequest));
        this.requestBuf = this.receiveBuf.payload();
    }

    @AfterEach
    public void afterEach() {
        this.requestBuf.close();
        this.receiveBuf.close();
    }

    @Test
    public void testSlice() {
        int originalCount = this.requestBuf.refCnt();
        ReadableByteBuf slicedBuf = (ReadableByteBuf)this.requestBuf.slice();
        Assertions.assertEquals((int)originalCount, (int)this.requestBuf.refCnt());
        Assertions.assertEquals((int)originalCount, (int)slicedBuf.refCnt());
    }

    @Test
    public void testPosition() {
        Assertions.assertEquals((int)0, (int)this.requestBuf.position());
    }

    @Test
    public void testSetPosition() {
        int newPosition = 10;
        this.requestBuf.position(10);
        Assertions.assertEquals((int)10, (int)this.requestBuf.position());
    }

    @Test
    public void testRewind() {
        int newPosition = 10;
        this.requestBuf.position(10);
        Assertions.assertEquals((int)10, (int)this.requestBuf.position());
        this.requestBuf.rewind();
        Assertions.assertEquals((int)0, (int)this.requestBuf.position());
    }

    @Test
    public void testFlip() {
        int newPosition = 2;
        this.requestBuf.position(2);
        Assertions.assertEquals((int)2, (int)this.requestBuf.position());
        this.requestBuf.flip();
        Assertions.assertEquals((int)0, (int)this.requestBuf.position());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.requestBuf.readInt());
    }

    @Test
    public void testReadByte() {
        for (int i = 4; i < serializedRequest.length; ++i) {
            Assertions.assertEquals((byte)serializedRequest[i], (byte)this.requestBuf.readByte());
        }
        Assertions.assertEquals((int)0, (int)this.requestBuf.remaining());
    }

    @Test
    public void testReadShort() {
        int shortSizeInBytes = 2;
        for (int i = 4; i < serializedRequest.length; i += shortSizeInBytes) {
            short shortVal = ByteBuffer.wrap(serializedRequest, i, shortSizeInBytes).getShort();
            Assertions.assertEquals((short)shortVal, (short)this.requestBuf.readShort());
        }
        Assertions.assertEquals((int)0, (int)this.requestBuf.remaining());
    }

    @Test
    public void testReadInt() {
        int intSizeInBytes = 4;
        for (int i = 4; i < serializedRequest.length; i += intSizeInBytes) {
            int intVal = ByteBuffer.wrap(serializedRequest, i, intSizeInBytes).getInt();
            Assertions.assertEquals((int)intVal, (int)this.requestBuf.readInt());
        }
        Assertions.assertEquals((int)0, (int)this.requestBuf.remaining());
    }

    @Test
    public void testReadLong() {
        int longSizeInBytes = 8;
        for (int i = 4; i < serializedRequest.length; i += longSizeInBytes) {
            long longVal = ByteBuffer.wrap(serializedRequest, i, longSizeInBytes).getLong();
            Assertions.assertEquals((long)longVal, (long)this.requestBuf.readLong());
        }
        Assertions.assertEquals((int)0, (int)this.requestBuf.remaining());
    }

    @Test
    public void testReadDouble() {
        int doubleSizeInBytes = 8;
        for (int i = 4; i < serializedRequest.length; i += doubleSizeInBytes) {
            double doubleValue = ByteBuffer.wrap(serializedRequest, i, doubleSizeInBytes).getDouble();
            Assertions.assertEquals((double)doubleValue, (double)this.requestBuf.readDouble());
        }
        Assertions.assertEquals((int)0, (int)this.requestBuf.remaining());
    }

    @Test
    public void testReadArray() {
        int remaining = this.requestBuf.remaining();
        byte[] arrayRead = this.requestBuf.readArray(10);
        byte[] expected = Arrays.copyOfRange(serializedRequest, 4, 14);
        Assertions.assertArrayEquals((byte[])expected, (byte[])arrayRead, (String)("Arrays are not equal, expected: " + Arrays.toString(expected) + " actual: " + Arrays.toString(arrayRead)));
        Assertions.assertEquals((int)(remaining - 10), (int)this.requestBuf.remaining());
    }

    @Test
    public void testReadByteBuffer() {
        int remaining = this.requestBuf.remaining();
        ByteBuffer byteBufferRead = this.requestBuf.readByteBuffer(10);
        ByteBuffer originalContent = ByteBuffer.wrap(serializedRequest, 4, 10);
        Assertions.assertEquals((Object)originalContent, (Object)byteBufferRead);
        Assertions.assertEquals((int)(remaining - 10), (int)this.requestBuf.remaining());
    }

    @Test
    public void testReadUnsignedVarInt() {
        byte[] serializedUnsignedVarInt = new byte[]{0, 0, 0, 2, -106, 1};
        ByteBufReceive receive = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        receive.readFrom(Unpooled.wrappedBuffer((byte[])serializedUnsignedVarInt));
        ReadableByteBuf readableByteBuf = receive.payload();
        Assertions.assertEquals((int)150, (int)readableByteBuf.readUnsignedVarint());
        Assertions.assertEquals((int)0, (int)readableByteBuf.remaining());
        receive.close();
        readableByteBuf.close();
    }

    @Test
    public void testReadVarInt() {
        byte[] serializedVarInt = new byte[]{0, 0, 0, 1, 3};
        ByteBufReceive receive = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        receive.readFrom(Unpooled.wrappedBuffer((byte[])serializedVarInt));
        ReadableByteBuf readableByteBuf = receive.payload();
        Assertions.assertEquals((int)-2, (int)readableByteBuf.readVarint());
        Assertions.assertEquals((int)0, (int)readableByteBuf.remaining());
        receive.close();
        readableByteBuf.close();
    }

    @Test
    public void testReadVarLong() {
        byte[] serializedVarLong = new byte[]{0, 0, 0, 1, 3};
        ByteBufReceive receive = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        receive.readFrom(Unpooled.wrappedBuffer((byte[])serializedVarLong));
        ReadableByteBuf readableByteBuf = receive.payload();
        Assertions.assertEquals((long)-2L, (long)readableByteBuf.readVarlong());
        Assertions.assertEquals((int)0, (int)readableByteBuf.remaining());
        receive.close();
        readableByteBuf.close();
    }

    @Test
    public void testRemaining() {
        this.requestBuf.readShort();
        int remaining = this.receiveBuf.requestSize() - 2;
        Assertions.assertEquals((int)remaining, (int)this.requestBuf.remaining());
    }

    @Test
    public void testNioBufferReturnsCorrectByteBuffer() {
        ByteBuffer duplicatedBuffer = this.requestBuf.nioBuffer();
        this.assertBufferContentEquals(duplicatedBuffer, (ReadableBuf)this.requestBuf);
        this.requestBuf.flip();
        duplicatedBuffer.flip();
        this.assertBufferContentEquals(duplicatedBuffer, (ReadableBuf)this.requestBuf);
    }

    @Test
    public void testNioBufferDoesNotModifyReaderIndex() {
        this.requestBuf.position(new Random().nextInt(this.requestBuf.remaining()));
        int initialPosition = this.requestBuf.position();
        this.requestBuf.nioBuffer();
        Assertions.assertEquals((int)initialPosition, (int)this.requestBuf.position());
    }

    @Test
    public void testNioBufferOnEmptyBufferReturnsEmptyByteBuffer() {
        int readableBytes = this.requestBuf.remaining();
        this.requestBuf.position(this.requestBuf.remaining());
        ByteBuffer duplicatedBuffer = this.requestBuf.nioBuffer();
        Assertions.assertEquals((int)0, (int)duplicatedBuffer.remaining());
        duplicatedBuffer.flip();
        this.requestBuf.flip();
        Assertions.assertEquals((int)readableBytes, (int)duplicatedBuffer.remaining());
        this.assertBufferContentEquals(duplicatedBuffer, (ReadableBuf)this.requestBuf);
    }

    @Test
    public void testNioBufferFromMiddleOfTheBuffer() {
        int readableBytes = this.requestBuf.remaining();
        int position = ThreadLocalRandom.current().nextInt(1, this.requestBuf.remaining());
        this.requestBuf.position(position);
        ByteBuffer duplicatedBuffer = this.requestBuf.nioBuffer();
        this.assertBufferContentEquals(duplicatedBuffer, (ReadableBuf)this.requestBuf);
        duplicatedBuffer.flip();
        this.requestBuf.flip();
        Assertions.assertEquals((int)readableBytes, (int)duplicatedBuffer.remaining());
        this.assertBufferContentEquals(duplicatedBuffer, (ReadableBuf)this.requestBuf);
    }

    @Test
    public void testNioBufferFromMiddleOfTheBufferWithModifiedReaderAndWriterIndex() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])serializedRequest);
        byteBuf.setIndex(2, 10);
        ReadableByteBuf readableByteBuf = new ReadableByteBuf(byteBuf);
        int readableBytes = readableByteBuf.remaining();
        Assertions.assertEquals((int)8, (int)readableBytes);
        readableByteBuf.position(3);
        ByteBuffer duplicatedBuffer = readableByteBuf.nioBuffer();
        this.assertBufferContentEquals(duplicatedBuffer, (ReadableBuf)readableByteBuf);
        duplicatedBuffer.flip();
        readableByteBuf.flip();
        Assertions.assertEquals((int)readableBytes, (int)duplicatedBuffer.remaining());
        this.assertBufferContentEquals(duplicatedBuffer, (ReadableBuf)readableByteBuf);
    }

    private void assertBufferContentEquals(ByteBuffer byteBuffer, ReadableBuf readableBuf) {
        Assertions.assertTrue((boolean)byteBuffer.hasRemaining());
        Assertions.assertEquals((int)byteBuffer.remaining(), (int)readableBuf.remaining());
        while (readableBuf.remaining() > 0) {
            Assertions.assertEquals((byte)readableBuf.readByte(), (byte)byteBuffer.get());
        }
    }
}

