/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty.ssl;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.network.ListenerProtocol;
import org.apache.kafka.common.network.netty.ssl.Http2SslContext;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.NettySslEngineFactory;
import org.apache.kafka.common.security.ssl.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class Http2SslContextTest {
    Http2SslContextTest() {
    }

    @Test
    void returnsTrueWhenModeIsClient() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            Assertions.assertTrue((boolean)context.isClient());
        }
    }

    @Test
    void returnsFalseWhenModeIsServer() throws IOException {
        try (Http2SslContext context = Http2SslContext.forServer();){
            Assertions.assertFalse((boolean)context.isClient());
        }
    }

    @Test
    void throwExceptionWhenConfiguredWithIncorrectProtocolForClient() throws IOException {
        Http2SslContext context = Http2SslContext.forClient();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.protocol", "TLSv1.3");
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.configure(configs));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Http2SslContext can only be used with HTTP/2 protocol"));
    }

    @Test
    void throwExceptionWhenConfiguredWithAccpForClient() throws IOException {
        Http2SslContext context = Http2SslContext.forClient();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.protocol", "TLSv1.3");
        configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
        configs.put("confluent.accp.enabled", "true");
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.configure(configs));
        Assertions.assertTrue((boolean)exception.getMessage().contains("ACCP is not compatible with NettySslEngineFactory"));
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void throwExceptionWhenConfiguredWithIncorrectProtocolForServer(SslClientAuth clientAuth) throws IOException {
        Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.protocol", "TLSv1.3");
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.configure(configs));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Http2SslContext can only be used with HTTP/2 protocol"));
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void throwExceptionWhenConfiguredWithAccpForServer(SslClientAuth clientAuth) throws IOException {
        Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.protocol", "TLSv1.3");
        configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
        configs.put("confluent.accp.enabled", "true");
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.configure(configs));
        Assertions.assertTrue((boolean)exception.getMessage().contains("ACCP is not compatible with NettySslEngineFactory"));
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void throwExceptionWhenConfiguredWithMissingSslKeystoreForServer(SslClientAuth clientAuth) throws IOException {
        Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.protocol", "TLSv1.3");
        configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.configure(configs));
        Assertions.assertTrue((boolean)exception.getMessage().contains("SSL keystore must be configured for server mode"));
    }

    @Test
    void throwExceptionWhenConfiguredWithIncorrectClientEngineFactory() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.configure(configs));
            Assertions.assertTrue((boolean)exception.getMessage().contains("SSL engine factory must be of type NettySslEngineFactory"));
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void throwExceptionWhenConfiguredWithIncorrectServerEngineFactory(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            TestUtils.createKeystoreAndSetConfigs(configs);
            ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.configure(configs));
            Assertions.assertTrue((boolean)exception.getMessage().contains("SSL engine factory must be of type NettySslEngineFactory"));
        }
    }

    @Test
    void returnsEmptyCipherSuitesWhenClientSslEngineFactoryIsConfigured() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(configs);
            Assertions.assertTrue((boolean)context.cipherSuites().isEmpty());
        }
    }

    @Test
    void returnsNonEmptyCipherSuitesWhenClientSslEngineFactoryIsConfigured() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            configs.put("ssl.cipher.suites", Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"));
            context.configure(configs);
            Assertions.assertFalse((boolean)context.cipherSuites().isEmpty());
            Assertions.assertEquals(Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"), (Object)context.cipherSuites());
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void returnsEmptyCipherSuitesWhenServerSslEngineFactoryIsConfigured(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            Assertions.assertTrue((boolean)context.cipherSuites().isEmpty());
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void returnsNonEmptyCipherSuitesWhenServerSslEngineFactoryIsConfigured(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            configs.put("ssl.cipher.suites", Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"));
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            Assertions.assertFalse((boolean)context.cipherSuites().isEmpty());
            Assertions.assertEquals(Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"), (Object)context.cipherSuites());
        }
    }

    @Test
    void returnsClientApplicationProtocolNegotiatorWhenModeIsClient() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(configs);
            Assertions.assertNotNull((Object)context.applicationProtocolNegotiator());
            Assertions.assertEquals((Object)"h2", context.applicationProtocolNegotiator().protocols().get(0));
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void returnsClientApplicationProtocolNegotiatorWhenModeIsServer(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            Assertions.assertNotNull((Object)context.applicationProtocolNegotiator());
            Assertions.assertEquals((Object)"h2", context.applicationProtocolNegotiator().protocols().get(0));
        }
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(strings={"", "HTTP2"})
    void createsClientSslEngineWhenModeIsClient(String endpointIdentificationAlgorithm) throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("ssl.endpoint.identification.algorithm", endpointIdentificationAlgorithm);
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(configs);
            SSLEngine engine = context.newEngine(ByteBufAllocator.DEFAULT);
            Assertions.assertNotNull((Object)engine);
            Assertions.assertTrue((boolean)engine.getUseClientMode());
            Assertions.assertNull((Object)engine.getPeerHost());
            Assertions.assertEquals((int)-1, (int)engine.getPeerPort());
            Assertions.assertEquals((Object)endpointIdentificationAlgorithm, (Object)engine.getSSLParameters().getEndpointIdentificationAlgorithm());
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void createsServerSslEngineWhenModeIsServer(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            SSLEngine engine = context.newEngine(ByteBufAllocator.DEFAULT);
            Assertions.assertNotNull((Object)engine);
            Assertions.assertFalse((boolean)engine.getUseClientMode());
            Assertions.assertNull((Object)engine.getPeerHost());
            Assertions.assertEquals((int)-1, (int)engine.getPeerPort());
            Assertions.assertNull((Object)engine.getSSLParameters().getEndpointIdentificationAlgorithm());
            if (clientAuth == SslClientAuth.REQUESTED) {
                Assertions.assertTrue((boolean)engine.getWantClientAuth());
                Assertions.assertFalse((boolean)engine.getNeedClientAuth());
            } else if (clientAuth == SslClientAuth.REQUIRED) {
                Assertions.assertFalse((boolean)engine.getWantClientAuth());
                Assertions.assertTrue((boolean)engine.getNeedClientAuth());
            } else {
                Assertions.assertFalse((boolean)engine.getWantClientAuth());
                Assertions.assertFalse((boolean)engine.getNeedClientAuth());
            }
        }
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(strings={"", "HTTP2"})
    void createsClientSslEngineWithPeerHostAndPortWhenModeIsClient(String endpointIdentificationAlgorithm) throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("ssl.endpoint.identification.algorithm", endpointIdentificationAlgorithm);
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(configs);
            SSLEngine engine = context.newEngine(ByteBufAllocator.DEFAULT, "localhost", 443);
            Assertions.assertNotNull((Object)engine);
            Assertions.assertTrue((boolean)engine.getUseClientMode());
            Assertions.assertEquals((Object)"localhost", (Object)engine.getPeerHost());
            Assertions.assertEquals((int)443, (int)engine.getPeerPort());
            Assertions.assertEquals((Object)endpointIdentificationAlgorithm, (Object)engine.getSSLParameters().getEndpointIdentificationAlgorithm());
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void createsServerSslEngineWithPeerHostAndPortWhenModeIsServer(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            SSLEngine engine = context.newEngine(ByteBufAllocator.DEFAULT, "localhost", 443);
            Assertions.assertNotNull((Object)engine);
            Assertions.assertFalse((boolean)engine.getUseClientMode());
            Assertions.assertEquals((Object)"localhost", (Object)engine.getPeerHost());
            Assertions.assertEquals((int)443, (int)engine.getPeerPort());
            Assertions.assertNull((Object)engine.getSSLParameters().getEndpointIdentificationAlgorithm());
            if (clientAuth == SslClientAuth.REQUESTED) {
                Assertions.assertTrue((boolean)engine.getWantClientAuth());
                Assertions.assertFalse((boolean)engine.getNeedClientAuth());
            } else if (clientAuth == SslClientAuth.REQUIRED) {
                Assertions.assertFalse((boolean)engine.getWantClientAuth());
                Assertions.assertTrue((boolean)engine.getNeedClientAuth());
            } else {
                Assertions.assertFalse((boolean)engine.getWantClientAuth());
                Assertions.assertFalse((boolean)engine.getNeedClientAuth());
            }
        }
    }

    @Test
    void returnsClientSessionContextWhenModeIsClient() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(configs);
            Assertions.assertNotNull((Object)context.sessionContext());
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void returnsServerSessionContextWhenModeIsServer(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            Assertions.assertNotNull((Object)context.sessionContext());
        }
    }

    @Test
    void returnsNonEmptySetWhenReconfigurableConfigsAreAvailable() throws Exception {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("ssl.enabled.protocols", Arrays.asList("TLSv1.2", "TLSv1.3"));
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(configs);
            Assertions.assertTrue((boolean)context.reconfigurableConfigs().containsAll(SslConfigs.RECONFIGURABLE_CONFIGS));
        }
    }

    @Test
    void throwsExceptionWhenReconfigurationHasIncorrectProtocol() throws Exception {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(configs);
            HashMap<String, String> newConfigs = new HashMap<String, String>(configs);
            newConfigs.put("confluent.listener.protocol", ListenerProtocol.TCP.toString());
            ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.validateReconfiguration(newConfigs));
            Assertions.assertTrue((boolean)exception.getMessage().contains("can only be used with HTTP/2 protocol"));
        }
    }

    @Test
    void throwsExceptionWhenReconfigurationHasSslEngineFactoryChange() throws Exception {
        try (Http2SslContext context = Http2SslContext.forServer();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
            newConfigs.put("ssl.engine.factory.class", DefaultSslEngineFactory.class);
            ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.validateReconfiguration(newConfigs));
            Assertions.assertTrue((boolean)exception.getMessage().contains("SSL engine factory must be of type NettySslEngineFactory"));
        }
    }

    @Test
    void validatesReconfigurationSuccessfullyWithCorrectConfigs() throws Exception {
        try (Http2SslContext context = Http2SslContext.forServer();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
            newConfigs.put("ssl.cipher.suites", Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"));
            Assertions.assertDoesNotThrow(() -> context.validateReconfiguration(newConfigs));
        }
    }

    @Test
    void reconfiguresSuccessfullyWithValidConfigs() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> initialConfigs = new HashMap<String, Object>();
            initialConfigs.put("ssl.protocol", "TLSv1.3");
            initialConfigs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            initialConfigs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(initialConfigs);
            Assertions.assertTrue((boolean)context.cipherSuites().isEmpty());
            HashMap<String, List<String>> newConfigs = new HashMap<String, List<String>>(initialConfigs);
            newConfigs.put("ssl.cipher.suites", Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"));
            Assertions.assertDoesNotThrow(() -> context.reconfigure(newConfigs));
            Assertions.assertFalse((boolean)context.cipherSuites().isEmpty());
            Assertions.assertEquals(Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"), (Object)context.cipherSuites());
        }
    }

    @Test
    void throwsExceptionWhenReconfiguringWithIncorrectProtocol() throws IOException {
        try (Http2SslContext context = Http2SslContext.forClient();){
            HashMap<String, Object> initialConfigs = new HashMap<String, Object>();
            initialConfigs.put("ssl.protocol", "TLSv1.3");
            initialConfigs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            initialConfigs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            context.configure(initialConfigs);
            HashMap<String, String> invalidConfigs = new HashMap<String, String>(initialConfigs);
            invalidConfigs.put("confluent.listener.protocol", ListenerProtocol.TCP.toString());
            ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.reconfigure(invalidConfigs));
            Assertions.assertTrue((boolean)exception.getMessage().contains("can only be used with HTTP/2 protocol"));
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void throwsExceptionWhenReconfiguringWithoutKeystoreInServerMode(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> initialConfigs = new HashMap<String, Object>();
            initialConfigs.put("ssl.protocol", "TLSv1.3");
            initialConfigs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            initialConfigs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(initialConfigs);
            context.configure(initialConfigs);
            HashMap<String, Object> invalidConfigs = new HashMap<String, Object>(initialConfigs);
            invalidConfigs.remove("ssl.keystore.location");
            ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> context.reconfigure(invalidConfigs));
            Assertions.assertTrue((boolean)exception.getMessage().contains("SSL keystore must be configured for server mode"));
        }
    }

    @ParameterizedTest
    @NullSource
    @EnumSource(value=SslClientAuth.class)
    void reconfiguresSuccessfullyWithValidConfigsInServerMode(SslClientAuth clientAuth) throws Exception {
        try (Http2SslContext context = Http2SslContextTest.getServerContext(clientAuth);){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            Assertions.assertTrue((boolean)context.cipherSuites().isEmpty());
            HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
            newConfigs.put("ssl.cipher.suites", Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"));
            Assertions.assertDoesNotThrow(() -> context.reconfigure(newConfigs));
            Assertions.assertFalse((boolean)context.cipherSuites().isEmpty());
            Assertions.assertEquals(Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"), (Object)context.cipherSuites());
        }
    }

    @Test
    void reconfiguresSuccessfullyWithValidSslClientAuthConfigsInServerMode() throws Exception {
        try (Http2SslContext context = Http2SslContext.forServer();){
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("ssl.protocol", "TLSv1.3");
            configs.put("confluent.listener.protocol", ListenerProtocol.HTTP2.toString());
            configs.put("ssl.engine.factory.class", NettySslEngineFactory.class);
            TestUtils.createKeystoreAndSetConfigs(configs);
            context.configure(configs);
            SSLEngine engine = context.newEngine(ByteBufAllocator.DEFAULT);
            Assertions.assertNotNull((Object)engine);
            Assertions.assertFalse((boolean)engine.getUseClientMode());
            Assertions.assertNull((Object)engine.getPeerHost());
            Assertions.assertEquals((int)-1, (int)engine.getPeerPort());
            Assertions.assertNull((Object)engine.getSSLParameters().getEndpointIdentificationAlgorithm());
            Assertions.assertFalse((boolean)engine.getWantClientAuth());
            Assertions.assertFalse((boolean)engine.getNeedClientAuth());
            HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
            newConfigs.put("ssl.client.auth", SslClientAuth.REQUESTED.toString());
            Assertions.assertDoesNotThrow(() -> context.reconfigure(newConfigs));
            SSLEngine newEngine = context.newEngine(ByteBufAllocator.DEFAULT);
            Assertions.assertNotNull((Object)newEngine);
            Assertions.assertFalse((boolean)newEngine.getUseClientMode());
            Assertions.assertNull((Object)newEngine.getPeerHost());
            Assertions.assertEquals((int)-1, (int)newEngine.getPeerPort());
            Assertions.assertNull((Object)newEngine.getSSLParameters().getEndpointIdentificationAlgorithm());
            Assertions.assertTrue((boolean)newEngine.getWantClientAuth());
            Assertions.assertFalse((boolean)newEngine.getNeedClientAuth());
        }
    }

    private static Http2SslContext getServerContext(SslClientAuth clientAuth) {
        return Http2SslContext.forServer((String)(clientAuth == null ? null : clientAuth.toString()));
    }
}

