/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.Record;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlRecordUtilsTest {
    @Test
    public void testCurrentVersions() {
        Assertions.assertEquals((short)0, (short)0);
        Assertions.assertEquals((short)0, (short)0);
        Assertions.assertEquals((short)0, (short)0);
        Assertions.assertEquals((short)0, (short)0);
        Assertions.assertEquals((short)0, (short)0);
    }

    @Test
    public void testInvalidControlRecordType() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.testDeserializeRecord(ControlRecordType.COMMIT));
        Assertions.assertEquals((Object)"Expected KRAFT_VOTERS control record type(6), but found COMMIT", (Object)thrown.getMessage());
    }

    @Test
    public void testDeserializeByteData() {
        this.testDeserializeRecord(ControlRecordType.KRAFT_VOTERS);
    }

    private void testDeserializeRecord(ControlRecordType controlRecordType) {
        boolean voterId = false;
        List<VotersRecord.Voter> voters = Collections.singletonList(new VotersRecord.Voter().setVoterId(0));
        VotersRecord data = new VotersRecord().setVoters(voters);
        ByteBuffer valueBuffer = ByteBuffer.allocate(256);
        data.write((Writable)new ByteBufferAccessor(valueBuffer), new ObjectSerializationCache(), data.highestSupportedVersion());
        valueBuffer.flip();
        byte[] keyData = new byte[]{0, 0, 0, (byte)controlRecordType.type()};
        DefaultRecord record = new DefaultRecord(256, 0, 0L, 0L, 0, ByteBuffer.wrap(keyData), valueBuffer, null);
        VotersRecord deserializedData = ControlRecordUtils.deserializeVotersRecord((Record)record);
        Assertions.assertEquals(voters, (Object)deserializedData.voters());
        Assertions.assertEquals(Collections.singletonList(new VotersRecord.Voter().setVoterId(0)), (Object)deserializedData.voters());
    }
}

