/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterBrokerHealthRequestTest {
    @Test
    public void testBrokerIdValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithBrokerIds(Arrays.asList(-1)));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithBrokerIds(Collections.emptyList()));
        this.validateRequestWithBrokerIds(Arrays.asList(1, 2));
    }

    @Test
    public void testReasonValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithReason("."));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithReason("$3"));
        this.validateRequestWithReason("valid-reason");
        this.validateRequestWithReason("valid-reason_123");
        this.validateRequestWithReason("7158");
        this.validateRequestWithReason("valid reason");
    }

    @Test
    public void testStatusCodeValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateStatusCode((byte)2));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateStatusCode((byte)100));
        this.validateStatusCode(ComponentHealthStatus.DEGRADED.id());
        this.validateStatusCode(ComponentHealthStatus.HEALTHY.id());
    }

    @Test
    public void testComponentCodeValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateComponentCode((byte)4));
        this.validateComponentCode(BrokerComponent.UNSPECIFIED.id());
        this.validateComponentCode(BrokerComponent.STORAGE.id());
        this.validateComponentCode(BrokerComponent.NETWORK.id());
        this.validateComponentCode(BrokerComponent.EXTERNAL_CONNECTIVITY_STARTUP.id());
    }

    @Test
    public void testEpochValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateEpoch(Arrays.asList(0, 1), 1L));
        this.validateEpoch(Arrays.asList(0), 1L);
    }

    @Test
    public void testComponentCodeDowngrade() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateComponentCodeDowngrade(BrokerComponent.STORAGE.id(), (short)2));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateComponentCodeDowngrade(BrokerComponent.NETWORK.id(), (short)3));
    }

    @Test
    public void testErrorCountsFromErrorResponse() {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(1, 2)).setReason("test").setStatusCode(ComponentHealthStatus.DEGRADED.id());
        AlterBrokerHealthResponse response = ((AlterBrokerHealthRequest)new AlterBrokerHealthRequest.Builder(data).build()).getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    private void validateRequestWithReason(String reason) {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0)).setReason(reason).setStatusCode(ComponentHealthStatus.DEGRADED.id());
        ((AlterBrokerHealthRequest)new AlterBrokerHealthRequest.Builder(data).build()).validate();
    }

    private void validateStatusCode(byte code) {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0)).setReason("test").setStatusCode(code);
        ((AlterBrokerHealthRequest)new AlterBrokerHealthRequest.Builder(data).build()).validate();
    }

    private void validateComponentCode(byte code) {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0)).setReason("test").setComponentCode(code).setStatusCode(ComponentHealthStatus.DEGRADED.id());
        ((AlterBrokerHealthRequest)new AlterBrokerHealthRequest.Builder(data).build()).validate();
    }

    private void validateEpoch(List<Integer> brokers, long epoch) {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(brokers).setReason("test").setBrokerEpoch(epoch).setStatusCode(ComponentHealthStatus.DEGRADED.id());
        ((AlterBrokerHealthRequest)new AlterBrokerHealthRequest.Builder(data).build()).validate();
    }

    private void validateComponentCodeDowngrade(byte code, short version) {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0)).setReason("test").setComponentCode(code).setStatusCode(ComponentHealthStatus.DEGRADED.id());
        new AlterBrokerHealthRequest.Builder(data).build(version).validate();
    }

    private void validateRequestWithBrokerIds(List<Integer> brokerIds) {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(brokerIds).setReason("test").setStatusCode(ComponentHealthStatus.DEGRADED.id());
        ((AlterBrokerHealthRequest)new AlterBrokerHealthRequest.Builder(data).build()).validate();
    }
}

