/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterBrokerReplicaExclusionsRequestTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        AlterBrokerReplicaExclusionsRequest request = (AlterBrokerReplicaExclusionsRequest)new AlterBrokerReplicaExclusionsRequest.Builder().addExclusion(1, new ExclusionOp(ExclusionOp.OpType.SET)).addExclusion(2, new ExclusionOp(ExclusionOp.OpType.SET)).addExclusion(3, new ExclusionOp(ExclusionOp.OpType.SET)).addExclusion(4, new ExclusionOp(ExclusionOp.OpType.DELETE)).build();
        AlterBrokerReplicaExclusionsResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 4), (Object)response.errorCounts());
    }

    @Test
    public void testBuildThrowsIfNoExclusionsGiven() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AlterBrokerReplicaExclusionsRequest.Builder().build());
    }

    @Test
    public void testBuilderAddExclusionThrowsIfDuplicateIdGiven() {
        AlterBrokerReplicaExclusionsRequest.Builder builder = new AlterBrokerReplicaExclusionsRequest.Builder();
        builder.addExclusion(1, new ExclusionOp(ExclusionOp.OpType.SET)).addExclusion(2, new ExclusionOp(ExclusionOp.OpType.SET)).addExclusion(3, new ExclusionOp(ExclusionOp.OpType.DELETE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.addExclusion(1, new ExclusionOp(ExclusionOp.OpType.SET)));
    }
}

