/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterBrokerReplicaExclusionsResponseTest {
    @Test
    public void testErrorCountsWithExclusionLevelErrors() {
        AlterBrokerReplicaExclusionsResponseData data = new AlterBrokerReplicaExclusionsResponseData().setWasApplied(true).setBrokerExclusions(Arrays.asList(new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(1).setExclusionErrorCode(Errors.NONE.code()).setExclusionOperationCode(ExclusionOp.OpType.SET.id()), new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(2).setExclusionErrorCode(Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND.code()).setExclusionErrorMessage("error").setExclusionOperationCode(ExclusionOp.OpType.DELETE.id()), new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(3).setExclusionErrorCode(Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND.code()).setExclusionErrorMessage("error 2").setExclusionOperationCode(ExclusionOp.OpType.DELETE.id()), new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(4).setExclusionErrorCode(Errors.CORRUPT_MESSAGE.code()).setExclusionErrorMessage("another error").setExclusionOperationCode(ExclusionOp.OpType.SET.id()))).setErrorCode(Errors.NONE.code());
        AlterBrokerReplicaExclusionsResponse response = new AlterBrokerReplicaExclusionsResponse(data);
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)3, (int)errorCounts.size());
        Assertions.assertEquals((int)2, (Integer)((Integer)errorCounts.get(Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND)));
        Assertions.assertEquals((int)1, (Integer)((Integer)errorCounts.get(Errors.CORRUPT_MESSAGE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)errorCounts.get(Errors.NONE)));
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        AlterBrokerReplicaExclusionsResponseData data = new AlterBrokerReplicaExclusionsResponseData().setWasApplied(true).setBrokerExclusions(Arrays.asList(new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(1).setExclusionErrorCode(Errors.NONE.code()).setExclusionOperationCode(ExclusionOp.OpType.SET.id()), new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(2).setExclusionErrorCode(Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND.code()).setExclusionErrorMessage("error").setExclusionOperationCode(ExclusionOp.OpType.DELETE.id()))).setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("not controller!");
        AlterBrokerReplicaExclusionsResponse response = new AlterBrokerReplicaExclusionsResponse(data);
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((int)2, (Integer)((Integer)errorCounts.get(Errors.NOT_CONTROLLER)));
    }

    @Test
    public void testErrorCountsWithNoErrors() {
        AlterBrokerReplicaExclusionsResponseData data = new AlterBrokerReplicaExclusionsResponseData().setWasApplied(true).setBrokerExclusions(Arrays.asList(new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(1).setExclusionErrorCode(Errors.NONE.code()).setExclusionOperationCode(ExclusionOp.OpType.SET.id()), new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(2).setExclusionErrorCode(Errors.NONE.code()).setExclusionOperationCode(ExclusionOp.OpType.DELETE.id()))).setErrorCode(Errors.NONE.code());
        AlterBrokerReplicaExclusionsResponse response = new AlterBrokerReplicaExclusionsResponse(data);
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((int)2, (Integer)((Integer)errorCounts.get(Errors.NONE)));
    }
}

