/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.kafka.common.requests.K2RequestContextImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class K2RequestContextTest {
    private K2RequestContextImpl requestContext;

    @BeforeEach
    void setUp() {
        this.requestContext = new K2RequestContextImpl();
    }

    @Test
    void testBatchEnqueueTime() {
        Assertions.assertEquals((long)-1L, (long)this.requestContext.batchEnqueueTime(), (String)"Initial batchEnqueueTime should be null");
        Long t = System.nanoTime();
        this.requestContext.setBatchEnqueueTime(t.longValue());
        Assertions.assertEquals((Long)t, (long)this.requestContext.batchEnqueueTime(), (String)"batchEnqueueTime should be set correctly");
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> this.requestContext.setBatchEnqueueTime(System.currentTimeMillis()), (String)"batchEnqueueTime should not be set more than once");
    }

    @Test
    void testWriteRecordsMs() {
        Assertions.assertEquals((long)-1L, (long)this.requestContext.writeRecordsMs(), (String)"Initial writeRecordsMs should be null");
        Long duration = 150L;
        this.requestContext.updateWriteRecordsMs(duration.longValue());
        Assertions.assertEquals((Long)duration, (long)this.requestContext.writeRecordsMs(), (String)"writeRecordsMs should be set correctly");
        this.requestContext.updateWriteRecordsMs(duration - 10L);
        Assertions.assertEquals((Long)duration, (long)this.requestContext.writeRecordsMs(), (String)"writeRecordsMs should only be updated to a larger value");
        this.requestContext.updateWriteRecordsMs(duration + 10L);
        Assertions.assertEquals((long)(duration + 10L), (long)this.requestContext.writeRecordsMs(), (String)"writeRecordsMs should only be updated to a larger value");
    }

    @Test
    void testTimeInBatchMs() {
        Assertions.assertEquals((long)-1L, (long)this.requestContext.timeInBatchMs(), (String)"Initial timeInBatchMs should be null");
        Long duration = 200L;
        this.requestContext.updateTimeInBatchMs(duration.longValue());
        Assertions.assertEquals((Long)duration, (long)this.requestContext.timeInBatchMs(), (String)"timeInBatchMs should be set correctly");
        this.requestContext.updateTimeInBatchMs(duration - 10L);
        Assertions.assertEquals((Long)duration, (long)this.requestContext.timeInBatchMs(), (String)"timeInBatchMs should only be updated to a larger value");
        this.requestContext.updateTimeInBatchMs(duration + 10L);
        Assertions.assertEquals((long)(duration + 10L), (long)this.requestContext.timeInBatchMs(), (String)"timeInBatchMs should only be updated to a larger value");
    }

    @Test
    void testAppendDataRefsMs() {
        Assertions.assertEquals((long)-1L, (long)this.requestContext.appendDataRefsMs(), (String)"Initial appendDataRefsMs should be null");
        Long duration = 50L;
        this.requestContext.updateAppendDataRefsMs(duration.longValue());
        Assertions.assertEquals((Long)duration, (long)this.requestContext.appendDataRefsMs(), (String)"appendDataRefsMs should be set correctly");
        this.requestContext.updateAppendDataRefsMs(duration - 5L);
        Assertions.assertEquals((Long)duration, (long)this.requestContext.appendDataRefsMs(), (String)"appendDataRefsMs should only be updated to a larger value");
        this.requestContext.updateAppendDataRefsMs(duration + 5L);
        Assertions.assertEquals((long)(duration + 5L), (long)this.requestContext.appendDataRefsMs(), (String)"appendDataRefsMs should only be updated to a larger value");
    }

    @Test
    void testFetchDataRefsMs() {
        Assertions.assertEquals((long)-1L, (long)this.requestContext.fetchDataRefsMs(), (String)"Initial fetchDataRefsMs should be null");
        Long duration = 75L;
        this.requestContext.updateFetchDataRefsMs(duration.longValue());
        Assertions.assertEquals((Long)duration, (long)this.requestContext.fetchDataRefsMs(), (String)"fetchDataRefsMs should be set correctly");
        this.requestContext.updateFetchDataRefsMs(duration - 10L);
        Assertions.assertEquals((Long)duration, (long)this.requestContext.fetchDataRefsMs(), (String)"fetchDataRefsMs should only be updated to a larger value");
        this.requestContext.updateFetchDataRefsMs(duration + 10L);
        Assertions.assertEquals((long)(duration + 10L), (long)this.requestContext.fetchDataRefsMs(), (String)"fetchDataRefsMs should only be updated to a larger value");
    }

    @Test
    void testFetchRecordsMs() {
        Assertions.assertEquals((long)-1L, (long)this.requestContext.fetchRecordsMs(), (String)"Initial fetchRecordsMs should be null");
        Long duration = 120L;
        this.requestContext.updateFetchRecordsMs(duration.longValue());
        Assertions.assertEquals((Long)duration, (long)this.requestContext.fetchRecordsMs(), (String)"fetchRecordsMs should be set correctly");
        this.requestContext.updateFetchRecordsMs(duration - 15L);
        Assertions.assertEquals((Long)duration, (long)this.requestContext.fetchRecordsMs(), (String)"fetchRecordsMs should only be updated to a larger value");
        this.requestContext.updateFetchRecordsMs(duration + 15L);
        Assertions.assertEquals((long)(duration + 15L), (long)this.requestContext.fetchRecordsMs(), (String)"fetchRecordsMs should only be updated to a larger value");
    }

    @Test
    void testNumDataRefsFetched() {
        Assertions.assertEquals((int)-1, (int)this.requestContext.numDataRefsFetched(), (String)"Initial numDataRefsFetched should be 0");
        int count = 10;
        this.requestContext.setNumDataRefsFetched(count);
        Assertions.assertEquals((int)count, (int)this.requestContext.numDataRefsFetched(), (String)"numDataRefsFetched should be set correctly");
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> this.requestContext.setNumDataRefsFetched(20), (String)"numDataRefsFetched should not be set more than once");
    }

    @Test
    void testToJsonNode() {
        Long batchEntryTs = System.currentTimeMillis();
        Long timeS3 = 10L;
        Long timeBatch = 20L;
        Long timeCommit = 30L;
        Long timeFetchRef = 40L;
        Long timeFetchRec = 50L;
        int numRefs = 5;
        this.requestContext.setBatchEnqueueTime(batchEntryTs.longValue());
        this.requestContext.updateWriteRecordsMs(timeS3.longValue());
        this.requestContext.updateTimeInBatchMs(timeBatch.longValue());
        this.requestContext.updateAppendDataRefsMs(timeCommit.longValue());
        this.requestContext.updateFetchDataRefsMs(timeFetchRef.longValue());
        this.requestContext.updateFetchRecordsMs(timeFetchRec.longValue());
        this.requestContext.setNumDataRefsFetched(numRefs);
        JsonNode jsonNode = this.requestContext.toJsonNode();
        Assertions.assertNotNull((Object)jsonNode);
        Assertions.assertNull((Object)jsonNode.get("batchEnqueueTs"));
        Assertions.assertEquals((Long)timeS3, (long)jsonNode.get("writeRecordsMs").asLong());
        Assertions.assertEquals((Long)timeBatch, (long)jsonNode.get("timeInBatchMs").asLong());
        Assertions.assertEquals((Long)timeCommit, (long)jsonNode.get("appendDataRefsMs").asLong());
        Assertions.assertEquals((Long)timeFetchRef, (long)jsonNode.get("fetchDataRefsMs").asLong());
        Assertions.assertEquals((Long)timeFetchRec, (long)jsonNode.get("fetchRecordsMs").asLong());
        Assertions.assertEquals((int)numRefs, (int)jsonNode.get("numDataRefsFetched").asInt());
    }

    @Test
    void testToJsonNodeWithNulls() {
        this.requestContext.setBatchEnqueueTime(System.nanoTime());
        this.requestContext.setNumDataRefsFetched(5);
        JsonNode jsonNode = this.requestContext.toJsonNode();
        Assertions.assertNotNull((Object)jsonNode);
        Assertions.assertEquals((int)1, (int)jsonNode.size());
        Assertions.assertEquals((int)5, (int)jsonNode.get("numDataRefsFetched").asInt());
        Assertions.assertNull((Object)jsonNode.get("writeRecordsMs"));
    }

    @Test
    void testToString() {
        String str = this.requestContext.toString();
        Assertions.assertEquals((Object)"", (Object)str);
        this.requestContext.setNumDataRefsFetched(5);
        str = this.requestContext.toString();
        Assertions.assertEquals((Object)"numDataRefsFetched=5", (Object)str, (String)"toString() should contain numDataRefsFetched");
        this.requestContext.updateAppendDataRefsMs(50L);
        str = this.requestContext.toString();
        Assertions.assertEquals((Object)"appendDataRefsMs=50, numDataRefsFetched=5", (Object)str, (String)"toString() should contain numDataRefsFetched");
    }
}

