/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;

public class OffsetFetchResponseTest {
    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testBuilderWithSingleGroup(short version) {
        OffsetFetchResponseData.OffsetFetchResponseGroup group = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata")))));
        if (version < 8) {
            Assertions.assertEquals((Object)new OffsetFetchResponseData().setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata"))))), (Object)new OffsetFetchResponse.Builder(group).build(version).data());
        } else {
            Assertions.assertEquals((Object)new OffsetFetchResponseData().setGroups(List.of(group)), (Object)new OffsetFetchResponse.Builder(group).build(version).data());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testBuilderWithMultipleGroups(short version) {
        List<OffsetFetchResponseData.OffsetFetchResponseGroup> groups = List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group1").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata"))))), new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group2").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("bar").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata"))))));
        if (version < 8) {
            Assertions.assertThrows(UnsupportedVersionException.class, () -> new OffsetFetchResponse.Builder(groups).build(version));
        } else {
            Assertions.assertEquals((Object)new OffsetFetchResponseData().setGroups(groups), (Object)new OffsetFetchResponse.Builder(groups).build(version).data());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testGroupWithSingleGroup(short version) {
        OffsetFetchResponseData data = new OffsetFetchResponseData();
        if (version < 8) {
            data.setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata")))));
        } else {
            data.setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("foo").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata")))))));
        }
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("foo").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata"))))), (Object)new OffsetFetchResponse(data, version).group("foo"));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH, fromVersion=8)
    public void testGroupWithMultipleGroups(short version) {
        List<OffsetFetchResponseData.OffsetFetchResponseGroup> groups = List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group1").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata"))))), new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group2").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("bar").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setCommittedLeaderEpoch(5).setMetadata("metadata"))))));
        OffsetFetchResponse response = new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(groups), version);
        groups.forEach(group -> Assertions.assertEquals((Object)group, (Object)response.group(group.groupId())));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testGroupWithSingleGroupWithTopLevelError(short version) {
        OffsetFetchResponseData data = new OffsetFetchResponseData();
        if (version < 2) {
            data.setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(0).setErrorCode(Errors.INVALID_GROUP_ID.code())))));
        } else if (version < 8) {
            data.setErrorCode(Errors.INVALID_GROUP_ID.code());
        } else {
            data.setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("foo").setErrorCode(Errors.INVALID_GROUP_ID.code())));
        }
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("foo").setErrorCode(Errors.INVALID_GROUP_ID.code()), (Object)new OffsetFetchResponse(data, version).group("foo"));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testSingleGroupWithError(short version) {
        OffsetFetchRequestData.OffsetFetchRequestGroup group = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setPartitionIndexes(List.of(Integer.valueOf(0)))));
        if (version < 2) {
            Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group1").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setErrorCode(Errors.INVALID_GROUP_ID.code()).setCommittedOffset(-1L).setMetadata("").setCommittedLeaderEpoch(-1))))), (Object)OffsetFetchResponse.groupError((OffsetFetchRequestData.OffsetFetchRequestGroup)group, (Errors)Errors.INVALID_GROUP_ID, (int)version));
        } else {
            Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group1").setErrorCode(Errors.INVALID_GROUP_ID.code()), (Object)OffsetFetchResponse.groupError((OffsetFetchRequestData.OffsetFetchRequestGroup)group, (Errors)Errors.INVALID_GROUP_ID, (int)version));
        }
    }
}

