/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.message.RemoveBrokersResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RemoveBrokersResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoveBrokersResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        HashSet<RemoveBrokersRequestData.BrokerId> brokerIds = new HashSet<RemoveBrokersRequestData.BrokerId>();
        brokerIds.add(new RemoveBrokersRequestData.BrokerId().setBrokerId(1));
        brokerIds.add(new RemoveBrokersRequestData.BrokerId().setBrokerId(2));
        RemoveBrokersRequest request = (RemoveBrokersRequest)new RemoveBrokersRequest.Builder(brokerIds, true).build();
        RemoveBrokersResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse> removeBrokerResponses = new ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse>();
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(1).setErrorCode(Errors.BROKER_NOT_AVAILABLE.code()));
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(2).setErrorCode(Errors.REASSIGNMENT_IN_PROGRESS.code()));
        RemoveBrokersResponse response = new RemoveBrokersResponse(new RemoveBrokersResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setBrokersToRemove(removeBrokerResponses));
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse> removeBrokerResponses = new ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse>();
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(1).setErrorCode(Errors.BROKER_NOT_AVAILABLE.code()));
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(2).setErrorCode(Errors.REASSIGNMENT_IN_PROGRESS.code()));
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(3).setErrorCode(Errors.REASSIGNMENT_IN_PROGRESS.code()));
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(4));
        RemoveBrokersResponse response = new RemoveBrokersResponse(new RemoveBrokersResponseData().setErrorCode(Errors.NONE.code()).setBrokersToRemove(removeBrokerResponses));
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)3, (int)errorCounts.size());
        Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.NONE)));
        Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.BROKER_NOT_AVAILABLE)));
        Assertions.assertEquals((int)2, (int)((Integer)errorCounts.get(Errors.REASSIGNMENT_IN_PROGRESS)));
    }

    @Test
    public void testToString() {
        ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse> removeBrokerResponses = new ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse>();
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(1));
        removeBrokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(2).setErrorCode(Errors.REASSIGNMENT_IN_PROGRESS.code()));
        RemoveBrokersResponse response = new RemoveBrokersResponse(new RemoveBrokersResponseData().setBrokersToRemove(removeBrokerResponses));
        String responseStr = response.toString();
        Assertions.assertTrue((boolean)responseStr.contains(RemoveBrokersResponse.class.getSimpleName()));
        Assertions.assertTrue((boolean)responseStr.contains(((Object)removeBrokerResponses).toString()));
        Assertions.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NONE.code()));
    }
}

