/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.DelayableValidateCallbackHandler;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslAuthenticatorTest;
import org.apache.kafka.common.security.authenticator.TestDigestLoginModule;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SaslAuthenticatorAsyncTest {
    private static final int BUFFER_SIZE = 4096;
    private static final long CONNECTIONS_MAX_REAUTH_MS_VALUE = 100000L;
    private static Time time = Time.SYSTEM;
    private NioEchoServer server;
    private CertStores serverCertStores;
    private CertStores clientCertStores;
    private Map<String, Object> saslClientConfigs;
    private Map<String, Object> saslServerConfigs;
    private CredentialCache credentialCache;

    @BeforeEach
    public void setup() throws Exception {
        LoginManager.closeAll();
        time = Time.SYSTEM;
        this.serverCertStores = new CertStores(true, "localhost");
        this.clientCertStores = new CertStores(false, "localhost");
        this.saslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.saslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.saslServerConfigs.put("ssl.engine.factory.class", DefaultSslEngineFactory.class);
        this.saslClientConfigs.put("ssl.engine.factory.class", DefaultSslEngineFactory.class);
        this.credentialCache = new CredentialCache();
        SaslAuthenticatorTest.TestLogin.loginCount.set(0);
    }

    private TestJaasConfig configureMechanisms(String clientMechanism, List<String> serverMechanisms) {
        this.saslClientConfigs.put("sasl.mechanism", clientMechanism);
        this.saslServerConfigs.put("sasl.enabled.mechanisms", serverMechanisms);
        this.saslServerConfigs.put("connections.max.reauth.ms", 100000L);
        if (serverMechanisms.contains("DIGEST-MD5")) {
            this.saslServerConfigs.put("digest-md5.sasl.server.callback.handler.class", TestDigestLoginModule.DigestServerCallbackHandler.class.getName());
        }
        return TestJaasConfig.createConfiguration(clientMechanism, serverMechanisms);
    }

    private NioEchoServer createEchoServer(SecurityProtocol securityProtocol) throws Exception {
        return this.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol) throws Exception {
        return NetworkTestUtils.createEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.saslServerConfigs), this.credentialCache, time);
    }

    private Selector createClientConnection(SecurityProtocol securityProtocol, String node) throws Exception {
        Selector selector = this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        selector.connect(node, addr, 4096, 4096);
        return selector;
    }

    private Selector createSelector(SecurityProtocol securityProtocol, Map<String, Object> clientConfigs) {
        String saslMechanism = (String)this.saslClientConfigs.get("sasl.mechanism");
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)securityProtocol, (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig(clientConfigs), null, (String)saslMechanism, (Time)time, (LogContext)new LogContext());
        return NetworkTestUtils.createSelector(channelBuilder, time);
    }

    @Test
    public void testAsyncAuthInitialAuthTimeouts() throws Exception {
        int numSuccessConnections = 4;
        int numTimeoutConnections = 2;
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("OAUTHBEARER", Collections.singletonList("OAUTHBEARER"));
        ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        this.saslServerConfigs.put(listener.saslMechanismConfigPrefix("OAUTHBEARER") + "sasl.server.callback.handler.class", DelayableValidateCallbackHandler.class);
        this.saslServerConfigs.put("sasl.server.authn.async.enable", true);
        this.saslServerConfigs.put("sasl.server.authn.async.timeout.ms", 250L);
        this.saslServerConfigs.put("delayMs", "500");
        this.saslServerConfigs.put("numDelayConnections", Integer.toString(numTimeoutConnections));
        this.saslServerConfigs.put("interruptBehavior", DelayableValidateCallbackHandler.InterruptBehavior.error.toString());
        this.server = this.createEchoServer(securityProtocol);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < numTimeoutConnections + numSuccessConnections; ++i) {
            int finalI = i;
            if (i == numTimeoutConnections) {
                TestUtils.waitForCondition(() -> NetworkTestUtils.numAsyncInFlightTasks(this.server.selector()) == numTimeoutConnections, "All delayed tasks are inFlight");
            }
            Thread t2 = new Thread(() -> {
                try (Selector selector = null;){
                    String node = Integer.toString(finalI);
                    selector = this.createClientConnection(securityProtocol, node);
                    if (finalI < numTimeoutConnections) {
                        NetworkTestUtils.waitForChannelClose(selector, node, ChannelState.State.AUTHENTICATION_FAILED);
                    } else {
                        NetworkTestUtils.checkClientConnection(selector, node, 100, 10);
                    }
                }
            });
            threads.add(t2);
            t2.start();
        }
        threads.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        this.server.verifyAuthenticationMetrics(numSuccessConnections, numTimeoutConnections);
        this.server.verifyAuthenticationMetricsForMechanism(numSuccessConnections, numTimeoutConnections, "OAUTHBEARER");
        this.server.waitForMetrics("timed-out-authentication", numTimeoutConnections, EnumSet.of(NioEchoServer.MetricType.TOTAL, NioEchoServer.MetricType.RATE));
    }
}

