/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.DefaultJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.DefaultJwtValidator;
import org.apache.kafka.common.security.oauthbearer.FileJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerLoginCallbackHandlerTest
extends OAuthBearerTest {
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleTokenCallback() throws Exception {
        Map<String, ?> configs = this.getSaslConfigs();
        AccessTokenBuilder builder = new AccessTokenBuilder().jwk(this.createRsaJwk()).alg("RS256");
        String accessToken = builder.build();
        JwtRetriever jwtRetriever = () -> accessToken;
        DefaultJwtValidator jwtValidator = OAuthBearerLoginCallbackHandlerTest.createJwtValidator();
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(), jwtRetriever, (JwtValidator)jwtValidator);
        try (OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();){
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            handler.handle(new Callback[]{callback});
            Assertions.assertNotNull((Object)callback.token());
            OAuthBearerToken token = callback.token();
            Assertions.assertEquals((Object)accessToken, (Object)token.value());
            Assertions.assertEquals((Object)builder.subject(), (Object)token.principalName());
            Assertions.assertEquals((long)(builder.expirationSeconds() * 1000L), (long)token.lifetimeMs());
            Assertions.assertEquals((long)(builder.issuedAtSeconds() * 1000L), (Long)token.startTimeMs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleSaslExtensionsCallback() throws Exception {
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", "http://www.example.com");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", "http://www.example.com");
        HashMap<String, Object> jaasConfig = new HashMap<String, Object>();
        jaasConfig.put("clientId", "an ID");
        jaasConfig.put("clientSecret", "a secret");
        jaasConfig.put("extension_foo", "1");
        jaasConfig.put("extension_bar", 2);
        jaasConfig.put("EXTENSION_baz", "3");
        DefaultJwtRetriever jwtRetriever = OAuthBearerLoginCallbackHandlerTest.createJwtRetriever();
        DefaultJwtValidator jwtValidator = OAuthBearerLoginCallbackHandlerTest.createJwtValidator();
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(jaasConfig), (JwtRetriever)jwtRetriever, (JwtValidator)jwtValidator);
        try (OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();){
            SaslExtensionsCallback callback = new SaslExtensionsCallback();
            handler.handle(new Callback[]{callback});
            Assertions.assertNotNull((Object)callback.extensions());
            Map extensions = callback.extensions().map();
            Assertions.assertEquals((Object)"1", extensions.get("foo"));
            Assertions.assertEquals((Object)"2", extensions.get("bar"));
            Assertions.assertNull(extensions.get("baz"));
            Assertions.assertEquals((int)2, (int)extensions.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleSaslExtensionsCallbackWithInvalidExtension() {
        String illegalKey = "extension_auth";
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", "http://www.example.com");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", "http://www.example.com");
        HashMap<String, String> jaasConfig = new HashMap<String, String>();
        jaasConfig.put("clientId", "an ID");
        jaasConfig.put("clientSecret", "a secret");
        jaasConfig.put(illegalKey, "this key isn't allowed per OAuthBearerClientInitialResponse.validateExtensions");
        DefaultJwtRetriever jwtRetriever = OAuthBearerLoginCallbackHandlerTest.createJwtRetriever();
        DefaultJwtValidator jwtValidator = OAuthBearerLoginCallbackHandlerTest.createJwtValidator();
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(jaasConfig), (JwtRetriever)jwtRetriever, (JwtValidator)jwtValidator);
        try (OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();){
            SaslExtensionsCallback callback = new SaslExtensionsCallback();
            this.assertThrowsWithMessage(ConfigException.class, () -> handler.handle(new Callback[]{callback}), "Extension name auth is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCallbackGeneratesUnsupportedCallbackException() {
        Map<String, ?> configs = this.getSaslConfigs();
        JwtRetriever jwtRetriever = () -> "test";
        DefaultJwtValidator jwtValidator = OAuthBearerLoginCallbackHandlerTest.createJwtValidator();
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(), jwtRetriever, (JwtValidator)jwtValidator);
        try (OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();){
            Callback unsupportedCallback = new Callback(){};
            Assertions.assertThrows(UnsupportedCallbackException.class, () -> handler.handle(new Callback[]{unsupportedCallback}));
        }
    }

    @Test
    public void testInvalidAccessToken() throws Exception {
        this.testInvalidAccessToken("this isn't valid", "Malformed JWT provided");
        this.testInvalidAccessToken("this.isn't.valid", "malformed Base64 URL encoded value");
        this.testInvalidAccessToken(this.createJwt("this", "isn't", "valid"), "malformed JSON");
        this.testInvalidAccessToken(this.createJwt("{}", "{}", "{}"), "exp value must be non-null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingAccessToken() {
        Map<String, ?> configs = this.getSaslConfigs();
        JwtRetriever jwtRetriever = () -> {
            throw new JwtRetrieverException("The token endpoint response access_token value must be non-null");
        };
        DefaultJwtValidator jwtValidator = OAuthBearerLoginCallbackHandlerTest.createJwtValidator();
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(), jwtRetriever, (JwtValidator)jwtValidator);
        try (OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();){
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            this.assertThrowsWithMessage(JwtRetrieverException.class, () -> handler.handle(new Callback[]{callback}), "token endpoint response access_token value must be non-null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileTokenRetrieverHandlesNewline() throws IOException {
        String expected = this.createJwt("jdoe");
        String withNewline = expected + "\n";
        String accessTokenFile = TestUtils.tempFile(withNewline).toURI().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", accessTokenFile);
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", accessTokenFile);
        FileJwtRetriever jwtRetriever = new FileJwtRetriever();
        DefaultJwtValidator jwtValidator = OAuthBearerLoginCallbackHandlerTest.createJwtValidator();
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(), (JwtRetriever)jwtRetriever, (JwtValidator)jwtValidator);
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        try {
            handler.handle(new Callback[]{callback});
            Assertions.assertEquals((Object)callback.token().value(), (Object)expected);
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
        finally {
            handler.close();
        }
    }

    @Test
    public void testNotConfigured() {
        OAuthBearerLoginCallbackHandler handler = this.createLoginCallbackHandler();
        this.assertThrowsWithMessage(IllegalStateException.class, () -> handler.handle(new Callback[0]), "first call the configure method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvalidAccessToken(String accessToken, String expectedMessageSubstring) throws Exception {
        Map<String, ?> configs = this.getSaslConfigs();
        JwtRetriever jwtRetriever = () -> accessToken;
        DefaultJwtValidator jwtValidator = OAuthBearerLoginCallbackHandlerTest.createJwtValidator();
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(), jwtRetriever, (JwtValidator)jwtValidator);
        try (OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();){
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            handler.handle(new Callback[]{callback});
            Assertions.assertNull((Object)callback.token());
            String actualMessage = callback.errorDescription();
            Assertions.assertNotNull((Object)actualMessage);
            Assertions.assertTrue((boolean)actualMessage.contains(expectedMessageSubstring), (String)String.format("The error message \"%s\" didn't contain the expected substring \"%s\"", actualMessage, expectedMessageSubstring));
        }
    }

    protected OAuthBearerLoginCallbackHandler createLoginCallbackHandler() {
        return new OAuthBearerLoginCallbackHandler();
    }

    private static DefaultJwtRetriever createJwtRetriever() {
        return new DefaultJwtRetriever();
    }

    private static DefaultJwtValidator createJwtValidator() {
        return new DefaultJwtValidator();
    }
}

