/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.UniqueIdGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class UniqueIdGeneratorTest {
    private UniqueIdGenerator uniqueIdGenerator;
    private MockTime mockTime;

    @BeforeEach
    public void setUp() {
        this.uniqueIdGenerator = new UniqueIdGenerator();
        this.mockTime = new MockTime(0L, 1111111111111L, 200L);
    }

    @Test
    public void testGeneratedIdFormat() {
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111100099L);
        this.mockTime.sleep(1L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds()), (long)(111111111111200000L + (long)this.uniqueIdGenerator.serverId()));
    }

    @Test
    public void testIdAdvanceWithTime() {
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111100099L);
        this.mockTime.sleep(1L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111200099L);
        this.mockTime.sleep(2L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111400099L);
        this.mockTime.sleep(3L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111700099L);
        this.mockTime.sleep(1L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds()), (long)(111111111111800000L + (long)this.uniqueIdGenerator.serverId()));
        this.mockTime.sleep(2L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds()), (long)(111111111112000000L + (long)this.uniqueIdGenerator.serverId()));
        this.mockTime.sleep(3L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds()), (long)(111111111112300000L + (long)this.uniqueIdGenerator.serverId()));
    }

    @Test
    public void testCountAdvanceInMillisecond() {
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111100099L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111100199L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111100299L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds(), 99), (long)111111111111100399L);
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds()), (long)(111111111111100400L + (long)this.uniqueIdGenerator.serverId()));
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds()), (long)(111111111111100500L + (long)this.uniqueIdGenerator.serverId()));
        Assertions.assertEquals((long)this.uniqueIdGenerator.generate(this.mockTime.milliseconds()), (long)(111111111111100600L + (long)this.uniqueIdGenerator.serverId()));
    }

    @Test
    public void testOverflowCountInMillisecond() {
        UniqueIdGenerator uniqueIdGeneratorSpy = (UniqueIdGenerator)Mockito.spy((Object)this.uniqueIdGenerator);
        Mockito.when((Object)uniqueIdGeneratorSpy.idsPerMilliseconds()).thenReturn((Object)4);
        Assertions.assertEquals((long)uniqueIdGeneratorSpy.generate(this.mockTime.milliseconds(), 99), (long)111111111111100099L);
        Assertions.assertEquals((long)uniqueIdGeneratorSpy.generate(this.mockTime.milliseconds(), 99), (long)111111111111100199L);
        Assertions.assertEquals((long)uniqueIdGeneratorSpy.generate(this.mockTime.milliseconds(), 99), (long)111111111111100299L);
        Assertions.assertEquals((long)uniqueIdGeneratorSpy.generate(this.mockTime.milliseconds(), 99), (long)111111111111100399L);
        Assertions.assertEquals((long)uniqueIdGeneratorSpy.generate(this.mockTime.milliseconds(), 99), (long)111111111111100099L);
    }
}

