/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils.annotation;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.jupiter.params.support.ParameterDeclarations;

public class ApiKeyVersionsProvider
implements ArgumentsProvider,
AnnotationConsumer<ApiKeyVersionsSource> {
    private ApiKeys apiKey;
    private short fromVersion;
    private short toVersion;

    public void accept(ApiKeyVersionsSource source) {
        this.apiKey = source.apiKey();
        short oldestVersion = this.apiKey.oldestVersion();
        short latestVersion = this.apiKey.latestVersion(source.enableUnstableLastVersion());
        this.fromVersion = source.fromVersion() == -1 ? oldestVersion : source.fromVersion();
        short s = this.toVersion = source.toVersion() == -1 ? latestVersion : source.toVersion();
        if (this.fromVersion > this.toVersion) {
            throw new IllegalArgumentException(String.format("The fromVersion %s is larger than the toVersion %s", this.fromVersion, this.toVersion));
        }
        if (this.fromVersion < oldestVersion) {
            throw new IllegalArgumentException(String.format("The fromVersion %s is older than the oldest version %s", this.fromVersion, oldestVersion));
        }
        if (this.toVersion > latestVersion) {
            throw new IllegalArgumentException(String.format("The toVersion %s is newer than the latest version %s", this.toVersion, latestVersion));
        }
    }

    public Stream<? extends Arguments> provideArguments(ParameterDeclarations parameterDeclarations, ExtensionContext context) {
        return IntStream.rangeClosed(this.fromVersion, this.toVersion).mapToObj(i -> Arguments.of((Object[])new Object[]{(short)i}));
    }
}

