/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging.log4j2;

import io.confluent.common.logging.LogRecordBuilder;
import io.confluent.common.logging.LogRecordStructBuilder;
import io.confluent.common.logging.StructuredLogMessage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Struct;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractLayout;

final class StructuredLayout
extends AbstractLayout<byte[]> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final Function<Struct, byte[]> serializer;
    private final Supplier<LogRecordBuilder<Struct>> logRecordStructBuilderFactory;

    public byte[] toByteArray(LogEvent event) {
        if (event.getMessage().getParameters().length != 1 || !(event.getMessage().getParameters()[0] instanceof StructuredLogMessage)) {
            throw new IllegalArgumentException("LogEvent must contain a single parameter of type StructuredLogMessage");
        }
        StructuredLogMessage schemaAndValue = (StructuredLogMessage)event.getMessage().getParameters()[0];
        Struct logRecord = (Struct)this.logRecordStructBuilderFactory.get().withLoggerName(event.getLoggerName()).withLevel(event.getLevel().name()).withTimeMs(event.getTimeMillis()).withMessageSchemaAndValue(schemaAndValue.getMessage()).build();
        return this.serializer.apply(logRecord);
    }

    public String getContentType() {
        return "bytes";
    }

    public byte[] toSerializable(LogEvent event) {
        return this.toByteArray(event);
    }

    StructuredLayout(Function<Struct, byte[]> serializer) {
        this(serializer, LogRecordStructBuilder::new);
    }

    StructuredLayout(Function<Struct, byte[]> serializer, Supplier<LogRecordBuilder<Struct>> logRecordBuilderFactory) {
        super(null, EMPTY_BYTES, EMPTY_BYTES);
        this.serializer = serializer;
        this.logRecordStructBuilderFactory = logRecordBuilderFactory;
    }
}

