/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;

public class AlterBrokerHealthSpec {
    private final String reason;
    private final Set<Integer> brokerIds;
    private final BrokerComponent brokerComponent;
    private final ComponentHealthStatus componentHealthStatus;
    private final boolean force;

    public AlterBrokerHealthSpec(Set<Integer> brokerIds, ComponentHealthStatus componentHealthStatus, String reason) {
        this(brokerIds, BrokerComponent.UNSPECIFIED, componentHealthStatus, reason, false);
    }

    public AlterBrokerHealthSpec(Set<Integer> brokerIds, BrokerComponent brokerComponent, ComponentHealthStatus componentHealthStatus, String reason) {
        this(brokerIds, brokerComponent, componentHealthStatus, reason, false);
    }

    public AlterBrokerHealthSpec(Set<Integer> brokerIds, BrokerComponent brokerComponent, ComponentHealthStatus componentHealthStatus, String reason, boolean force) {
        this.reason = reason;
        this.brokerIds = brokerIds;
        this.brokerComponent = brokerComponent;
        this.componentHealthStatus = componentHealthStatus;
        this.force = force;
    }

    public String reason() {
        return this.reason;
    }

    public Set<Integer> brokerIds() {
        return this.brokerIds;
    }

    public BrokerComponent brokerComponent() {
        return this.brokerComponent;
    }

    public ComponentHealthStatus componentHealthStatus() {
        return this.componentHealthStatus;
    }

    public boolean force() {
        return this.force;
    }

    public String toString() {
        return "AlterBrokerHealthSpec (reason=" + this.reason + ", brokerIds=" + String.valueOf(this.brokerIds) + ", component=" + String.valueOf((Object)this.brokerComponent) + ", status=" + String.valueOf((Object)this.componentHealthStatus) + ", force=" + this.force + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlterBrokerHealthSpec)) {
            return false;
        }
        AlterBrokerHealthSpec alterBrokerHealthSpec = (AlterBrokerHealthSpec)o;
        return Objects.equals(this.brokerIds, alterBrokerHealthSpec.brokerIds) && Objects.equals(this.reason, alterBrokerHealthSpec.reason) && Objects.equals((Object)this.brokerComponent, (Object)alterBrokerHealthSpec.brokerComponent) && Objects.equals((Object)this.componentHealthStatus, (Object)alterBrokerHealthSpec.componentHealthStatus) && this.force == alterBrokerHealthSpec.force;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brokerIds, this.reason, this.brokerComponent, this.componentHealthStatus, this.force});
    }
}

