/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ComponentHealthStatus {
    UNKNOWN(-1),
    DEGRADED(0),
    HEALTHY(1);

    private static final Map<Byte, ComponentHealthStatus> BYTE_ENUM_MAP;
    private static final Map<String, ComponentHealthStatus> STR_ENUM_MAP;
    private final byte id;

    private ComponentHealthStatus(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static ComponentHealthStatus forId(byte id) {
        return BYTE_ENUM_MAP.getOrDefault(id, UNKNOWN);
    }

    public static ComponentHealthStatus forString(String str) {
        return STR_ENUM_MAP.getOrDefault(str, UNKNOWN);
    }

    static {
        BYTE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ComponentHealthStatus.values()).collect(Collectors.toMap(ComponentHealthStatus::id, Function.identity())));
        STR_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ComponentHealthStatus.values()).collect(Collectors.toMap(Enum::toString, Function.identity())));
    }
}

