/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.StaleMetadataException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetAndTimestampInternal;
import org.apache.kafka.clients.consumer.internals.OffsetFetcherUtils;
import org.apache.kafka.clients.consumer.internals.OffsetsForLeaderEpochUtils;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public final class OffsetsRequestManager
implements RequestManager,
ClusterResourceListener {
    private final ConsumerMetadata metadata;
    private final IsolationLevel isolationLevel;
    private final Logger log;
    private final OffsetFetcherUtils offsetFetcherUtils;
    private final SubscriptionState subscriptionState;
    private final Set<ListOffsetsRequestState> requestsToRetry;
    private final List<NetworkClientDelegate.UnsentRequest> requestsToSend;
    private final long requestTimeoutMs;
    private final Time time;
    private final ApiVersions apiVersions;
    private final NetworkClientDelegate networkClientDelegate;
    private final CommitRequestManager commitRequestManager;
    private final long defaultApiTimeoutMs;
    private final AtomicReference<Throwable> cachedUpdatePositionsException = new AtomicReference();
    private PendingFetchCommittedRequest pendingOffsetFetchEvent;

    public OffsetsRequestManager(SubscriptionState subscriptionState, ConsumerMetadata metadata, IsolationLevel isolationLevel, Time time, long retryBackoffMs, long requestTimeoutMs, long defaultApiTimeoutMs, ApiVersions apiVersions, NetworkClientDelegate networkClientDelegate, CommitRequestManager commitRequestManager, LogContext logContext) {
        Objects.requireNonNull(subscriptionState);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(isolationLevel);
        Objects.requireNonNull(time);
        Objects.requireNonNull(apiVersions);
        Objects.requireNonNull(networkClientDelegate);
        Objects.requireNonNull(logContext);
        this.metadata = metadata;
        this.isolationLevel = isolationLevel;
        this.log = logContext.logger(this.getClass());
        this.requestsToRetry = new HashSet<ListOffsetsRequestState>();
        this.requestsToSend = new ArrayList<NetworkClientDelegate.UnsentRequest>();
        this.subscriptionState = subscriptionState;
        this.time = time;
        this.requestTimeoutMs = requestTimeoutMs;
        this.defaultApiTimeoutMs = defaultApiTimeoutMs;
        this.apiVersions = apiVersions;
        this.networkClientDelegate = networkClientDelegate;
        this.offsetFetcherUtils = new OffsetFetcherUtils(logContext, metadata, subscriptionState, time, retryBackoffMs, apiVersions);
        this.metadata.addClusterUpdateListener(this);
        this.commitRequestManager = commitRequestManager;
    }

    @Override
    public NetworkClientDelegate.PollResult poll(long currentTimeMs) {
        ArrayList<NetworkClientDelegate.UnsentRequest> unsentRequests = new ArrayList<NetworkClientDelegate.UnsentRequest>(this.requestsToSend);
        this.requestsToSend.clear();
        return new NetworkClientDelegate.PollResult(unsentRequests);
    }

    public CompletableFuture<Map<TopicPartition, OffsetAndTimestampInternal>> fetchOffsets(Map<TopicPartition, Long> timestampsToSearch, boolean requireTimestamps) {
        if (timestampsToSearch.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        this.metadata.addTransientTopics(OffsetFetcherUtils.topicsForPartitions(timestampsToSearch.keySet()));
        ListOffsetsRequestState listOffsetsRequestState = new ListOffsetsRequestState(timestampsToSearch, requireTimestamps, this.offsetFetcherUtils, this.isolationLevel);
        listOffsetsRequestState.globalResult.whenComplete((result, error) -> {
            this.metadata.clearTransientTopics();
            if (error != null) {
                this.log.debug("Fetch offsets completed with error for partitions and timestamps {}.", (Object)timestampsToSearch, error);
            } else {
                this.log.debug("Fetch offsets completed successfully for partitions and timestamps {}. Result {}", (Object)timestampsToSearch, result);
            }
        });
        this.prepareFetchOffsetsRequests(timestampsToSearch, requireTimestamps, listOffsetsRequestState);
        return listOffsetsRequestState.globalResult.thenApply(result -> OffsetFetcherUtils.buildOffsetsForTimeInternalResult(timestampsToSearch, result.fetchedOffsets));
    }

    public CompletableFuture<Boolean> updateFetchPositions(long deadlineMs) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        try {
            if (this.maybeCompleteWithPreviousException(result)) {
                return result;
            }
            this.validatePositionsIfNeeded();
            if (this.subscriptionState.hasAllFetchPositions()) {
                result.complete(true);
                return result;
            }
            this.updatePositionsWithOffsets(deadlineMs).whenComplete((__, error) -> {
                if (error != null) {
                    result.completeExceptionally((Throwable)error);
                } else {
                    result.complete(this.subscriptionState.hasAllFetchPositions());
                }
            });
        }
        catch (Exception e) {
            result.completeExceptionally(ConsumerUtils.maybeWrapAsKafkaException(e));
        }
        return result;
    }

    private boolean maybeCompleteWithPreviousException(CompletableFuture<Boolean> result) {
        Throwable cachedException = this.cachedUpdatePositionsException.getAndSet(null);
        if (cachedException != null) {
            result.completeExceptionally(cachedException);
            return true;
        }
        return false;
    }

    private CompletableFuture<Void> updatePositionsWithOffsets(long deadlineMs) {
        CompletionStage<Void> updatePositions;
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.cacheExceptionIfEventExpired(result, deadlineMs);
        Set<TopicPartition> initializingPartitions = this.subscriptionState.initializingPartitions();
        if (this.commitRequestManager != null) {
            CompletableFuture<Void> refreshWithCommittedOffsets = this.initWithCommittedOffsetsIfNeeded(initializingPartitions, deadlineMs);
            updatePositions = refreshWithCommittedOffsets.thenCompose(__ -> this.initWithPartitionOffsetsIfNeeded(initializingPartitions));
        } else {
            updatePositions = this.initWithPartitionOffsetsIfNeeded(initializingPartitions);
        }
        updatePositions.whenComplete((__, resetError) -> {
            if (resetError == null) {
                result.complete(null);
            } else {
                result.completeExceptionally((Throwable)resetError);
            }
        });
        return result;
    }

    private void cacheExceptionIfEventExpired(CompletableFuture<Void> result, long deadlineMs) {
        result.whenComplete((__, error) -> {
            boolean updatePositionsExpired;
            boolean bl = updatePositionsExpired = this.time.milliseconds() >= deadlineMs;
            if (error != null && updatePositionsExpired) {
                this.cachedUpdatePositionsException.set((Throwable)error);
            }
        });
    }

    private CompletableFuture<Void> initWithPartitionOffsetsIfNeeded(Set<TopicPartition> initializingPartitions) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            this.subscriptionState.resetInitializingPositions(initializingPartitions::contains);
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            return result;
        }
        return this.resetPositionsIfNeeded();
    }

    private CompletableFuture<Void> initWithCommittedOffsetsIfNeeded(Set<TopicPartition> initializingPartitions, long deadlineMs) {
        if (initializingPartitions.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.log.debug("Refreshing committed offsets for partitions {}", initializingPartitions);
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (!this.canReusePendingOffsetFetchEvent(initializingPartitions)) {
            long fetchCommittedDeadlineMs = Math.max(deadlineMs, this.time.milliseconds() + this.defaultApiTimeoutMs);
            CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> fetchOffsets = this.commitRequestManager.fetchOffsets(initializingPartitions, fetchCommittedDeadlineMs);
            CompletionStage fetchOffsetsAndRefresh = fetchOffsets.whenComplete((offsets, error) -> {
                this.pendingOffsetFetchEvent = null;
                this.refreshOffsets((Map<TopicPartition, OffsetAndMetadata>)offsets, (Throwable)error, result);
            });
            this.pendingOffsetFetchEvent = new PendingFetchCommittedRequest(initializingPartitions, (CompletableFuture<Map<TopicPartition, OffsetAndMetadata>>)fetchOffsetsAndRefresh);
        } else {
            this.pendingOffsetFetchEvent.result.whenComplete((__, error) -> {
                if (error == null) {
                    result.complete(null);
                } else {
                    result.completeExceptionally((Throwable)error);
                }
            });
        }
        return result;
    }

    private void refreshOffsets(Map<TopicPartition, OffsetAndMetadata> offsets, Throwable error, CompletableFuture<Void> result) {
        if (error == null) {
            Map<TopicPartition, OffsetAndMetadata> offsetsToApply = this.offsetsForInitializingPartitions(offsets);
            ConsumerUtils.refreshCommittedOffsets(offsetsToApply, this.metadata, this.subscriptionState);
            result.complete(null);
        } else {
            this.log.error("Error fetching committed offsets to update positions", error);
            result.completeExceptionally(error);
        }
    }

    private Map<TopicPartition, OffsetAndMetadata> offsetsForInitializingPartitions(Map<TopicPartition, OffsetAndMetadata> offsets) {
        Set<TopicPartition> currentlyInitializingPartitions = this.subscriptionState.initializingPartitions();
        HashMap<TopicPartition, OffsetAndMetadata> result = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.forEach((key, value) -> {
            if (currentlyInitializingPartitions.contains(key)) {
                result.put((TopicPartition)key, (OffsetAndMetadata)value);
            }
        });
        return result;
    }

    private boolean canReusePendingOffsetFetchEvent(Set<TopicPartition> partitions) {
        if (this.pendingOffsetFetchEvent == null) {
            return false;
        }
        return this.pendingOffsetFetchEvent.requestedPartitions.equals(partitions);
    }

    CompletableFuture<Void> resetPositionsIfNeeded() {
        Map<TopicPartition, AutoOffsetResetStrategy> partitionAutoOffsetResetStrategyMap;
        try {
            partitionAutoOffsetResetStrategyMap = this.offsetFetcherUtils.getOffsetResetStrategyForPartitions();
        }
        catch (Exception e) {
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            result.completeExceptionally(e);
            return result;
        }
        if (partitionAutoOffsetResetStrategyMap.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.sendListOffsetsRequestsAndResetPositions(partitionAutoOffsetResetStrategyMap);
    }

    void validatePositionsIfNeeded() {
        Map<TopicPartition, SubscriptionState.FetchPosition> partitionsToValidate = this.offsetFetcherUtils.getPartitionsToValidate();
        if (partitionsToValidate.isEmpty()) {
            return;
        }
        this.sendOffsetsForLeaderEpochRequestsAndValidatePositions(partitionsToValidate);
    }

    private void prepareFetchOffsetsRequests(Map<TopicPartition, Long> timestampsToSearch, boolean requireTimestamps, ListOffsetsRequestState listOffsetsRequestState) {
        try {
            List<NetworkClientDelegate.UnsentRequest> unsentRequests = this.buildListOffsetsRequests(timestampsToSearch, requireTimestamps, listOffsetsRequestState);
            this.requestsToSend.addAll(unsentRequests);
        }
        catch (StaleMetadataException e) {
            this.requestsToRetry.add(listOffsetsRequestState);
        }
    }

    @Override
    public void onUpdate(ClusterResource clusterResource) {
        ArrayList<ListOffsetsRequestState> requestsToProcess = new ArrayList<ListOffsetsRequestState>(this.requestsToRetry);
        this.requestsToRetry.clear();
        requestsToProcess.forEach(requestState -> {
            HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>(requestState.remainingToSearch);
            requestState.remainingToSearch.clear();
            this.prepareFetchOffsetsRequests((Map<TopicPartition, Long>)timestampsToSearch, requestState.requireTimestamps, (ListOffsetsRequestState)requestState);
        });
    }

    private List<NetworkClientDelegate.UnsentRequest> buildListOffsetsRequests(Map<TopicPartition, Long> timestampsToSearch, boolean requireTimestamps, ListOffsetsRequestState listOffsetsRequestState) {
        this.log.debug("Building ListOffsets request for partitions {}", timestampsToSearch);
        Map<Node, Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>> timestampsToSearchByNode = this.groupListOffsetRequests(timestampsToSearch, Optional.of(listOffsetsRequestState));
        if (timestampsToSearchByNode.isEmpty()) {
            throw new StaleMetadataException();
        }
        ArrayList<NetworkClientDelegate.UnsentRequest> unsentRequests = new ArrayList<NetworkClientDelegate.UnsentRequest>();
        MultiNodeRequest multiNodeRequest = new MultiNodeRequest(timestampsToSearchByNode.size());
        multiNodeRequest.onComplete((multiNodeResult, error) -> {
            if (error == null) {
                listOffsetsRequestState.fetchedOffsets.putAll(multiNodeResult.fetchedOffsets);
                listOffsetsRequestState.addPartitionsToRetry(multiNodeResult.partitionsToRetry);
                this.offsetFetcherUtils.updateSubscriptionState(multiNodeResult.fetchedOffsets, this.isolationLevel);
                if (listOffsetsRequestState.remainingToSearch.isEmpty()) {
                    OffsetFetcherUtils.ListOffsetResult listOffsetResult = new OffsetFetcherUtils.ListOffsetResult(listOffsetsRequestState.fetchedOffsets, listOffsetsRequestState.remainingToSearch.keySet());
                    listOffsetsRequestState.globalResult.complete(listOffsetResult);
                } else {
                    this.requestsToRetry.add(listOffsetsRequestState);
                    this.metadata.requestUpdate(false);
                }
            } else {
                this.log.debug("ListOffsets request failed with error", error);
                listOffsetsRequestState.globalResult.completeExceptionally((Throwable)error);
            }
        });
        for (Map.Entry<Node, Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>> entry : timestampsToSearchByNode.entrySet()) {
            Node node = entry.getKey();
            CompletableFuture<OffsetFetcherUtils.ListOffsetResult> partialResult = this.buildListOffsetRequestToNode(node, entry.getValue(), requireTimestamps, unsentRequests);
            partialResult.whenComplete((result, error) -> {
                if (error != null) {
                    multiNodeRequest.resultFuture.completeExceptionally((Throwable)error);
                } else {
                    multiNodeRequest.addPartialResult((OffsetFetcherUtils.ListOffsetResult)result);
                }
            });
        }
        return unsentRequests;
    }

    private CompletableFuture<OffsetFetcherUtils.ListOffsetResult> buildListOffsetRequestToNode(Node node, Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> targetTimes, boolean requireTimestamps, List<NetworkClientDelegate.UnsentRequest> unsentRequests) {
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer(requireTimestamps, this.isolationLevel).setTargetTimes(ListOffsetsRequest.toListOffsetsTopics(targetTimes)).setTimeoutMs((int)this.requestTimeoutMs);
        this.log.debug("Creating ListOffset request {} for broker {} to reset positions", (Object)builder, (Object)node);
        NetworkClientDelegate.UnsentRequest unsentRequest = new NetworkClientDelegate.UnsentRequest(builder, Optional.ofNullable(node));
        unsentRequests.add(unsentRequest);
        CompletableFuture<OffsetFetcherUtils.ListOffsetResult> result = new CompletableFuture<OffsetFetcherUtils.ListOffsetResult>();
        unsentRequest.whenComplete((response, error) -> {
            if (error != null) {
                this.log.debug("Sending ListOffset request {} to broker {} failed", new Object[]{builder, node, error});
                result.completeExceptionally((Throwable)error);
            } else {
                ListOffsetsResponse lor = (ListOffsetsResponse)response.responseBody();
                this.log.trace("Received ListOffsetResponse {} from broker {}", (Object)lor, (Object)node);
                try {
                    OffsetFetcherUtils.ListOffsetResult listOffsetResult = this.offsetFetcherUtils.handleListOffsetResponse(lor);
                    result.complete(listOffsetResult);
                }
                catch (RuntimeException e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    private CompletableFuture<Void> sendListOffsetsRequestsAndResetPositions(Map<TopicPartition, AutoOffsetResetStrategy> partitionAutoOffsetResetStrategyMap) {
        Map<TopicPartition, Long> timestampsToSearch = partitionAutoOffsetResetStrategyMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AutoOffsetResetStrategy)e.getValue()).timestamp().get()));
        Map<Node, Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>> timestampsToSearchByNode = this.groupListOffsetRequests(timestampsToSearch, Optional.empty());
        AtomicInteger expectedResponses = new AtomicInteger(0);
        CompletableFuture<Void> globalResult = new CompletableFuture<Void>();
        ArrayList unsentRequests = new ArrayList();
        timestampsToSearchByNode.forEach((node, resetTimestamps) -> {
            this.subscriptionState.setNextAllowedRetry(resetTimestamps.keySet(), this.time.milliseconds() + this.requestTimeoutMs);
            CompletableFuture<OffsetFetcherUtils.ListOffsetResult> partialResult = this.buildListOffsetRequestToNode((Node)node, (Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>)resetTimestamps, false, unsentRequests);
            partialResult.whenComplete((result, error) -> {
                if (error == null) {
                    this.offsetFetcherUtils.onSuccessfulResponseForResettingPositions((OffsetFetcherUtils.ListOffsetResult)result, partitionAutoOffsetResetStrategyMap);
                } else {
                    RuntimeException e = error instanceof RuntimeException ? (RuntimeException)error : new RuntimeException("Unexpected failure in ListOffsets request for resetting positions", (Throwable)error);
                    this.offsetFetcherUtils.onFailedResponseForResettingPositions((Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>)resetTimestamps, e);
                }
                if (expectedResponses.decrementAndGet() == 0) {
                    globalResult.complete(null);
                }
            });
        });
        if (unsentRequests.isEmpty()) {
            globalResult.complete(null);
        } else {
            expectedResponses.set(unsentRequests.size());
            this.requestsToSend.addAll(unsentRequests);
        }
        return globalResult;
    }

    private void sendOffsetsForLeaderEpochRequestsAndValidatePositions(Map<TopicPartition, SubscriptionState.FetchPosition> partitionsToValidate) {
        Map<Node, Map<TopicPartition, SubscriptionState.FetchPosition>> regrouped = OffsetFetcherUtils.regroupFetchPositionsByLeader(partitionsToValidate);
        long nextResetTimeMs = this.time.milliseconds() + this.requestTimeoutMs;
        ArrayList unsentRequests = new ArrayList();
        regrouped.forEach((node, fetchPositions) -> {
            if (node.isEmpty()) {
                this.metadata.requestUpdate(true);
                return;
            }
            NodeApiVersions nodeApiVersions = this.apiVersions.get(node.idString());
            if (nodeApiVersions == null) {
                this.networkClientDelegate.tryConnect((Node)node);
                return;
            }
            if (!OffsetFetcherUtils.hasUsableOffsetForLeaderEpochVersion(nodeApiVersions)) {
                this.log.debug("Skipping validation of fetch offsets for partitions {} since the broker does not support the required protocol version (introduced in Kafka 2.3)", fetchPositions.keySet());
                for (TopicPartition partition : fetchPositions.keySet()) {
                    this.subscriptionState.completeValidation(partition);
                }
                return;
            }
            this.subscriptionState.setNextAllowedRetry(fetchPositions.keySet(), nextResetTimeMs);
            CompletableFuture<OffsetsForLeaderEpochUtils.OffsetForEpochResult> partialResult = this.buildOffsetsForLeaderEpochRequestToNode((Node)node, (Map<TopicPartition, SubscriptionState.FetchPosition>)fetchPositions, unsentRequests);
            partialResult.whenComplete((offsetsResult, error) -> {
                if (error == null) {
                    this.offsetFetcherUtils.onSuccessfulResponseForValidatingPositions((Map<TopicPartition, SubscriptionState.FetchPosition>)fetchPositions, (OffsetsForLeaderEpochUtils.OffsetForEpochResult)offsetsResult);
                } else {
                    RuntimeException e = error instanceof RuntimeException ? (RuntimeException)error : new RuntimeException("Unexpected failure in OffsetsForLeaderEpoch request for validating positions", (Throwable)error);
                    this.offsetFetcherUtils.onFailedResponseForValidatingPositions((Map<TopicPartition, SubscriptionState.FetchPosition>)fetchPositions, e);
                }
            });
        });
        this.requestsToSend.addAll(unsentRequests);
    }

    private CompletableFuture<OffsetsForLeaderEpochUtils.OffsetForEpochResult> buildOffsetsForLeaderEpochRequestToNode(Node node, Map<TopicPartition, SubscriptionState.FetchPosition> fetchPositions, List<NetworkClientDelegate.UnsentRequest> unsentRequests) {
        AbstractRequest.Builder<OffsetsForLeaderEpochRequest> builder = OffsetsForLeaderEpochUtils.prepareRequest(fetchPositions);
        this.log.debug("Creating OffsetsForLeaderEpoch request request {} to broker {}", builder, (Object)node);
        NetworkClientDelegate.UnsentRequest unsentRequest = new NetworkClientDelegate.UnsentRequest(builder, Optional.ofNullable(node));
        unsentRequests.add(unsentRequest);
        CompletableFuture<OffsetsForLeaderEpochUtils.OffsetForEpochResult> result = new CompletableFuture<OffsetsForLeaderEpochUtils.OffsetForEpochResult>();
        unsentRequest.whenComplete((response, error) -> {
            if (error != null) {
                this.log.debug("Sending OffsetsForLeaderEpoch request {} to broker {} failed", new Object[]{builder, node, error});
                result.completeExceptionally((Throwable)error);
            } else {
                OffsetsForLeaderEpochResponse offsetsForLeaderEpochResponse = (OffsetsForLeaderEpochResponse)response.responseBody();
                this.log.trace("Received OffsetsForLeaderEpoch response {} from broker {}", (Object)offsetsForLeaderEpochResponse, (Object)node);
                try {
                    OffsetsForLeaderEpochUtils.OffsetForEpochResult listOffsetResult = OffsetsForLeaderEpochUtils.handleResponse(fetchPositions, offsetsForLeaderEpochResponse);
                    result.complete(listOffsetResult);
                }
                catch (RuntimeException e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    private Map<Node, Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>> groupListOffsetRequests(Map<TopicPartition, Long> timestampsToSearch, Optional<ListOffsetsRequestState> listOffsetsRequestState) {
        HashMap<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> partitionDataMap = new HashMap<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>();
        for (Map.Entry<TopicPartition, Long> entry : timestampsToSearch.entrySet()) {
            TopicPartition tp = entry.getKey();
            Long offset = entry.getValue();
            Metadata.LeaderAndEpoch leaderAndEpoch = this.metadata.currentLeader(tp);
            if (leaderAndEpoch.leader.isEmpty()) {
                this.log.debug("Leader for partition {} is unknown for fetching offset {}", (Object)tp, (Object)offset);
                this.metadata.requestUpdate(true);
                listOffsetsRequestState.ifPresent(offsetsRequestState -> offsetsRequestState.remainingToSearch.put(tp, offset));
                continue;
            }
            int currentLeaderEpoch = leaderAndEpoch.epoch.orElse(-1);
            partitionDataMap.put(tp, new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(offset).setCurrentLeaderEpoch(currentLeaderEpoch));
        }
        return this.offsetFetcherUtils.regroupPartitionMapByNode(partitionDataMap);
    }

    int requestsToRetry() {
        return this.requestsToRetry.size();
    }

    int requestsToSend() {
        return this.requestsToSend.size();
    }

    private static class ListOffsetsRequestState {
        private final Map<TopicPartition, Long> timestampsToSearch;
        private final Map<TopicPartition, OffsetFetcherUtils.ListOffsetData> fetchedOffsets;
        private final Map<TopicPartition, Long> remainingToSearch = new HashMap<TopicPartition, Long>();
        private final CompletableFuture<OffsetFetcherUtils.ListOffsetResult> globalResult;
        final boolean requireTimestamps;
        final OffsetFetcherUtils offsetFetcherUtils;
        final IsolationLevel isolationLevel;

        private ListOffsetsRequestState(Map<TopicPartition, Long> timestampsToSearch, boolean requireTimestamps, OffsetFetcherUtils offsetFetcherUtils, IsolationLevel isolationLevel) {
            this.fetchedOffsets = new HashMap<TopicPartition, OffsetFetcherUtils.ListOffsetData>();
            this.globalResult = new CompletableFuture();
            this.timestampsToSearch = timestampsToSearch;
            this.requireTimestamps = requireTimestamps;
            this.offsetFetcherUtils = offsetFetcherUtils;
            this.isolationLevel = isolationLevel;
        }

        private void addPartitionsToRetry(Set<TopicPartition> partitionsToRetry) {
            this.remainingToSearch.putAll(partitionsToRetry.stream().collect(Collectors.toMap(tp -> tp, this.timestampsToSearch::get)));
        }
    }

    private static class PendingFetchCommittedRequest {
        final Set<TopicPartition> requestedPartitions;
        final CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> result;

        private PendingFetchCommittedRequest(Set<TopicPartition> requestedPartitions, CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> result) {
            this.requestedPartitions = Objects.requireNonNull(requestedPartitions);
            this.result = Objects.requireNonNull(result);
        }
    }

    private static class MultiNodeRequest {
        final Map<TopicPartition, OffsetFetcherUtils.ListOffsetData> fetchedTimestampOffsets = new HashMap<TopicPartition, OffsetFetcherUtils.ListOffsetData>();
        final Set<TopicPartition> partitionsToRetry = new HashSet<TopicPartition>();
        final AtomicInteger expectedResponses;
        final CompletableFuture<OffsetFetcherUtils.ListOffsetResult> resultFuture;

        private MultiNodeRequest(int nodeCount) {
            this.expectedResponses = new AtomicInteger(nodeCount);
            this.resultFuture = new CompletableFuture();
        }

        private void onComplete(BiConsumer<? super OffsetFetcherUtils.ListOffsetResult, ? super Throwable> action) {
            this.resultFuture.whenComplete(action);
        }

        private void addPartialResult(OffsetFetcherUtils.ListOffsetResult partialResult) {
            try {
                this.fetchedTimestampOffsets.putAll(partialResult.fetchedOffsets);
                this.partitionsToRetry.addAll(partialResult.partitionsToRetry);
                if (this.expectedResponses.decrementAndGet() == 0) {
                    OffsetFetcherUtils.ListOffsetResult result = new OffsetFetcherUtils.ListOffsetResult(this.fetchedTimestampOffsets, this.partitionsToRetry);
                    this.resultFuture.complete(result);
                }
            }
            catch (RuntimeException e) {
                this.resultFuture.completeExceptionally(e);
            }
        }
    }
}

