/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.clients.consumer.internals.CachedSupplier;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.OffsetAndTimestampInternal;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.ShareConsumeRequestManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.AllTopicsMetadataEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.AsyncCommitEvent;
import org.apache.kafka.clients.consumer.internals.events.CheckAndUpdatePositionsEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.CreateFetchRequestsEvent;
import org.apache.kafka.clients.consumer.internals.events.CurrentLagEvent;
import org.apache.kafka.clients.consumer.internals.events.EventProcessor;
import org.apache.kafka.clients.consumer.internals.events.FetchCommittedOffsetsEvent;
import org.apache.kafka.clients.consumer.internals.events.LeaveGroupOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsEvent;
import org.apache.kafka.clients.consumer.internals.events.PausePartitionsEvent;
import org.apache.kafka.clients.consumer.internals.events.PollEvent;
import org.apache.kafka.clients.consumer.internals.events.ResetOffsetEvent;
import org.apache.kafka.clients.consumer.internals.events.ResumePartitionsEvent;
import org.apache.kafka.clients.consumer.internals.events.SeekUnvalidatedEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgeAsyncEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgeOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgeSyncEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgementCommitCallbackRegistrationEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareFetchEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareSubscriptionChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareUnsubscribeEvent;
import org.apache.kafka.clients.consumer.internals.events.StopFindCoordinatorOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.StreamsOnAllTasksLostCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.StreamsOnTasksAssignedCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.StreamsOnTasksRevokedCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.SyncCommitEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicMetadataEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicPatternSubscriptionChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicRe2JPatternSubscriptionChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicSubscriptionChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.UnsubscribeEvent;
import org.apache.kafka.clients.consumer.internals.events.UpdatePatternSubscriptionEvent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ApplicationEventProcessor
implements EventProcessor<ApplicationEvent> {
    private final Logger log;
    private final ConsumerMetadata metadata;
    private final SubscriptionState subscriptions;
    private final RequestManagers requestManagers;
    private int metadataVersionSnapshot;

    public ApplicationEventProcessor(LogContext logContext, RequestManagers requestManagers, ConsumerMetadata metadata, SubscriptionState subscriptions) {
        this.log = logContext.logger(ApplicationEventProcessor.class);
        this.requestManagers = requestManagers;
        this.metadata = metadata;
        this.subscriptions = subscriptions;
        this.metadataVersionSnapshot = metadata.updateVersion();
    }

    @Override
    public void process(ApplicationEvent event) {
        switch (event.type()) {
            case COMMIT_ASYNC: {
                this.process((AsyncCommitEvent)event);
                return;
            }
            case COMMIT_SYNC: {
                this.process((SyncCommitEvent)event);
                return;
            }
            case POLL: {
                this.process((PollEvent)event);
                return;
            }
            case FETCH_COMMITTED_OFFSETS: {
                this.process((FetchCommittedOffsetsEvent)event);
                return;
            }
            case ASSIGNMENT_CHANGE: {
                this.process((AssignmentChangeEvent)event);
                return;
            }
            case TOPIC_METADATA: {
                this.process((TopicMetadataEvent)event);
                return;
            }
            case ALL_TOPICS_METADATA: {
                this.process((AllTopicsMetadataEvent)event);
                return;
            }
            case LIST_OFFSETS: {
                this.process((ListOffsetsEvent)event);
                return;
            }
            case RESET_OFFSET: {
                this.process((ResetOffsetEvent)event);
                return;
            }
            case CHECK_AND_UPDATE_POSITIONS: {
                this.process((CheckAndUpdatePositionsEvent)event);
                return;
            }
            case TOPIC_SUBSCRIPTION_CHANGE: {
                this.process((TopicSubscriptionChangeEvent)event);
                return;
            }
            case TOPIC_PATTERN_SUBSCRIPTION_CHANGE: {
                this.process((TopicPatternSubscriptionChangeEvent)event);
                return;
            }
            case TOPIC_RE2J_PATTERN_SUBSCRIPTION_CHANGE: {
                this.process((TopicRe2JPatternSubscriptionChangeEvent)event);
                return;
            }
            case UPDATE_SUBSCRIPTION_METADATA: {
                this.process((UpdatePatternSubscriptionEvent)event);
                return;
            }
            case UNSUBSCRIBE: {
                this.process((UnsubscribeEvent)event);
                return;
            }
            case CONSUMER_REBALANCE_LISTENER_CALLBACK_COMPLETED: {
                this.process((ConsumerRebalanceListenerCallbackCompletedEvent)event);
                return;
            }
            case COMMIT_ON_CLOSE: {
                this.process((CommitOnCloseEvent)event);
                return;
            }
            case LEAVE_GROUP_ON_CLOSE: {
                this.process((LeaveGroupOnCloseEvent)event);
                return;
            }
            case STOP_FIND_COORDINATOR_ON_CLOSE: {
                this.process((StopFindCoordinatorOnCloseEvent)event);
                return;
            }
            case CREATE_FETCH_REQUESTS: {
                this.process((CreateFetchRequestsEvent)event);
                return;
            }
            case SHARE_FETCH: {
                this.process((ShareFetchEvent)event);
                return;
            }
            case SHARE_ACKNOWLEDGE_SYNC: {
                this.process((ShareAcknowledgeSyncEvent)event);
                return;
            }
            case SHARE_ACKNOWLEDGE_ASYNC: {
                this.process((ShareAcknowledgeAsyncEvent)event);
                return;
            }
            case SHARE_SUBSCRIPTION_CHANGE: {
                this.process((ShareSubscriptionChangeEvent)event);
                return;
            }
            case SHARE_UNSUBSCRIBE: {
                this.process((ShareUnsubscribeEvent)event);
                return;
            }
            case SHARE_ACKNOWLEDGE_ON_CLOSE: {
                this.process((ShareAcknowledgeOnCloseEvent)event);
                return;
            }
            case SHARE_ACKNOWLEDGEMENT_COMMIT_CALLBACK_REGISTRATION: {
                this.process((ShareAcknowledgementCommitCallbackRegistrationEvent)event);
                return;
            }
            case SEEK_UNVALIDATED: {
                this.process((SeekUnvalidatedEvent)event);
                return;
            }
            case PAUSE_PARTITIONS: {
                this.process((PausePartitionsEvent)event);
                return;
            }
            case RESUME_PARTITIONS: {
                this.process((ResumePartitionsEvent)event);
                return;
            }
            case CURRENT_LAG: {
                this.process((CurrentLagEvent)event);
                return;
            }
            case STREAMS_ON_TASKS_REVOKED_CALLBACK_COMPLETED: {
                this.process((StreamsOnTasksRevokedCallbackCompletedEvent)event);
                return;
            }
            case STREAMS_ON_TASKS_ASSIGNED_CALLBACK_COMPLETED: {
                this.process((StreamsOnTasksAssignedCallbackCompletedEvent)event);
                return;
            }
            case STREAMS_ON_ALL_TASKS_LOST_CALLBACK_COMPLETED: {
                this.process((StreamsOnAllTasksLostCallbackCompletedEvent)event);
                return;
            }
        }
        this.log.warn("Application event type {} was not expected", (Object)event.type());
    }

    @Override
    private void process(PollEvent event) {
        this.requestManagers.consumerMembershipManager.ifPresent(consumerMembershipManager -> consumerMembershipManager.maybeReconcile(true));
        if (this.requestManagers.commitRequestManager.isPresent()) {
            CommitRequestManager commitRequestManager = this.requestManagers.commitRequestManager.get();
            commitRequestManager.updateTimerAndMaybeCommit(event.pollTimeMs());
            event.markReconcileAndAutoCommitComplete();
            this.requestManagers.consumerHeartbeatRequestManager.ifPresent(hrm -> {
                hrm.membershipManager().onConsumerPoll();
                hrm.resetPollTimer(event.pollTimeMs());
            });
            this.requestManagers.streamsGroupHeartbeatRequestManager.ifPresent(hrm -> {
                hrm.membershipManager().onConsumerPoll();
                hrm.resetPollTimer(event.pollTimeMs());
            });
        } else {
            event.markReconcileAndAutoCommitComplete();
            this.requestManagers.shareHeartbeatRequestManager.ifPresent(hrm -> {
                hrm.membershipManager().onConsumerPoll();
                hrm.resetPollTimer(event.pollTimeMs());
            });
        }
    }

    @Override
    private void process(CreateFetchRequestsEvent event) {
        CompletableFuture<Void> future = this.requestManagers.fetchRequestManager.createFetchRequests();
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(AsyncCommitEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            event.future().completeExceptionally(new KafkaException("Unable to async commit offset because the CommitRequestManager is not available. Check if group.id was set correctly"));
            return;
        }
        try {
            CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
            Map offsets = event.offsets().orElseGet(this.subscriptions::allConsumed);
            event.markOffsetsReady();
            CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> future = manager.commitAsync(offsets);
            future.whenComplete(this.complete(event.future()));
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(SyncCommitEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            event.future().completeExceptionally(new KafkaException("Unable to sync commit offset because the CommitRequestManager is not available. Check if group.id was set correctly"));
            return;
        }
        try {
            CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
            Map offsets = event.offsets().orElseGet(this.subscriptions::allConsumed);
            event.markOffsetsReady();
            CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> future = manager.commitSync(offsets, event.deadlineMs());
            future.whenComplete(this.complete(event.future()));
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(FetchCommittedOffsetsEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            event.future().completeExceptionally(new KafkaException("Unable to fetch committed offset because the CommitRequestManager is not available. Check if group.id was set correctly"));
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> future = manager.fetchOffsets(event.partitions(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(AssignmentChangeEvent event) {
        if (this.requestManagers.commitRequestManager.isPresent()) {
            CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
            manager.updateTimerAndMaybeCommit(event.currentTimeMs());
        }
        this.log.info("Assigned to partition(s): {}", event.partitions());
        try {
            if (this.subscriptions.assignFromUser(new HashSet<TopicPartition>(event.partitions()))) {
                this.metadata.requestUpdateForNewTopics();
            }
            event.future().complete(null);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(ListOffsetsEvent event) {
        CompletableFuture<Map<TopicPartition, OffsetAndTimestampInternal>> future = this.requestManagers.offsetsRequestManager.fetchOffsets(event.timestampsToSearch(), event.requireTimestamps());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(TopicSubscriptionChangeEvent event) {
        if (this.requestManagers.consumerHeartbeatRequestManager.isPresent()) {
            try {
                if (this.subscriptions.subscribe(event.topics(), event.listener())) {
                    this.metadataVersionSnapshot = this.metadata.requestUpdateForNewTopics();
                }
                this.requestManagers.consumerHeartbeatRequestManager.get().membershipManager().onSubscriptionUpdated();
                event.future().complete(null);
            }
            catch (Exception e) {
                event.future().completeExceptionally(e);
            }
        } else if (this.requestManagers.streamsGroupHeartbeatRequestManager.isPresent()) {
            try {
                if (this.subscriptions.subscribe(event.topics(), event.listener())) {
                    this.metadataVersionSnapshot = this.metadata.requestUpdateForNewTopics();
                }
                this.requestManagers.streamsMembershipManager.get().onSubscriptionUpdated();
                event.future().complete(null);
            }
            catch (Exception e) {
                event.future().completeExceptionally(e);
            }
        } else {
            this.log.warn("Group membership manager not present when processing a subscribe event");
            event.future().complete(null);
        }
    }

    @Override
    private void process(TopicPatternSubscriptionChangeEvent event) {
        try {
            this.subscriptions.subscribe(event.pattern(), event.listener());
            this.metadata.requestUpdateForNewTopics();
            this.updatePatternSubscription(this.metadata.fetch());
            event.future().complete(null);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(TopicRe2JPatternSubscriptionChangeEvent event) {
        if (this.requestManagers.consumerMembershipManager.isEmpty()) {
            event.future().completeExceptionally(new KafkaException("MembershipManager is not available when processing a subscribe event"));
            return;
        }
        try {
            this.subscriptions.subscribe(event.pattern(), event.listener());
            this.requestManagers.consumerMembershipManager.get().onSubscriptionUpdated();
            event.future().complete(null);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(UpdatePatternSubscriptionEvent event) {
        if (!this.subscriptions.hasPatternSubscription()) {
            return;
        }
        if (this.metadataVersionSnapshot < this.metadata.updateVersion()) {
            this.metadataVersionSnapshot = this.metadata.updateVersion();
            this.updatePatternSubscription(this.metadata.fetch());
        }
        event.future().complete(null);
    }

    @Override
    private void process(UnsubscribeEvent event) {
        if (this.requestManagers.consumerHeartbeatRequestManager.isPresent()) {
            CompletableFuture<Void> future = this.requestManagers.consumerHeartbeatRequestManager.get().membershipManager().leaveGroup();
            future.whenComplete(this.complete(event.future()));
        } else if (this.requestManagers.streamsGroupHeartbeatRequestManager.isPresent()) {
            CompletableFuture<Void> future = this.requestManagers.streamsGroupHeartbeatRequestManager.get().membershipManager().leaveGroup();
            future.whenComplete(this.complete(event.future()));
        } else {
            this.subscriptions.unsubscribe();
            event.future().complete(null);
        }
    }

    @Override
    private void process(ResetOffsetEvent event) {
        try {
            Collection<TopicPartition> parts = event.topicPartitions().isEmpty() ? this.subscriptions.assignedPartitions() : event.topicPartitions();
            this.subscriptions.requestOffsetReset(parts, event.offsetResetStrategy());
            event.future().complete(null);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(CheckAndUpdatePositionsEvent event) {
        CompletableFuture<Boolean> future = this.requestManagers.offsetsRequestManager.updateFetchPositions(event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(TopicMetadataEvent event) {
        CompletableFuture<Map<String, List<PartitionInfo>>> future = this.requestManagers.topicMetadataRequestManager.requestTopicMetadata(event.topic(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(AllTopicsMetadataEvent event) {
        CompletableFuture<Map<String, List<PartitionInfo>>> future = this.requestManagers.topicMetadataRequestManager.requestAllTopicsMetadata(event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ConsumerRebalanceListenerCallbackCompletedEvent event) {
        if (this.requestManagers.consumerHeartbeatRequestManager.isEmpty()) {
            this.log.warn("An internal error occurred; the group membership manager was not present, so the notification of the {} callback execution could not be sent", (Object)event.methodName());
            return;
        }
        this.requestManagers.consumerHeartbeatRequestManager.get().membershipManager().consumerRebalanceListenerCallbackCompleted(event);
    }

    @Override
    private void process(CommitOnCloseEvent event) {
        if (this.requestManagers.commitRequestManager.isEmpty()) {
            return;
        }
        this.log.debug("Signal CommitRequestManager closing");
        this.requestManagers.commitRequestManager.get().signalClose();
    }

    @Override
    private void process(LeaveGroupOnCloseEvent event) {
        if (this.requestManagers.consumerMembershipManager.isPresent()) {
            this.log.debug("Signal the ConsumerMembershipManager to leave the consumer group since the consumer is closing");
            CompletableFuture<Void> future = this.requestManagers.consumerMembershipManager.get().leaveGroupOnClose(event.membershipOperation());
            future.whenComplete(this.complete(event.future()));
        } else if (this.requestManagers.streamsMembershipManager.isPresent()) {
            this.log.debug("Signal the StreamsMembershipManager to leave the streams group since the member is closing");
            CompletableFuture<Void> future = this.requestManagers.streamsMembershipManager.get().leaveGroupOnClose();
            future.whenComplete(this.complete(event.future()));
        }
    }

    @Override
    private void process(StopFindCoordinatorOnCloseEvent event) {
        this.requestManagers.coordinatorRequestManager.ifPresent(manager -> {
            this.log.debug("Signal CoordinatorRequestManager closing");
            manager.signalClose();
        });
    }

    @Override
    private void process(ShareFetchEvent event) {
        this.requestManagers.shareConsumeRequestManager.ifPresent(scrm -> scrm.fetch(event.acknowledgementsMap(), event.controlRecordAcknowledgements()));
    }

    @Override
    private void process(ShareAcknowledgeSyncEvent event) {
        if (this.requestManagers.shareConsumeRequestManager.isEmpty()) {
            return;
        }
        ShareConsumeRequestManager manager = this.requestManagers.shareConsumeRequestManager.get();
        CompletableFuture<Map<TopicIdPartition, Acknowledgements>> future = manager.commitSync(event.acknowledgementsMap(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ShareAcknowledgeAsyncEvent event) {
        if (this.requestManagers.shareConsumeRequestManager.isEmpty()) {
            return;
        }
        ShareConsumeRequestManager manager = this.requestManagers.shareConsumeRequestManager.get();
        manager.commitAsync(event.acknowledgementsMap(), event.deadlineMs());
    }

    @Override
    private void process(ShareSubscriptionChangeEvent event) {
        if (this.requestManagers.shareHeartbeatRequestManager.isEmpty()) {
            KafkaException error = new KafkaException("Group membership manager not present when processing a subscribe event");
            event.future().completeExceptionally(error);
            return;
        }
        if (this.subscriptions.subscribeToShareGroup(event.topics())) {
            this.metadata.requestUpdateForNewTopics();
        }
        this.requestManagers.shareHeartbeatRequestManager.get().membershipManager().onSubscriptionUpdated();
        event.future().complete(null);
    }

    @Override
    private void process(ShareUnsubscribeEvent event) {
        if (this.requestManagers.shareHeartbeatRequestManager.isEmpty()) {
            KafkaException error = new KafkaException("Group membership manager not present when processing an unsubscribe event");
            event.future().completeExceptionally(error);
            return;
        }
        this.subscriptions.unsubscribe();
        CompletableFuture<Void> future = this.requestManagers.shareHeartbeatRequestManager.get().membershipManager().leaveGroup();
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ShareAcknowledgeOnCloseEvent event) {
        if (this.requestManagers.shareConsumeRequestManager.isEmpty()) {
            KafkaException error = new KafkaException("Group membership manager not present when processing an acknowledge-on-close event");
            event.future().completeExceptionally(error);
            return;
        }
        ShareConsumeRequestManager manager = this.requestManagers.shareConsumeRequestManager.get();
        CompletableFuture<Void> future = manager.acknowledgeOnClose(event.acknowledgementsMap(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ShareAcknowledgementCommitCallbackRegistrationEvent event) {
        if (this.requestManagers.shareConsumeRequestManager.isEmpty()) {
            return;
        }
        ShareConsumeRequestManager manager = this.requestManagers.shareConsumeRequestManager.get();
        manager.setAcknowledgementCommitCallbackRegistered(event.isCallbackRegistered());
    }

    @Override
    private void process(SeekUnvalidatedEvent event) {
        try {
            event.offsetEpoch().ifPresent(epoch -> this.metadata.updateLastSeenEpochIfNewer(event.partition(), (int)epoch));
            SubscriptionState.FetchPosition newPosition = new SubscriptionState.FetchPosition(event.offset(), event.offsetEpoch(), this.metadata.currentLeader(event.partition()));
            this.subscriptions.seekUnvalidated(event.partition(), newPosition);
            event.future().complete(null);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(PausePartitionsEvent event) {
        try {
            Collection<TopicPartition> partitions = event.partitions();
            this.log.debug("Pausing partitions {}", partitions);
            for (TopicPartition partition : partitions) {
                this.subscriptions.pause(partition);
            }
            event.future().complete(null);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(ResumePartitionsEvent event) {
        try {
            Collection<TopicPartition> partitions = event.partitions();
            this.log.debug("Resuming partitions {}", partitions);
            for (TopicPartition partition : partitions) {
                this.subscriptions.resume(partition);
            }
            event.future().complete(null);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(CurrentLagEvent event) {
        try {
            OptionalLong lagOpt;
            TopicPartition topicPartition = event.partition();
            IsolationLevel isolationLevel = event.isolationLevel();
            Long lag = this.subscriptions.partitionLag(topicPartition, isolationLevel);
            if (lag == null) {
                if (this.subscriptions.partitionEndOffset(topicPartition, isolationLevel) == null && !this.subscriptions.partitionEndOffsetRequested(topicPartition)) {
                    this.log.info("Requesting the log end offset for {} in order to compute lag", (Object)topicPartition);
                    this.subscriptions.requestPartitionEndOffset(topicPartition);
                    Map<TopicPartition, Long> timestampToSearch = Collections.singletonMap(topicPartition, -1L);
                    this.requestManagers.offsetsRequestManager.fetchOffsets(timestampToSearch, false);
                }
                lagOpt = OptionalLong.empty();
            } else {
                lagOpt = OptionalLong.of(lag);
            }
            event.future().complete(lagOpt);
        }
        catch (Exception e) {
            event.future().completeExceptionally(e);
        }
    }

    @Override
    private void process(StreamsOnTasksRevokedCallbackCompletedEvent event) {
        if (this.requestManagers.streamsMembershipManager.isEmpty()) {
            this.log.warn("An internal error occurred; the Streams membership manager was not present, so the notification of the onTasksRevoked callback execution could not be sent");
            return;
        }
        this.requestManagers.streamsMembershipManager.get().onTasksRevokedCallbackCompleted(event);
    }

    @Override
    private void process(StreamsOnTasksAssignedCallbackCompletedEvent event) {
        if (this.requestManagers.streamsMembershipManager.isEmpty()) {
            this.log.warn("An internal error occurred; the Streams membership manager was not present, so the notification of the onTasksAssigned callback execution could not be sent");
            return;
        }
        this.requestManagers.streamsMembershipManager.get().onTasksAssignedCallbackCompleted(event);
    }

    @Override
    private void process(StreamsOnAllTasksLostCallbackCompletedEvent event) {
        if (this.requestManagers.streamsMembershipManager.isEmpty()) {
            this.log.warn("An internal error occurred; the Streams membership manager was not present, so the notification of the onAllTasksLost callback execution could not be sent");
            return;
        }
        this.requestManagers.streamsMembershipManager.get().onAllTasksLostCallbackCompleted(event);
    }

    private <T> BiConsumer<? super T, ? super Throwable> complete(CompletableFuture<T> b) {
        return (value, exception) -> {
            if (exception != null) {
                b.completeExceptionally((Throwable)exception);
            } else {
                b.complete(value);
            }
        };
    }

    public static Supplier<ApplicationEventProcessor> supplier(final LogContext logContext, final ConsumerMetadata metadata, final SubscriptionState subscriptions, final Supplier<RequestManagers> requestManagersSupplier) {
        return new CachedSupplier<ApplicationEventProcessor>(){

            @Override
            protected ApplicationEventProcessor create() {
                RequestManagers requestManagers = (RequestManagers)requestManagersSupplier.get();
                return new ApplicationEventProcessor(logContext, requestManagers, metadata, subscriptions);
            }
        };
    }

    private void updatePatternSubscription(Cluster cluster) {
        if (!this.requestManagers.consumerHeartbeatRequestManager.isPresent()) {
            this.log.warn("Group membership manager not present when processing a subscribe event");
            return;
        }
        Set<String> topicsToSubscribe = cluster.topics().stream().filter(this.subscriptions::matchesSubscribedPattern).collect(Collectors.toSet());
        if (this.subscriptions.subscribeFromPattern(topicsToSubscribe)) {
            this.metadataVersionSnapshot = this.metadata.requestUpdateForNewTopics();
        }
        this.requestManagers.consumerHeartbeatRequestManager.get().membershipManager().onSubscriptionUpdated();
    }

    int metadataVersionSnapshot() {
        return this.metadataVersionSnapshot;
    }
}

