/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeBrokerRemovalsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<BrokerRemovalResponse> removedBrokers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("removed_brokers", new ArrayOf(BrokerRemovalResponse.SCHEMA_0), "Broker IDs that are being or have been removed."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("removed_brokers", new ArrayOf(BrokerRemovalResponse.SCHEMA_1), "Broker IDs that are being or have been removed."));
    public static final Schema SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("removed_brokers", new ArrayOf(BrokerRemovalResponse.SCHEMA_2), "Broker IDs that are being or have been removed."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public DescribeBrokerRemovalsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeBrokerRemovalsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.removedBrokers = new ArrayList<BrokerRemovalResponse>(0);
    }

    @Override
    public short apiKey() {
        return 10007;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field removedBrokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<BrokerRemovalResponse> newCollection = new ArrayList<BrokerRemovalResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerRemovalResponse(_readable, _version, _context));
        }
        this.removedBrokers = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.removedBrokers.size());
        _stringBytes = this.removedBrokers.iterator();
        while (_stringBytes.hasNext()) {
            BrokerRemovalResponse removedBrokersElement = (BrokerRemovalResponse)_stringBytes.next();
            removedBrokersElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(2);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(4);
        for (BrokerRemovalResponse removedBrokersElement : this.removedBrokers) {
            removedBrokersElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeBrokerRemovalsResponseData)) {
            return false;
        }
        DescribeBrokerRemovalsResponseData other = (DescribeBrokerRemovalsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.removedBrokers == null ? other.removedBrokers != null : !this.removedBrokers.equals(other.removedBrokers)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.removedBrokers == null ? 0 : this.removedBrokers.hashCode());
        return hashCode;
    }

    @Override
    public DescribeBrokerRemovalsResponseData duplicate() {
        DescribeBrokerRemovalsResponseData _duplicate = new DescribeBrokerRemovalsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<BrokerRemovalResponse> newRemovedBrokers = new ArrayList<BrokerRemovalResponse>(this.removedBrokers.size());
        for (BrokerRemovalResponse _element : this.removedBrokers) {
            newRemovedBrokers.add(_element.duplicate());
        }
        _duplicate.removedBrokers = newRemovedBrokers;
        return _duplicate;
    }

    public String toString() {
        return "DescribeBrokerRemovalsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", removedBrokers=" + MessageUtil.deepToString(this.removedBrokers.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<BrokerRemovalResponse> removedBrokers() {
        return this.removedBrokers;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeBrokerRemovalsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeBrokerRemovalsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeBrokerRemovalsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeBrokerRemovalsResponseData setRemovedBrokers(List<BrokerRemovalResponse> v) {
        this.removedBrokers = v;
        return this;
    }

    public static class BrokerRemovalResponse
    implements Message {
        int brokerId;
        long createTimeMs;
        long lastUpdateTimeMs;
        String generalOperationStatus;
        String partitionReassignmentsStatus;
        String brokerShutdownStatus;
        String reassignmentsStatus;
        String shutdownStatus;
        String brokerReplicaExclusionStatus;
        boolean shutdownScheduled;
        short removalErrorCode;
        String removalErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID to remove"), new Field("partition_reassignments_status", Type.STRING, "The status of the partition reassignments operation that drains replicas out of the removed broker"), new Field("broker_shutdown_status", Type.STRING, "The status of the broker shutdown, part of the removal operation"), new Field("removal_error_code", Type.INT16, "The error code for the broker removal operation"), new Field("removal_error_message", Type.NULLABLE_STRING, "The error message for the broker removal operation, or null if there was no error."));
        public static final Schema SCHEMA_1 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID to remove"), new Field("create_time_ms", Type.INT64, "The timestamp at which this operation was created, in milliseconds since the unix epoch"), new Field("last_update_time_ms", Type.INT64, "The timestamp denoting when this operation was last updated, in milliseconds since the unix epoch"), new Field("general_operation_status", Type.STRING, "The high-level status of the balancer operation."), new Field("reassignments_status", Type.STRING, "The status of the partition reassignments operation that drains replicas out of the removed broker"), new Field("shutdown_status", Type.STRING, "The status of the broker shutdown, part of the removal operation"), new Field("removal_error_code", Type.INT16, "The error code for the broker removal operation"), new Field("removal_error_message", Type.NULLABLE_STRING, "The error message for the broker removal operation, or null if there was no error."));
        public static final Schema SCHEMA_2 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID to remove"), new Field("create_time_ms", Type.INT64, "The timestamp at which this operation was created, in milliseconds since the unix epoch"), new Field("last_update_time_ms", Type.INT64, "The timestamp denoting when this operation was last updated, in milliseconds since the unix epoch"), new Field("general_operation_status", Type.STRING, "The high-level status of the balancer operation."), new Field("reassignments_status", Type.STRING, "The status of the partition reassignments operation that drains replicas out of the removed broker"), new Field("shutdown_status", Type.STRING, "The status of the broker shutdown, part of the removal operation"), new Field("broker_replica_exclusion_status", Type.STRING, "The status of the broker replica placement exclusion, part of the removal operation."), new Field("shutdown_scheduled", Type.BOOLEAN, "A boolean denoting whether this broker's removal operation was scheduled to shut down the broker"), new Field("removal_error_code", Type.INT16, "The error code for the broker removal operation"), new Field("removal_error_message", Type.NULLABLE_STRING, "The error message for the broker removal operation, or null if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public BrokerRemovalResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public BrokerRemovalResponse() {
            this.brokerId = 0;
            this.createTimeMs = 0L;
            this.lastUpdateTimeMs = 0L;
            this.generalOperationStatus = "";
            this.partitionReassignmentsStatus = "";
            this.brokerShutdownStatus = "";
            this.reassignmentsStatus = "";
            this.shutdownStatus = "";
            this.brokerReplicaExclusionStatus = "";
            this.shutdownScheduled = true;
            this.removalErrorCode = 0;
            this.removalErrorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            short length;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerRemovalResponse");
            }
            this.brokerId = _readable.readInt();
            this.createTimeMs = _version >= 1 ? _readable.readLong() : 0L;
            this.lastUpdateTimeMs = _version >= 1 ? _readable.readLong() : 0L;
            if (_version >= 1) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field generalOperationStatus was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field generalOperationStatus had invalid length " + length);
                }
                this.generalOperationStatus = _readable.readString(length);
            } else {
                this.generalOperationStatus = "";
            }
            if (_version <= 0) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field partitionReassignmentsStatus was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field partitionReassignmentsStatus had invalid length " + length);
                }
                this.partitionReassignmentsStatus = _readable.readString(length);
            } else {
                this.partitionReassignmentsStatus = "";
            }
            if (_version <= 0) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field brokerShutdownStatus was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field brokerShutdownStatus had invalid length " + length);
                }
                this.brokerShutdownStatus = _readable.readString(length);
            } else {
                this.brokerShutdownStatus = "";
            }
            if (_version >= 1) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field reassignmentsStatus was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field reassignmentsStatus had invalid length " + length);
                }
                this.reassignmentsStatus = _readable.readString(length);
            } else {
                this.reassignmentsStatus = "";
            }
            if (_version >= 1) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field shutdownStatus was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field shutdownStatus had invalid length " + length);
                }
                this.shutdownStatus = _readable.readString(length);
            } else {
                this.shutdownStatus = "";
            }
            if (_version >= 2) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field brokerReplicaExclusionStatus was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field brokerReplicaExclusionStatus had invalid length " + length);
                }
                this.brokerReplicaExclusionStatus = _readable.readString(length);
            } else {
                this.brokerReplicaExclusionStatus = "";
            }
            this.shutdownScheduled = _version >= 2 ? _readable.readByte() != 0 : true;
            this.removalErrorCode = _readable.readShort();
            length = _readable.readShort();
            if (length < 0) {
                this.removalErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field removalErrorMessage had invalid length " + length);
                }
                this.removalErrorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            if (_version >= 1) {
                _writable.writeLong(this.createTimeMs);
            }
            if (_version >= 1) {
                _writable.writeLong(this.lastUpdateTimeMs);
            }
            if (_version >= 1) {
                _stringBytes = _cache.getSerializedValue(this.generalOperationStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            if (_version <= 0) {
                _stringBytes = _cache.getSerializedValue(this.partitionReassignmentsStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            if (_version <= 0) {
                _stringBytes = _cache.getSerializedValue(this.brokerShutdownStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 1) {
                _stringBytes = _cache.getSerializedValue(this.reassignmentsStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 1) {
                _stringBytes = _cache.getSerializedValue(this.shutdownStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 2) {
                _stringBytes = _cache.getSerializedValue(this.brokerReplicaExclusionStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 2) {
                _writable.writeByte(this.shutdownScheduled ? (byte)1 : 0);
            }
            _writable.writeShort(this.removalErrorCode);
            if (this.removalErrorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.removalErrorMessage);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerRemovalResponse");
            }
            _size.addBytes(4);
            if (_version >= 1) {
                _size.addBytes(8);
            }
            if (_version >= 1) {
                _size.addBytes(8);
            }
            if (_version >= 1) {
                _stringBytes = this.generalOperationStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'generalOperationStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.generalOperationStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version <= 0) {
                _stringBytes = this.partitionReassignmentsStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'partitionReassignmentsStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.partitionReassignmentsStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version <= 0) {
                _stringBytes = this.brokerShutdownStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'brokerShutdownStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.brokerShutdownStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 1) {
                _stringBytes = this.reassignmentsStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'reassignmentsStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.reassignmentsStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 1) {
                _stringBytes = this.shutdownStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'shutdownStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.shutdownStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _stringBytes = this.brokerReplicaExclusionStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'brokerReplicaExclusionStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.brokerReplicaExclusionStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(1);
            }
            _size.addBytes(2);
            if (this.removalErrorMessage == null) {
                _size.addBytes(2);
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.removalErrorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'removalErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.removalErrorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerRemovalResponse)) {
                return false;
            }
            BrokerRemovalResponse other = (BrokerRemovalResponse)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.createTimeMs != other.createTimeMs) {
                return false;
            }
            if (this.lastUpdateTimeMs != other.lastUpdateTimeMs) {
                return false;
            }
            if (this.generalOperationStatus == null ? other.generalOperationStatus != null : !this.generalOperationStatus.equals(other.generalOperationStatus)) {
                return false;
            }
            if (this.partitionReassignmentsStatus == null ? other.partitionReassignmentsStatus != null : !this.partitionReassignmentsStatus.equals(other.partitionReassignmentsStatus)) {
                return false;
            }
            if (this.brokerShutdownStatus == null ? other.brokerShutdownStatus != null : !this.brokerShutdownStatus.equals(other.brokerShutdownStatus)) {
                return false;
            }
            if (this.reassignmentsStatus == null ? other.reassignmentsStatus != null : !this.reassignmentsStatus.equals(other.reassignmentsStatus)) {
                return false;
            }
            if (this.shutdownStatus == null ? other.shutdownStatus != null : !this.shutdownStatus.equals(other.shutdownStatus)) {
                return false;
            }
            if (this.brokerReplicaExclusionStatus == null ? other.brokerReplicaExclusionStatus != null : !this.brokerReplicaExclusionStatus.equals(other.brokerReplicaExclusionStatus)) {
                return false;
            }
            if (this.shutdownScheduled != other.shutdownScheduled) {
                return false;
            }
            if (this.removalErrorCode != other.removalErrorCode) {
                return false;
            }
            if (this.removalErrorMessage == null ? other.removalErrorMessage != null : !this.removalErrorMessage.equals(other.removalErrorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + ((int)(this.createTimeMs >> 32) ^ (int)this.createTimeMs);
            hashCode = 31 * hashCode + ((int)(this.lastUpdateTimeMs >> 32) ^ (int)this.lastUpdateTimeMs);
            hashCode = 31 * hashCode + (this.generalOperationStatus == null ? 0 : this.generalOperationStatus.hashCode());
            hashCode = 31 * hashCode + (this.partitionReassignmentsStatus == null ? 0 : this.partitionReassignmentsStatus.hashCode());
            hashCode = 31 * hashCode + (this.brokerShutdownStatus == null ? 0 : this.brokerShutdownStatus.hashCode());
            hashCode = 31 * hashCode + (this.reassignmentsStatus == null ? 0 : this.reassignmentsStatus.hashCode());
            hashCode = 31 * hashCode + (this.shutdownStatus == null ? 0 : this.shutdownStatus.hashCode());
            hashCode = 31 * hashCode + (this.brokerReplicaExclusionStatus == null ? 0 : this.brokerReplicaExclusionStatus.hashCode());
            hashCode = 31 * hashCode + (this.shutdownScheduled ? 1231 : 1237);
            hashCode = 31 * hashCode + this.removalErrorCode;
            hashCode = 31 * hashCode + (this.removalErrorMessage == null ? 0 : this.removalErrorMessage.hashCode());
            return hashCode;
        }

        @Override
        public BrokerRemovalResponse duplicate() {
            BrokerRemovalResponse _duplicate = new BrokerRemovalResponse();
            _duplicate.brokerId = this.brokerId;
            _duplicate.createTimeMs = this.createTimeMs;
            _duplicate.lastUpdateTimeMs = this.lastUpdateTimeMs;
            _duplicate.generalOperationStatus = this.generalOperationStatus;
            _duplicate.partitionReassignmentsStatus = this.partitionReassignmentsStatus;
            _duplicate.brokerShutdownStatus = this.brokerShutdownStatus;
            _duplicate.reassignmentsStatus = this.reassignmentsStatus;
            _duplicate.shutdownStatus = this.shutdownStatus;
            _duplicate.brokerReplicaExclusionStatus = this.brokerReplicaExclusionStatus;
            _duplicate.shutdownScheduled = this.shutdownScheduled;
            _duplicate.removalErrorCode = this.removalErrorCode;
            _duplicate.removalErrorMessage = this.removalErrorMessage == null ? null : this.removalErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "BrokerRemovalResponse(brokerId=" + this.brokerId + ", createTimeMs=" + this.createTimeMs + ", lastUpdateTimeMs=" + this.lastUpdateTimeMs + ", generalOperationStatus=" + (String)(this.generalOperationStatus == null ? "null" : "'" + this.generalOperationStatus.toString() + "'") + ", partitionReassignmentsStatus=" + (String)(this.partitionReassignmentsStatus == null ? "null" : "'" + this.partitionReassignmentsStatus.toString() + "'") + ", brokerShutdownStatus=" + (String)(this.brokerShutdownStatus == null ? "null" : "'" + this.brokerShutdownStatus.toString() + "'") + ", reassignmentsStatus=" + (String)(this.reassignmentsStatus == null ? "null" : "'" + this.reassignmentsStatus.toString() + "'") + ", shutdownStatus=" + (String)(this.shutdownStatus == null ? "null" : "'" + this.shutdownStatus.toString() + "'") + ", brokerReplicaExclusionStatus=" + (String)(this.brokerReplicaExclusionStatus == null ? "null" : "'" + this.brokerReplicaExclusionStatus.toString() + "'") + ", shutdownScheduled=" + (this.shutdownScheduled ? "true" : "false") + ", removalErrorCode=" + this.removalErrorCode + ", removalErrorMessage=" + (String)(this.removalErrorMessage == null ? "null" : "'" + this.removalErrorMessage.toString() + "'") + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public long createTimeMs() {
            return this.createTimeMs;
        }

        public long lastUpdateTimeMs() {
            return this.lastUpdateTimeMs;
        }

        public String generalOperationStatus() {
            return this.generalOperationStatus;
        }

        public String partitionReassignmentsStatus() {
            return this.partitionReassignmentsStatus;
        }

        public String brokerShutdownStatus() {
            return this.brokerShutdownStatus;
        }

        public String reassignmentsStatus() {
            return this.reassignmentsStatus;
        }

        public String shutdownStatus() {
            return this.shutdownStatus;
        }

        public String brokerReplicaExclusionStatus() {
            return this.brokerReplicaExclusionStatus;
        }

        public boolean shutdownScheduled() {
            return this.shutdownScheduled;
        }

        public short removalErrorCode() {
            return this.removalErrorCode;
        }

        public String removalErrorMessage() {
            return this.removalErrorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerRemovalResponse setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public BrokerRemovalResponse setCreateTimeMs(long v) {
            this.createTimeMs = v;
            return this;
        }

        public BrokerRemovalResponse setLastUpdateTimeMs(long v) {
            this.lastUpdateTimeMs = v;
            return this;
        }

        public BrokerRemovalResponse setGeneralOperationStatus(String v) {
            this.generalOperationStatus = v;
            return this;
        }

        public BrokerRemovalResponse setPartitionReassignmentsStatus(String v) {
            this.partitionReassignmentsStatus = v;
            return this;
        }

        public BrokerRemovalResponse setBrokerShutdownStatus(String v) {
            this.brokerShutdownStatus = v;
            return this;
        }

        public BrokerRemovalResponse setReassignmentsStatus(String v) {
            this.reassignmentsStatus = v;
            return this;
        }

        public BrokerRemovalResponse setShutdownStatus(String v) {
            this.shutdownStatus = v;
            return this;
        }

        public BrokerRemovalResponse setBrokerReplicaExclusionStatus(String v) {
            this.brokerReplicaExclusionStatus = v;
            return this;
        }

        public BrokerRemovalResponse setShutdownScheduled(boolean v) {
            this.shutdownScheduled = v;
            return this;
        }

        public BrokerRemovalResponse setRemovalErrorCode(short v) {
            this.removalErrorCode = v;
            return this;
        }

        public BrokerRemovalResponse setRemovalErrorMessage(String v) {
            this.removalErrorMessage = v;
            return this;
        }
    }
}

