/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListConfigResourcesRequestData
implements ApiMessage {
    List<Byte> resourceTypes;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("resource_types", new CompactArrayOf(Type.INT8), "The list of resource type. If the list is empty, it uses default supported config resource types."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ListConfigResourcesRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ListConfigResourcesRequestData() {
        this.resourceTypes = new ArrayList<Byte>(0);
    }

    @Override
    public short apiKey() {
        return 74;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        if (_version >= 1) {
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resourceTypes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Byte> newCollection = new ArrayList<Byte>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readByte());
            }
            this.resourceTypes = newCollection;
        } else {
            this.resourceTypes = new ArrayList<Byte>(0);
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeUnsignedVarint(this.resourceTypes.size() + 1);
            for (Byte resourceTypesElement : this.resourceTypes) {
                _writable.writeByte(resourceTypesElement);
            }
        } else if (!this.resourceTypes.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default resourceTypes at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.resourceTypes.size() + 1));
            _size.addBytes(this.resourceTypes.size() * 1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListConfigResourcesRequestData)) {
            return false;
        }
        ListConfigResourcesRequestData other = (ListConfigResourcesRequestData)obj;
        if (this.resourceTypes == null ? other.resourceTypes != null : !this.resourceTypes.equals(other.resourceTypes)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.resourceTypes == null ? 0 : this.resourceTypes.hashCode());
        return hashCode;
    }

    @Override
    public ListConfigResourcesRequestData duplicate() {
        ListConfigResourcesRequestData _duplicate = new ListConfigResourcesRequestData();
        ArrayList<Byte> newResourceTypes = new ArrayList<Byte>(this.resourceTypes.size());
        for (Byte _element : this.resourceTypes) {
            newResourceTypes.add(_element);
        }
        _duplicate.resourceTypes = newResourceTypes;
        return _duplicate;
    }

    public String toString() {
        return "ListConfigResourcesRequestData(resourceTypes=" + MessageUtil.deepToString(this.resourceTypes.iterator()) + ")";
    }

    public List<Byte> resourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListConfigResourcesRequestData setResourceTypes(List<Byte> v) {
        this.resourceTypes = v;
        return this;
    }
}

