/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ResolveOffsetRangeResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<ResolveOffsetRangeTopicResponse> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new CompactArrayOf(ResolveOffsetRangeTopicResponse.SCHEMA_0), "Each topic in the response."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ResolveOffsetRangeResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ResolveOffsetRangeResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<ResolveOffsetRangeTopicResponse>(0);
    }

    @Override
    public short apiKey() {
        return 10041;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<ResolveOffsetRangeTopicResponse> newCollection = new ArrayList<ResolveOffsetRangeTopicResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ResolveOffsetRangeTopicResponse(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (ResolveOffsetRangeTopicResponse topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (ResolveOffsetRangeTopicResponse topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResolveOffsetRangeResponseData)) {
            return false;
        }
        ResolveOffsetRangeResponseData other = (ResolveOffsetRangeResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public ResolveOffsetRangeResponseData duplicate() {
        ResolveOffsetRangeResponseData _duplicate = new ResolveOffsetRangeResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<ResolveOffsetRangeTopicResponse> newTopics = new ArrayList<ResolveOffsetRangeTopicResponse>(this.topics.size());
        for (ResolveOffsetRangeTopicResponse _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ResolveOffsetRangeResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<ResolveOffsetRangeTopicResponse> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ResolveOffsetRangeResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ResolveOffsetRangeResponseData setTopics(List<ResolveOffsetRangeTopicResponse> v) {
        this.topics = v;
        return this;
    }

    public static class ResolveOffsetRangeTopicResponse
    implements Message {
        Uuid topicId;
        List<ResolveOffsetPartitionResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The topic identifier."), new Field("partitions", new CompactArrayOf(ResolveOffsetPartitionResponse.SCHEMA_0), "Each partition in the response."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ResolveOffsetRangeTopicResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ResolveOffsetRangeTopicResponse() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<ResolveOffsetPartitionResponse>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ResolveOffsetRangeTopicResponse");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<ResolveOffsetPartitionResponse> newCollection = new ArrayList<ResolveOffsetPartitionResponse>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ResolveOffsetPartitionResponse(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (ResolveOffsetPartitionResponse partitionsElement : this.partitions) {
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ResolveOffsetRangeTopicResponse");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (ResolveOffsetPartitionResponse partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResolveOffsetRangeTopicResponse)) {
                return false;
            }
            ResolveOffsetRangeTopicResponse other = (ResolveOffsetRangeTopicResponse)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public ResolveOffsetRangeTopicResponse duplicate() {
            ResolveOffsetRangeTopicResponse _duplicate = new ResolveOffsetRangeTopicResponse();
            _duplicate.topicId = this.topicId;
            ArrayList<ResolveOffsetPartitionResponse> newPartitions = new ArrayList<ResolveOffsetPartitionResponse>(this.partitions.size());
            for (ResolveOffsetPartitionResponse _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ResolveOffsetRangeTopicResponse(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<ResolveOffsetPartitionResponse> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ResolveOffsetRangeTopicResponse setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public ResolveOffsetRangeTopicResponse setPartitions(List<ResolveOffsetPartitionResponse> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class BrokerMetadata
    implements Message {
        long startOffset;
        long endOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("start_offset", Type.INT64, "Starting offset for the segment."), new Field("end_offset", Type.INT64, "End offset (exclusive) for the segment."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerMetadata(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public BrokerMetadata() {
            this.startOffset = 0L;
            this.endOffset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerMetadata");
            }
            this.startOffset = _readable.readLong();
            this.endOffset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.startOffset);
            _writable.writeLong(this.endOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerMetadata");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerMetadata)) {
                return false;
            }
            BrokerMetadata other = (BrokerMetadata)obj;
            if (this.startOffset != other.startOffset) {
                return false;
            }
            if (this.endOffset != other.endOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.startOffset >> 32) ^ (int)this.startOffset);
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            return hashCode;
        }

        @Override
        public BrokerMetadata duplicate() {
            BrokerMetadata _duplicate = new BrokerMetadata();
            _duplicate.startOffset = this.startOffset;
            _duplicate.endOffset = this.endOffset;
            return _duplicate;
        }

        public String toString() {
            return "BrokerMetadata(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
        }

        public long startOffset() {
            return this.startOffset;
        }

        public long endOffset() {
            return this.endOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerMetadata setStartOffset(long v) {
            this.startOffset = v;
            return this;
        }

        public BrokerMetadata setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }
    }

    public static class SegmentFileMetadata
    implements Message {
        byte fragmentTypeByte;
        String locator;
        long startBytePosition;
        long endBytePosition;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("fragment_type_byte", Type.INT8, "The tiered objects fragment type (in byte): SEGMENT(0), OFFSET_INDEX(1), TRANSACTION_INDEX(2)"), new Field("locator", Type.COMPACT_STRING, "Segment locator."), new Field("start_byte_position", Type.INT64, "Byte position to start reading the object from."), new Field("end_byte_position", Type.INT64, "Byte position (exclusive) to stop reading the object at."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public SegmentFileMetadata(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public SegmentFileMetadata() {
            this.fragmentTypeByte = 0;
            this.locator = "";
            this.startBytePosition = 0L;
            this.endBytePosition = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SegmentFileMetadata");
            }
            this.fragmentTypeByte = _readable.readByte();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field locator was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field locator had invalid length " + length);
            }
            this.locator = _readable.readString(length);
            this.startBytePosition = _readable.readLong();
            this.endBytePosition = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.fragmentTypeByte);
            byte[] _stringBytes = _cache.getSerializedValue(this.locator);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeLong(this.startBytePosition);
            _writable.writeLong(this.endBytePosition);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of SegmentFileMetadata");
            }
            _size.addBytes(1);
            byte[] _stringBytes = this.locator.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'locator' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.locator, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(8);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SegmentFileMetadata)) {
                return false;
            }
            SegmentFileMetadata other = (SegmentFileMetadata)obj;
            if (this.fragmentTypeByte != other.fragmentTypeByte) {
                return false;
            }
            if (this.locator == null ? other.locator != null : !this.locator.equals(other.locator)) {
                return false;
            }
            if (this.startBytePosition != other.startBytePosition) {
                return false;
            }
            if (this.endBytePosition != other.endBytePosition) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.fragmentTypeByte;
            hashCode = 31 * hashCode + (this.locator == null ? 0 : this.locator.hashCode());
            hashCode = 31 * hashCode + ((int)(this.startBytePosition >> 32) ^ (int)this.startBytePosition);
            hashCode = 31 * hashCode + ((int)(this.endBytePosition >> 32) ^ (int)this.endBytePosition);
            return hashCode;
        }

        @Override
        public SegmentFileMetadata duplicate() {
            SegmentFileMetadata _duplicate = new SegmentFileMetadata();
            _duplicate.fragmentTypeByte = this.fragmentTypeByte;
            _duplicate.locator = this.locator;
            _duplicate.startBytePosition = this.startBytePosition;
            _duplicate.endBytePosition = this.endBytePosition;
            return _duplicate;
        }

        public String toString() {
            return "SegmentFileMetadata(fragmentTypeByte=" + this.fragmentTypeByte + ", locator=" + (String)(this.locator == null ? "null" : "'" + this.locator.toString() + "'") + ", startBytePosition=" + this.startBytePosition + ", endBytePosition=" + this.endBytePosition + ")";
        }

        public byte fragmentTypeByte() {
            return this.fragmentTypeByte;
        }

        public String locator() {
            return this.locator;
        }

        public long startBytePosition() {
            return this.startBytePosition;
        }

        public long endBytePosition() {
            return this.endBytePosition;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public SegmentFileMetadata setFragmentTypeByte(byte v) {
            this.fragmentTypeByte = v;
            return this;
        }

        public SegmentFileMetadata setLocator(String v) {
            this.locator = v;
            return this;
        }

        public SegmentFileMetadata setStartBytePosition(long v) {
            this.startBytePosition = v;
            return this;
        }

        public SegmentFileMetadata setEndBytePosition(long v) {
            this.endBytePosition = v;
            return this;
        }
    }

    public static class TieredSegmentMetadata
    implements Message {
        long startOffset;
        long endOffset;
        List<SegmentFileMetadata> segmentFiles;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("start_offset", Type.INT64, "Segment base offset, or next offset after the previous segment to avoid overlap."), new Field("end_offset", Type.INT64, "End offset (exclusive) of the segment."), new Field("segment_files", new CompactArrayOf(SegmentFileMetadata.SCHEMA_0), "Metadata of the segment files."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TieredSegmentMetadata(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TieredSegmentMetadata() {
            this.startOffset = 0L;
            this.endOffset = 0L;
            this.segmentFiles = new ArrayList<SegmentFileMetadata>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TieredSegmentMetadata");
            }
            this.startOffset = _readable.readLong();
            this.endOffset = _readable.readLong();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field segmentFiles was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<SegmentFileMetadata> newCollection = new ArrayList<SegmentFileMetadata>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new SegmentFileMetadata(_readable, _version, _context));
            }
            this.segmentFiles = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.startOffset);
            _writable.writeLong(this.endOffset);
            _writable.writeUnsignedVarint(this.segmentFiles.size() + 1);
            for (SegmentFileMetadata segmentFilesElement : this.segmentFiles) {
                segmentFilesElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TieredSegmentMetadata");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.segmentFiles.size() + 1));
            for (SegmentFileMetadata segmentFilesElement : this.segmentFiles) {
                segmentFilesElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TieredSegmentMetadata)) {
                return false;
            }
            TieredSegmentMetadata other = (TieredSegmentMetadata)obj;
            if (this.startOffset != other.startOffset) {
                return false;
            }
            if (this.endOffset != other.endOffset) {
                return false;
            }
            if (this.segmentFiles == null ? other.segmentFiles != null : !this.segmentFiles.equals(other.segmentFiles)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.startOffset >> 32) ^ (int)this.startOffset);
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            hashCode = 31 * hashCode + (this.segmentFiles == null ? 0 : this.segmentFiles.hashCode());
            return hashCode;
        }

        @Override
        public TieredSegmentMetadata duplicate() {
            TieredSegmentMetadata _duplicate = new TieredSegmentMetadata();
            _duplicate.startOffset = this.startOffset;
            _duplicate.endOffset = this.endOffset;
            ArrayList<SegmentFileMetadata> newSegmentFiles = new ArrayList<SegmentFileMetadata>(this.segmentFiles.size());
            for (SegmentFileMetadata _element : this.segmentFiles) {
                newSegmentFiles.add(_element.duplicate());
            }
            _duplicate.segmentFiles = newSegmentFiles;
            return _duplicate;
        }

        public String toString() {
            return "TieredSegmentMetadata(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", segmentFiles=" + MessageUtil.deepToString(this.segmentFiles.iterator()) + ")";
        }

        public long startOffset() {
            return this.startOffset;
        }

        public long endOffset() {
            return this.endOffset;
        }

        public List<SegmentFileMetadata> segmentFiles() {
            return this.segmentFiles;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TieredSegmentMetadata setStartOffset(long v) {
            this.startOffset = v;
            return this;
        }

        public TieredSegmentMetadata setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        public TieredSegmentMetadata setSegmentFiles(List<SegmentFileMetadata> v) {
            this.segmentFiles = v;
            return this;
        }
    }

    public static class ResolveOffsetPartitionResponse
    implements Message {
        int partitionIndex;
        short errorCode;
        String errorMessage;
        List<TieredSegmentMetadata> tieredSegmentRange;
        BrokerMetadata brokerRange;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The partition error message, or `null` if there was no error."), new Field("tiered_segment_range", CompactArrayOf.nullable(TieredSegmentMetadata.SCHEMA_0), "Metadata for tiered segments that constitute the resolved offset range."), new Field("broker_range", BrokerMetadata.SCHEMA_0, "Metadata for segments on the broker that constitute the resolved offset range."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ResolveOffsetPartitionResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ResolveOffsetPartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.errorMessage = "";
            this.tieredSegmentRange = new ArrayList<TieredSegmentMetadata>(0);
            this.brokerRange = new BrokerMetadata();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ResolveOffsetPartitionResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.tieredSegmentRange = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TieredSegmentMetadata> newCollection = new ArrayList<TieredSegmentMetadata>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new TieredSegmentMetadata(_readable, _version, _context));
                }
                this.tieredSegmentRange = newCollection;
            }
            this.brokerRange = _readable.readByte() < 0 ? null : new BrokerMetadata(_readable, _version, _context);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (this.tieredSegmentRange == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.tieredSegmentRange.size() + 1);
                _stringBytes = this.tieredSegmentRange.iterator();
                while (_stringBytes.hasNext()) {
                    TieredSegmentMetadata tieredSegmentRangeElement = (TieredSegmentMetadata)_stringBytes.next();
                    tieredSegmentRangeElement.write(_writable, _cache, _version, _context);
                }
            }
            if (this.brokerRange == null) {
                _writable.writeByte((byte)-1);
            } else {
                _writable.writeByte((byte)1);
                this.brokerRange.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ResolveOffsetPartitionResponse");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this.tieredSegmentRange == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tieredSegmentRange.size() + 1));
                for (TieredSegmentMetadata tieredSegmentRangeElement : this.tieredSegmentRange) {
                    tieredSegmentRangeElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (this.brokerRange == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(1);
                this.brokerRange.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResolveOffsetPartitionResponse)) {
                return false;
            }
            ResolveOffsetPartitionResponse other = (ResolveOffsetPartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.tieredSegmentRange == null ? other.tieredSegmentRange != null : !this.tieredSegmentRange.equals(other.tieredSegmentRange)) {
                return false;
            }
            if (this.brokerRange == null ? other.brokerRange != null : !this.brokerRange.equals(other.brokerRange)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.tieredSegmentRange == null ? 0 : this.tieredSegmentRange.hashCode());
            hashCode = 31 * hashCode + (this.brokerRange == null ? 0 : this.brokerRange.hashCode());
            return hashCode;
        }

        @Override
        public ResolveOffsetPartitionResponse duplicate() {
            ResolveOffsetPartitionResponse _duplicate = new ResolveOffsetPartitionResponse();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            if (this.tieredSegmentRange == null) {
                _duplicate.tieredSegmentRange = null;
            } else {
                ArrayList<TieredSegmentMetadata> newTieredSegmentRange = new ArrayList<TieredSegmentMetadata>(this.tieredSegmentRange.size());
                for (TieredSegmentMetadata _element : this.tieredSegmentRange) {
                    newTieredSegmentRange.add(_element.duplicate());
                }
                _duplicate.tieredSegmentRange = newTieredSegmentRange;
            }
            _duplicate.brokerRange = this.brokerRange == null ? null : this.brokerRange.duplicate();
            return _duplicate;
        }

        public String toString() {
            return "ResolveOffsetPartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", tieredSegmentRange=" + (this.tieredSegmentRange == null ? "null" : MessageUtil.deepToString(this.tieredSegmentRange.iterator())) + ", brokerRange=" + (this.brokerRange == null ? "null" : this.brokerRange.toString()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<TieredSegmentMetadata> tieredSegmentRange() {
            return this.tieredSegmentRange;
        }

        public BrokerMetadata brokerRange() {
            return this.brokerRange;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ResolveOffsetPartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ResolveOffsetPartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public ResolveOffsetPartitionResponse setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public ResolveOffsetPartitionResponse setTieredSegmentRange(List<TieredSegmentMetadata> v) {
            this.tieredSegmentRange = v;
            return this;
        }

        public ResolveOffsetPartitionResponse setBrokerRange(BrokerMetadata v) {
            this.brokerRange = v;
            return this;
        }
    }
}

