/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ResolveOffsetRangeResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ResolveOffsetRangeResponseDataJsonConverter {
    public static ResolveOffsetRangeResponseData read(JsonNode _node, short _version) {
        ResolveOffsetRangeResponseData _object = new ResolveOffsetRangeResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("ResolveOffsetRangeResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "ResolveOffsetRangeResponseData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ResolveOffsetRangeResponseData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ResolveOffsetRangeResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse> _collection = new ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(ResolveOffsetRangeTopicResponseJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ResolveOffsetRangeResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse _element : _object.topics) {
            _topicsArray.add(ResolveOffsetRangeTopicResponseJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(ResolveOffsetRangeResponseData _object, short _version) {
        return ResolveOffsetRangeResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class ResolveOffsetRangeTopicResponseJsonConverter {
        public static ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse read(JsonNode _node, short _version) {
            ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse _object = new ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("ResolveOffsetRangeTopicResponse: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("ResolveOffsetRangeTopicResponse expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ResolveOffsetRangeTopicResponse: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ResolveOffsetRangeTopicResponse expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse> _collection = new ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(ResolveOffsetPartitionResponseJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse _element : _object.partitions) {
                _partitionsArray.add(ResolveOffsetPartitionResponseJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse _object, short _version) {
            return ResolveOffsetRangeTopicResponseJsonConverter.write(_object, _version, true);
        }
    }

    public static class TieredSegmentMetadataJsonConverter {
        public static ResolveOffsetRangeResponseData.TieredSegmentMetadata read(JsonNode _node, short _version) {
            ResolveOffsetRangeResponseData.TieredSegmentMetadata _object = new ResolveOffsetRangeResponseData.TieredSegmentMetadata();
            JsonNode _startOffsetNode = _node.get("startOffset");
            if (_startOffsetNode == null) {
                throw new RuntimeException("TieredSegmentMetadata: unable to locate field 'startOffset', which is mandatory in version " + _version);
            }
            _object.startOffset = MessageUtil.jsonNodeToLong(_startOffsetNode, "TieredSegmentMetadata");
            JsonNode _endOffsetNode = _node.get("endOffset");
            if (_endOffsetNode == null) {
                throw new RuntimeException("TieredSegmentMetadata: unable to locate field 'endOffset', which is mandatory in version " + _version);
            }
            _object.endOffset = MessageUtil.jsonNodeToLong(_endOffsetNode, "TieredSegmentMetadata");
            JsonNode _segmentFilesNode = _node.get("segmentFiles");
            if (_segmentFilesNode == null) {
                throw new RuntimeException("TieredSegmentMetadata: unable to locate field 'segmentFiles', which is mandatory in version " + _version);
            }
            if (!_segmentFilesNode.isArray()) {
                throw new RuntimeException("TieredSegmentMetadata expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ResolveOffsetRangeResponseData.SegmentFileMetadata> _collection = new ArrayList<ResolveOffsetRangeResponseData.SegmentFileMetadata>(_segmentFilesNode.size());
            _object.segmentFiles = _collection;
            for (JsonNode _element : _segmentFilesNode) {
                _collection.add(SegmentFileMetadataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.TieredSegmentMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("startOffset", (JsonNode)new LongNode(_object.startOffset));
            _node.set("endOffset", (JsonNode)new LongNode(_object.endOffset));
            ArrayNode _segmentFilesArray = new ArrayNode(JsonNodeFactory.instance);
            for (ResolveOffsetRangeResponseData.SegmentFileMetadata _element : _object.segmentFiles) {
                _segmentFilesArray.add(SegmentFileMetadataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("segmentFiles", (JsonNode)_segmentFilesArray);
            return _node;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.TieredSegmentMetadata _object, short _version) {
            return TieredSegmentMetadataJsonConverter.write(_object, _version, true);
        }
    }

    public static class SegmentFileMetadataJsonConverter {
        public static ResolveOffsetRangeResponseData.SegmentFileMetadata read(JsonNode _node, short _version) {
            ResolveOffsetRangeResponseData.SegmentFileMetadata _object = new ResolveOffsetRangeResponseData.SegmentFileMetadata();
            JsonNode _fragmentTypeByteNode = _node.get("fragmentTypeByte");
            if (_fragmentTypeByteNode == null) {
                throw new RuntimeException("SegmentFileMetadata: unable to locate field 'fragmentTypeByte', which is mandatory in version " + _version);
            }
            _object.fragmentTypeByte = MessageUtil.jsonNodeToByte(_fragmentTypeByteNode, "SegmentFileMetadata");
            JsonNode _locatorNode = _node.get("locator");
            if (_locatorNode == null) {
                throw new RuntimeException("SegmentFileMetadata: unable to locate field 'locator', which is mandatory in version " + _version);
            }
            if (!_locatorNode.isTextual()) {
                throw new RuntimeException("SegmentFileMetadata expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.locator = _locatorNode.asText();
            JsonNode _startBytePositionNode = _node.get("startBytePosition");
            if (_startBytePositionNode == null) {
                throw new RuntimeException("SegmentFileMetadata: unable to locate field 'startBytePosition', which is mandatory in version " + _version);
            }
            _object.startBytePosition = MessageUtil.jsonNodeToLong(_startBytePositionNode, "SegmentFileMetadata");
            JsonNode _endBytePositionNode = _node.get("endBytePosition");
            if (_endBytePositionNode == null) {
                throw new RuntimeException("SegmentFileMetadata: unable to locate field 'endBytePosition', which is mandatory in version " + _version);
            }
            _object.endBytePosition = MessageUtil.jsonNodeToLong(_endBytePositionNode, "SegmentFileMetadata");
            return _object;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.SegmentFileMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("fragmentTypeByte", (JsonNode)new ShortNode((short)_object.fragmentTypeByte));
            _node.set("locator", (JsonNode)new TextNode(_object.locator));
            _node.set("startBytePosition", (JsonNode)new LongNode(_object.startBytePosition));
            _node.set("endBytePosition", (JsonNode)new LongNode(_object.endBytePosition));
            return _node;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.SegmentFileMetadata _object, short _version) {
            return SegmentFileMetadataJsonConverter.write(_object, _version, true);
        }
    }

    public static class ResolveOffsetPartitionResponseJsonConverter {
        public static ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse read(JsonNode _node, short _version) {
            ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse _object = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("ResolveOffsetPartitionResponse: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "ResolveOffsetPartitionResponse");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("ResolveOffsetPartitionResponse: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "ResolveOffsetPartitionResponse");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("ResolveOffsetPartitionResponse: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("ResolveOffsetPartitionResponse expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _tieredSegmentRangeNode = _node.get("tieredSegmentRange");
            if (_tieredSegmentRangeNode == null) {
                throw new RuntimeException("ResolveOffsetPartitionResponse: unable to locate field 'tieredSegmentRange', which is mandatory in version " + _version);
            }
            if (_tieredSegmentRangeNode.isNull()) {
                _object.tieredSegmentRange = null;
            } else {
                if (!_tieredSegmentRangeNode.isArray()) {
                    throw new RuntimeException("ResolveOffsetPartitionResponse expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<ResolveOffsetRangeResponseData.TieredSegmentMetadata> _collection = new ArrayList<ResolveOffsetRangeResponseData.TieredSegmentMetadata>(_tieredSegmentRangeNode.size());
                _object.tieredSegmentRange = _collection;
                for (JsonNode _element : _tieredSegmentRangeNode) {
                    _collection.add(TieredSegmentMetadataJsonConverter.read(_element, _version));
                }
            }
            JsonNode _brokerRangeNode = _node.get("brokerRange");
            if (_brokerRangeNode == null) {
                throw new RuntimeException("ResolveOffsetPartitionResponse: unable to locate field 'brokerRange', which is mandatory in version " + _version);
            }
            _object.brokerRange = _brokerRangeNode.isNull() ? null : BrokerMetadataJsonConverter.read(_brokerRangeNode, _version);
            return _object;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            }
            if (_object.tieredSegmentRange == null) {
                _node.set("tieredSegmentRange", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _tieredSegmentRangeArray = new ArrayNode(JsonNodeFactory.instance);
                for (ResolveOffsetRangeResponseData.TieredSegmentMetadata _element : _object.tieredSegmentRange) {
                    _tieredSegmentRangeArray.add(TieredSegmentMetadataJsonConverter.write(_element, _version, _serializeRecords));
                }
                _node.set("tieredSegmentRange", (JsonNode)_tieredSegmentRangeArray);
            }
            if (_object.brokerRange == null) {
                _node.set("brokerRange", (JsonNode)NullNode.instance);
            } else {
                _node.set("brokerRange", BrokerMetadataJsonConverter.write(_object.brokerRange, _version, _serializeRecords));
            }
            return _node;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse _object, short _version) {
            return ResolveOffsetPartitionResponseJsonConverter.write(_object, _version, true);
        }
    }

    public static class BrokerMetadataJsonConverter {
        public static ResolveOffsetRangeResponseData.BrokerMetadata read(JsonNode _node, short _version) {
            ResolveOffsetRangeResponseData.BrokerMetadata _object = new ResolveOffsetRangeResponseData.BrokerMetadata();
            JsonNode _startOffsetNode = _node.get("startOffset");
            if (_startOffsetNode == null) {
                throw new RuntimeException("BrokerMetadata: unable to locate field 'startOffset', which is mandatory in version " + _version);
            }
            _object.startOffset = MessageUtil.jsonNodeToLong(_startOffsetNode, "BrokerMetadata");
            JsonNode _endOffsetNode = _node.get("endOffset");
            if (_endOffsetNode == null) {
                throw new RuntimeException("BrokerMetadata: unable to locate field 'endOffset', which is mandatory in version " + _version);
            }
            _object.endOffset = MessageUtil.jsonNodeToLong(_endOffsetNode, "BrokerMetadata");
            return _object;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.BrokerMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("startOffset", (JsonNode)new LongNode(_object.startOffset));
            _node.set("endOffset", (JsonNode)new LongNode(_object.endOffset));
            return _node;
        }

        public static JsonNode write(ResolveOffsetRangeResponseData.BrokerMetadata _object, short _version) {
            return BrokerMetadataJsonConverter.write(_object, _version, true);
        }
    }
}

