/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StreamsGroupHeartbeatResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    String memberId;
    int memberEpoch;
    int heartbeatIntervalMs;
    int acceptableRecoveryLag;
    int taskOffsetIntervalMs;
    List<Status> status;
    List<TaskIds> activeTasks;
    List<TaskIds> standbyTasks;
    List<TaskIds> warmupTasks;
    int endpointInformationEpoch;
    List<EndpointToPartitions> partitionsByUserEndpoint;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error"), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."), new Field("member_id", Type.COMPACT_STRING, "The member id is always generated by the streams consumer."), new Field("member_epoch", Type.INT32, "The member epoch."), new Field("heartbeat_interval_ms", Type.INT32, "The heartbeat interval in milliseconds."), new Field("acceptable_recovery_lag", Type.INT32, "The maximal lag a warm-up task can have to be considered caught-up."), new Field("task_offset_interval_ms", Type.INT32, "The interval in which the task changelog offsets on a client are updated on the broker. The offsets are sent with the next heartbeat after this time has passed."), new Field("status", CompactArrayOf.nullable(Status.SCHEMA_0), "Indicate zero or more status for the group.  Null if unchanged since last heartbeat."), new Field("active_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Assigned active tasks for this client. Null if unchanged since last heartbeat."), new Field("standby_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Assigned standby tasks for this client. Null if unchanged since last heartbeat."), new Field("warmup_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Assigned warm-up tasks for this client. Null if unchanged since last heartbeat."), new Field("endpoint_information_epoch", Type.INT32, "The endpoint epoch set in the response"), new Field("partitions_by_user_endpoint", CompactArrayOf.nullable(EndpointToPartitions.SCHEMA_0), "Global assignment information used for IQ. Null if unchanged since last heartbeat."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public StreamsGroupHeartbeatResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public StreamsGroupHeartbeatResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = null;
        this.memberId = "";
        this.memberEpoch = 0;
        this.heartbeatIntervalMs = 0;
        this.acceptableRecoveryLag = 0;
        this.taskOffsetIntervalMs = 0;
        this.status = null;
        this.activeTasks = null;
        this.standbyTasks = null;
        this.warmupTasks = null;
        this.endpointInformationEpoch = 0;
        this.partitionsByUserEndpoint = null;
    }

    @Override
    public short apiKey() {
        return 88;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<Status> newCollection;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        this.memberEpoch = _readable.readInt();
        this.heartbeatIntervalMs = _readable.readInt();
        this.acceptableRecoveryLag = _readable.readInt();
        this.taskOffsetIntervalMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.status = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<Status>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new Status(_readable, _version, _context));
            }
            this.status = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.activeTasks = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((Status)((Object)new TaskIds(_readable, _version, _context)));
            }
            this.activeTasks = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.standbyTasks = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((Status)((Object)new TaskIds(_readable, _version, _context)));
            }
            this.standbyTasks = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.warmupTasks = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((Status)((Object)new TaskIds(_readable, _version, _context)));
            }
            this.warmupTasks = newCollection;
        }
        this.endpointInformationEpoch = _readable.readInt();
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.partitionsByUserEndpoint = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((Status)((Object)new EndpointToPartitions(_readable, _version, _context)));
            }
            this.partitionsByUserEndpoint = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _stringBytes = _cache.getSerializedValue(this.memberId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.memberEpoch);
        _writable.writeInt(this.heartbeatIntervalMs);
        _writable.writeInt(this.acceptableRecoveryLag);
        _writable.writeInt(this.taskOffsetIntervalMs);
        if (this.status == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.status.size() + 1);
            _stringBytes = this.status.iterator();
            while (_stringBytes.hasNext()) {
                Status statusElement = (Status)_stringBytes.next();
                statusElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.activeTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.activeTasks.size() + 1);
            for (TaskIds activeTasksElement : this.activeTasks) {
                activeTasksElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.standbyTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.standbyTasks.size() + 1);
            for (TaskIds standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.warmupTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.warmupTasks.size() + 1);
            for (TaskIds warmupTasksElement : this.warmupTasks) {
                warmupTasksElement.write(_writable, _cache, _version, _context);
            }
        }
        _writable.writeInt(this.endpointInformationEpoch);
        if (this.partitionsByUserEndpoint == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.partitionsByUserEndpoint.size() + 1);
            for (EndpointToPartitions partitionsByUserEndpointElement : this.partitionsByUserEndpoint) {
                partitionsByUserEndpointElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        if (this.status == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.status.size() + 1));
            for (Status statusElement : this.status) {
                statusElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.activeTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.activeTasks.size() + 1));
            for (TaskIds activeTasksElement : this.activeTasks) {
                activeTasksElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.standbyTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.standbyTasks.size() + 1));
            for (TaskIds standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.warmupTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.warmupTasks.size() + 1));
            for (TaskIds warmupTasksElement : this.warmupTasks) {
                warmupTasksElement.addSize(_size, _cache, _version, _context);
            }
        }
        _size.addBytes(4);
        if (this.partitionsByUserEndpoint == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionsByUserEndpoint.size() + 1));
            for (EndpointToPartitions partitionsByUserEndpointElement : this.partitionsByUserEndpoint) {
                partitionsByUserEndpointElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupHeartbeatResponseData)) {
            return false;
        }
        StreamsGroupHeartbeatResponseData other = (StreamsGroupHeartbeatResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.memberEpoch != other.memberEpoch) {
            return false;
        }
        if (this.heartbeatIntervalMs != other.heartbeatIntervalMs) {
            return false;
        }
        if (this.acceptableRecoveryLag != other.acceptableRecoveryLag) {
            return false;
        }
        if (this.taskOffsetIntervalMs != other.taskOffsetIntervalMs) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.activeTasks == null ? other.activeTasks != null : !this.activeTasks.equals(other.activeTasks)) {
            return false;
        }
        if (this.standbyTasks == null ? other.standbyTasks != null : !this.standbyTasks.equals(other.standbyTasks)) {
            return false;
        }
        if (this.warmupTasks == null ? other.warmupTasks != null : !this.warmupTasks.equals(other.warmupTasks)) {
            return false;
        }
        if (this.endpointInformationEpoch != other.endpointInformationEpoch) {
            return false;
        }
        if (this.partitionsByUserEndpoint == null ? other.partitionsByUserEndpoint != null : !this.partitionsByUserEndpoint.equals(other.partitionsByUserEndpoint)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + this.memberEpoch;
        hashCode = 31 * hashCode + this.heartbeatIntervalMs;
        hashCode = 31 * hashCode + this.acceptableRecoveryLag;
        hashCode = 31 * hashCode + this.taskOffsetIntervalMs;
        hashCode = 31 * hashCode + (this.status == null ? 0 : this.status.hashCode());
        hashCode = 31 * hashCode + (this.activeTasks == null ? 0 : this.activeTasks.hashCode());
        hashCode = 31 * hashCode + (this.standbyTasks == null ? 0 : this.standbyTasks.hashCode());
        hashCode = 31 * hashCode + (this.warmupTasks == null ? 0 : this.warmupTasks.hashCode());
        hashCode = 31 * hashCode + this.endpointInformationEpoch;
        hashCode = 31 * hashCode + (this.partitionsByUserEndpoint == null ? 0 : this.partitionsByUserEndpoint.hashCode());
        return hashCode;
    }

    @Override
    public StreamsGroupHeartbeatResponseData duplicate() {
        StreamsGroupHeartbeatResponseData _duplicate = new StreamsGroupHeartbeatResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.memberId = this.memberId;
        _duplicate.memberEpoch = this.memberEpoch;
        _duplicate.heartbeatIntervalMs = this.heartbeatIntervalMs;
        _duplicate.acceptableRecoveryLag = this.acceptableRecoveryLag;
        _duplicate.taskOffsetIntervalMs = this.taskOffsetIntervalMs;
        if (this.status == null) {
            _duplicate.status = null;
        } else {
            ArrayList<Status> newStatus = new ArrayList<Status>(this.status.size());
            for (Status status : this.status) {
                newStatus.add(status.duplicate());
            }
            _duplicate.status = newStatus;
        }
        if (this.activeTasks == null) {
            _duplicate.activeTasks = null;
        } else {
            ArrayList<TaskIds> newActiveTasks = new ArrayList<TaskIds>(this.activeTasks.size());
            for (TaskIds taskIds : this.activeTasks) {
                newActiveTasks.add(taskIds.duplicate());
            }
            _duplicate.activeTasks = newActiveTasks;
        }
        if (this.standbyTasks == null) {
            _duplicate.standbyTasks = null;
        } else {
            ArrayList<TaskIds> newStandbyTasks = new ArrayList<TaskIds>(this.standbyTasks.size());
            for (TaskIds taskIds : this.standbyTasks) {
                newStandbyTasks.add(taskIds.duplicate());
            }
            _duplicate.standbyTasks = newStandbyTasks;
        }
        if (this.warmupTasks == null) {
            _duplicate.warmupTasks = null;
        } else {
            ArrayList<TaskIds> newWarmupTasks = new ArrayList<TaskIds>(this.warmupTasks.size());
            for (TaskIds taskIds : this.warmupTasks) {
                newWarmupTasks.add(taskIds.duplicate());
            }
            _duplicate.warmupTasks = newWarmupTasks;
        }
        _duplicate.endpointInformationEpoch = this.endpointInformationEpoch;
        if (this.partitionsByUserEndpoint == null) {
            _duplicate.partitionsByUserEndpoint = null;
        } else {
            ArrayList<EndpointToPartitions> newPartitionsByUserEndpoint = new ArrayList<EndpointToPartitions>(this.partitionsByUserEndpoint.size());
            for (EndpointToPartitions endpointToPartitions : this.partitionsByUserEndpoint) {
                newPartitionsByUserEndpoint.add(endpointToPartitions.duplicate());
            }
            _duplicate.partitionsByUserEndpoint = newPartitionsByUserEndpoint;
        }
        return _duplicate;
    }

    public String toString() {
        return "StreamsGroupHeartbeatResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", memberEpoch=" + this.memberEpoch + ", heartbeatIntervalMs=" + this.heartbeatIntervalMs + ", acceptableRecoveryLag=" + this.acceptableRecoveryLag + ", taskOffsetIntervalMs=" + this.taskOffsetIntervalMs + ", status=" + (this.status == null ? "null" : MessageUtil.deepToString(this.status.iterator())) + ", activeTasks=" + (this.activeTasks == null ? "null" : MessageUtil.deepToString(this.activeTasks.iterator())) + ", standbyTasks=" + (this.standbyTasks == null ? "null" : MessageUtil.deepToString(this.standbyTasks.iterator())) + ", warmupTasks=" + (this.warmupTasks == null ? "null" : MessageUtil.deepToString(this.warmupTasks.iterator())) + ", endpointInformationEpoch=" + this.endpointInformationEpoch + ", partitionsByUserEndpoint=" + (this.partitionsByUserEndpoint == null ? "null" : MessageUtil.deepToString(this.partitionsByUserEndpoint.iterator())) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public int heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public int acceptableRecoveryLag() {
        return this.acceptableRecoveryLag;
    }

    public int taskOffsetIntervalMs() {
        return this.taskOffsetIntervalMs;
    }

    public List<Status> status() {
        return this.status;
    }

    public List<TaskIds> activeTasks() {
        return this.activeTasks;
    }

    public List<TaskIds> standbyTasks() {
        return this.standbyTasks;
    }

    public List<TaskIds> warmupTasks() {
        return this.warmupTasks;
    }

    public int endpointInformationEpoch() {
        return this.endpointInformationEpoch;
    }

    public List<EndpointToPartitions> partitionsByUserEndpoint() {
        return this.partitionsByUserEndpoint;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StreamsGroupHeartbeatResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setHeartbeatIntervalMs(int v) {
        this.heartbeatIntervalMs = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setAcceptableRecoveryLag(int v) {
        this.acceptableRecoveryLag = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setTaskOffsetIntervalMs(int v) {
        this.taskOffsetIntervalMs = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setStatus(List<Status> v) {
        this.status = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setActiveTasks(List<TaskIds> v) {
        this.activeTasks = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setStandbyTasks(List<TaskIds> v) {
        this.standbyTasks = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setWarmupTasks(List<TaskIds> v) {
        this.warmupTasks = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setEndpointInformationEpoch(int v) {
        this.endpointInformationEpoch = v;
        return this;
    }

    public StreamsGroupHeartbeatResponseData setPartitionsByUserEndpoint(List<EndpointToPartitions> v) {
        this.partitionsByUserEndpoint = v;
        return this;
    }

    public static class Status
    implements Message {
        byte statusCode;
        String statusDetail;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("status_code", Type.INT8, "A code to indicate that a particular status is active for the group membership"), new Field("status_detail", Type.COMPACT_STRING, "A string representation of the status."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Status(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Status() {
            this.statusCode = 0;
            this.statusDetail = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            this.statusCode = _readable.readByte();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field statusDetail was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field statusDetail had invalid length " + length);
            }
            this.statusDetail = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.statusCode);
            byte[] _stringBytes = _cache.getSerializedValue(this.statusDetail);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _size.addBytes(1);
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.statusDetail).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'statusDetail' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.statusDetail, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Status)) {
                return false;
            }
            Status other = (Status)obj;
            if (this.statusCode != other.statusCode) {
                return false;
            }
            if (this.statusDetail == null ? other.statusDetail != null : !this.statusDetail.equals(other.statusDetail)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.statusCode;
            hashCode = 31 * hashCode + (this.statusDetail == null ? 0 : this.statusDetail.hashCode());
            return hashCode;
        }

        @Override
        public Status duplicate() {
            Status _duplicate = new Status();
            _duplicate.statusCode = this.statusCode;
            _duplicate.statusDetail = this.statusDetail;
            return _duplicate;
        }

        public String toString() {
            return "Status(statusCode=" + this.statusCode + ", statusDetail=" + (String)(this.statusDetail == null ? "null" : "'" + this.statusDetail.toString() + "'") + ")";
        }

        public byte statusCode() {
            return this.statusCode;
        }

        public String statusDetail() {
            return this.statusDetail;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Status setStatusCode(byte v) {
            this.statusCode = v;
            return this;
        }

        public Status setStatusDetail(String v) {
            this.statusDetail = v;
            return this;
        }
    }

    public static class TaskIds
    implements Message {
        String subtopologyId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("subtopology_id", Type.COMPACT_STRING, "The subtopology identifier."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions of the input topics processed by this member."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskIds(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TaskIds() {
            this.subtopologyId = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length);
            }
            this.subtopologyId = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.subtopologyId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.subtopologyId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskIds)) {
                return false;
            }
            TaskIds other = (TaskIds)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TaskIds duplicate() {
            TaskIds _duplicate = new TaskIds();
            _duplicate.subtopologyId = this.subtopologyId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TaskIds(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskIds setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public TaskIds setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class EndpointToPartitions
    implements Message {
        Endpoint userEndpoint;
        List<TopicPartition> activePartitions;
        List<TopicPartition> standbyPartitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("user_endpoint", Endpoint.SCHEMA_0, "User-defined endpoint to connect to the node"), new Field("active_partitions", new CompactArrayOf(TopicPartition.SCHEMA_0), "All topic partitions materialized by active tasks on the node"), new Field("standby_partitions", new CompactArrayOf(TopicPartition.SCHEMA_0), "All topic partitions materialized by standby tasks on the node"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EndpointToPartitions(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EndpointToPartitions() {
            this.userEndpoint = new Endpoint();
            this.activePartitions = new ArrayList<TopicPartition>(0);
            this.standbyPartitions = new ArrayList<TopicPartition>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EndpointToPartitions");
            }
            this.userEndpoint = new Endpoint(_readable, _version, _context);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field activePartitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<TopicPartition> newCollection = new ArrayList<TopicPartition>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicPartition(_readable, _version, _context));
            }
            this.activePartitions = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field standbyPartitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicPartition(_readable, _version, _context));
            }
            this.standbyPartitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            this.userEndpoint.write(_writable, _cache, _version, _context);
            _writable.writeUnsignedVarint(this.activePartitions.size() + 1);
            for (TopicPartition activePartitionsElement : this.activePartitions) {
                activePartitionsElement.write(_writable, _cache, _version, _context);
            }
            _writable.writeUnsignedVarint(this.standbyPartitions.size() + 1);
            for (TopicPartition standbyPartitionsElement : this.standbyPartitions) {
                standbyPartitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EndpointToPartitions");
            }
            this.userEndpoint.addSize(_size, _cache, _version, _context);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.activePartitions.size() + 1));
            for (TopicPartition activePartitionsElement : this.activePartitions) {
                activePartitionsElement.addSize(_size, _cache, _version, _context);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.standbyPartitions.size() + 1));
            for (TopicPartition standbyPartitionsElement : this.standbyPartitions) {
                standbyPartitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EndpointToPartitions)) {
                return false;
            }
            EndpointToPartitions other = (EndpointToPartitions)obj;
            if (this.userEndpoint == null ? other.userEndpoint != null : !this.userEndpoint.equals(other.userEndpoint)) {
                return false;
            }
            if (this.activePartitions == null ? other.activePartitions != null : !this.activePartitions.equals(other.activePartitions)) {
                return false;
            }
            if (this.standbyPartitions == null ? other.standbyPartitions != null : !this.standbyPartitions.equals(other.standbyPartitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.userEndpoint == null ? 0 : this.userEndpoint.hashCode());
            hashCode = 31 * hashCode + (this.activePartitions == null ? 0 : this.activePartitions.hashCode());
            hashCode = 31 * hashCode + (this.standbyPartitions == null ? 0 : this.standbyPartitions.hashCode());
            return hashCode;
        }

        @Override
        public EndpointToPartitions duplicate() {
            EndpointToPartitions _duplicate = new EndpointToPartitions();
            _duplicate.userEndpoint = this.userEndpoint.duplicate();
            ArrayList<TopicPartition> newActivePartitions = new ArrayList<TopicPartition>(this.activePartitions.size());
            for (TopicPartition _element : this.activePartitions) {
                newActivePartitions.add(_element.duplicate());
            }
            _duplicate.activePartitions = newActivePartitions;
            ArrayList<TopicPartition> newStandbyPartitions = new ArrayList<TopicPartition>(this.standbyPartitions.size());
            for (TopicPartition _element : this.standbyPartitions) {
                newStandbyPartitions.add(_element.duplicate());
            }
            _duplicate.standbyPartitions = newStandbyPartitions;
            return _duplicate;
        }

        public String toString() {
            return "EndpointToPartitions(userEndpoint=" + this.userEndpoint.toString() + ", activePartitions=" + MessageUtil.deepToString(this.activePartitions.iterator()) + ", standbyPartitions=" + MessageUtil.deepToString(this.standbyPartitions.iterator()) + ")";
        }

        public Endpoint userEndpoint() {
            return this.userEndpoint;
        }

        public List<TopicPartition> activePartitions() {
            return this.activePartitions;
        }

        public List<TopicPartition> standbyPartitions() {
            return this.standbyPartitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EndpointToPartitions setUserEndpoint(Endpoint v) {
            this.userEndpoint = v;
            return this;
        }

        public EndpointToPartitions setActivePartitions(List<TopicPartition> v) {
            this.activePartitions = v;
            return this;
        }

        public EndpointToPartitions setStandbyPartitions(List<TopicPartition> v) {
            this.standbyPartitions = v;
            return this;
        }
    }

    public static class TopicPartition
    implements Message {
        String topic;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "topic name"), new Field("partitions", new CompactArrayOf(Type.INT32), "partitions"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicPartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicPartition() {
            this.topic = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartition)) {
                return false;
            }
            TopicPartition other = (TopicPartition)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicPartition duplicate() {
            TopicPartition _duplicate = new TopicPartition();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartition(topic=" + (String)(this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartition setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicPartition setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class Endpoint
    implements Message {
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("host", Type.COMPACT_STRING, "host of the endpoint"), new Field("port", Type.UINT16, "port of the endpoint"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Endpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Endpoint() {
            this.host = "";
            this.port = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Endpoint)) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        @Override
        public Endpoint duplicate() {
            Endpoint _duplicate = new Endpoint();
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "Endpoint(host=" + (String)(this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Endpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public Endpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }
    }
}

