/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.network.AbstractProxyProtocolEngine;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;
import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvType;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ProxyProtocolCombinedEngine
extends AbstractProxyProtocolEngine {
    private static final String INVALID_PROXY_PROTOCOL_HEADER = "Invalid Proxy Protocol Header matches neither V1 nor V2.";
    private AbstractProxyProtocolEngine activeEngine;
    private Map<String, ?> storedConfigs;
    private final LogContext logContext;
    private final Logger log;

    public ProxyProtocolCombinedEngine(ConnectionMode connectionMode, LogContext logContext) {
        this(connectionMode, logContext, null);
    }

    public ProxyProtocolCombinedEngine(ConnectionMode connectionMode, LogContext logContext, ChannelMetadataRegistry channelMetadataRegistry) {
        super(connectionMode, logContext, channelMetadataRegistry);
        this.logContext = logContext;
        this.log = logContext.logger(this.getClass());
        this.storedConfigs = Collections.emptyMap();
        if (connectionMode != ConnectionMode.SERVER) {
            this.log.error("The combined PROXY protocol engine only supports SERVER mode.");
            throw new IllegalArgumentException("ProxyProtocolCombinedEngine only supports SERVER mode.");
        }
    }

    @Override
    public void processHeaders(ByteBuffer buf) throws IOException {
        if (this.activeEngine == null) {
            this.assignActiveEngine(buf);
        }
        if (this.activeEngine != null) {
            buf.position(0);
            this.activeEngine.processHeaders(buf);
        }
    }

    private void assignActiveEngine(ByteBuffer buf) throws IOException {
        AbstractProxyProtocolEngine.CheckProtocolResult v1Result = ProxyProtocolV1Engine.checkForProtocolSignature(buf);
        if (v1Result == AbstractProxyProtocolEngine.CheckProtocolResult.SUCCESS) {
            this.log.debug("Proxy protocol V1 detected.");
            this.activeEngine = new ProxyProtocolV1Engine(this.connectionMode, this.logContext, this.metadataRegistry);
            this.activeEngine.configure(this.storedConfigs);
            return;
        }
        AbstractProxyProtocolEngine.CheckProtocolResult v2Result = ProxyProtocolV2Engine.checkForProtocolSignature(buf);
        if (v2Result == AbstractProxyProtocolEngine.CheckProtocolResult.SUCCESS) {
            this.log.debug("Proxy protocol V2 detected.");
            this.activeEngine = new ProxyProtocolV2Engine(this.connectionMode, this.logContext, this.metadataRegistry);
            this.activeEngine.configure(this.storedConfigs);
            return;
        }
        if (v1Result == AbstractProxyProtocolEngine.CheckProtocolResult.NOT_ENOUGH_BYTES || v2Result == AbstractProxyProtocolEngine.CheckProtocolResult.NOT_ENOUGH_BYTES) {
            this.log.debug("Not enough bytes detected for either V1 or V2.");
            return;
        }
        if (v1Result == AbstractProxyProtocolEngine.CheckProtocolResult.FAILURE && v2Result == AbstractProxyProtocolEngine.CheckProtocolResult.FAILURE) {
            if (this.proxyProtocolFallbackEnabled) {
                this.log.debug("No proxy protocol detected on combined engine. Fallback enabled, setting to V2 with fallback.");
                this.activeEngine = new ProxyProtocolV2Engine(this.connectionMode, this.logContext, this.metadataRegistry);
                this.activeEngine.configure(this.storedConfigs);
                return;
            }
            throw new IOException(INVALID_PROXY_PROTOCOL_HEADER);
        }
    }

    @Override
    public byte[] emitHeaders(InetAddress destinationAddress, int destinationPort) throws IOException {
        throw new IllegalStateException("Proxy Protocol combined engine should not be used in CLIENT mode to emit headers.");
    }

    @Override
    public boolean hasClientInformation() {
        if (this.activeEngine != null) {
            return this.activeEngine.hasClientInformation();
        }
        this.log.warn("No active proxy protocol engine to determine has client information.");
        return false;
    }

    @Override
    public InetAddress clientAddress() {
        if (this.activeEngine != null) {
            return this.activeEngine.clientAddress();
        }
        this.log.warn("No active proxy protocol engine to determine client address.");
        return null;
    }

    @Override
    public int clientPort() {
        if (this.activeEngine != null) {
            return this.activeEngine.clientPort();
        }
        this.log.warn("No active proxy protocol engine to determine client port.");
        return -1;
    }

    @Override
    public boolean ready() {
        if (this.activeEngine != null) {
            return this.activeEngine.ready();
        }
        this.log.debug("No active proxy protocol engine to determine readiness.");
        return false;
    }

    @Override
    public ProxyTlv tlv(ProxyTlvType type) {
        if (this.activeEngine != null) {
            return this.activeEngine.tlv(type);
        }
        this.log.warn("No active proxy protocol engine to get tlv.");
        return null;
    }

    @Override
    public ProxyProtocolCommand command() {
        if (this.activeEngine != null) {
            return this.activeEngine.command();
        }
        this.log.warn("No active proxy protocol engine to get command.");
        return null;
    }

    @Override
    public boolean includeOutgoingProxyHeader() {
        if (this.activeEngine != null) {
            return this.activeEngine.includeOutgoingProxyHeader();
        }
        this.log.warn("No active proxy protocol engine to determine including outgoing proxy header.");
        return false;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.storedConfigs = configs;
        if (this.activeEngine != null) {
            this.activeEngine.configure(this.storedConfigs);
        }
    }

    @Override
    protected IOException invalidProtocolHeaderException(String s2) {
        return new IOException("Invalid Proxy Protocol Header matches neither V1 nor V2. " + s2);
    }

    public ProxyProtocolEngine getActiveEngine() {
        return this.activeEngine;
    }
}

