/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.NoOpProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCombinedEngine;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;
import org.apache.kafka.common.utils.LogContext;

public class ProxyProtocolEngineFactory {
    private final Function<ChannelMetadataRegistry, ProxyProtocolEngine> proxyProtocolEngineSupplier;

    public ProxyProtocolEngineFactory(ProxyProtocol proxyProtocol) {
        this(proxyProtocol, Collections.emptyMap(), ConnectionMode.SERVER, new LogContext());
    }

    ProxyProtocolEngineFactory(Function<ChannelMetadataRegistry, ProxyProtocolEngine> proxyProtocolEngineSupplier) {
        this.proxyProtocolEngineSupplier = proxyProtocolEngineSupplier;
    }

    public ProxyProtocolEngineFactory(ProxyProtocol proxyProtocol, Map<String, Object> configs, ConnectionMode connectionMode, LogContext logContext) {
        this.proxyProtocolEngineSupplier = metadataRegistry -> {
            ProxyProtocolEngine engine;
            switch (proxyProtocol) {
                case V1: {
                    engine = new ProxyProtocolV1Engine(connectionMode, logContext, (ChannelMetadataRegistry)metadataRegistry);
                    break;
                }
                case V2: {
                    engine = new ProxyProtocolV2Engine(connectionMode, logContext, (ChannelMetadataRegistry)metadataRegistry);
                    break;
                }
                case COMBINED: {
                    engine = new ProxyProtocolCombinedEngine(connectionMode, logContext, (ChannelMetadataRegistry)metadataRegistry);
                    break;
                }
                case NONE: {
                    engine = new NoOpProxyProtocolEngine(connectionMode);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized PROXY protocol version " + String.valueOf((Object)proxyProtocol));
                }
            }
            engine.configure(configs);
            return engine;
        };
    }

    ProxyProtocolEngine createProxyProtocolEngine(ChannelMetadataRegistry metadataRegistry) {
        return this.proxyProtocolEngineSupplier.apply(metadataRegistry);
    }
}

