/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.kafka.common.network.ProxyTlvType;

public class ProxyTlv {
    public final ProxyTlvType type;
    public final int length;
    public final byte[] value;
    private final Object computedValue;

    public ProxyTlv(ProxyTlvType type, byte[] value) {
        this(type, value, null);
    }

    public ProxyTlv(ProxyTlvType type, byte[] value, Object computedValue) {
        this.type = type;
        this.length = value.length;
        this.value = value;
        this.computedValue = computedValue;
    }

    public static ProxyTlv createForSubtype(ProxyTlvType type, String value) {
        return ProxyTlv.createForSubtypeWithCharSet(type, value, StandardCharsets.UTF_8);
    }

    public static ProxyTlv createForSubtypeWithCharSet(ProxyTlvType type, String value, Charset tlvEncodingCharSet) {
        return ProxyTlv.createForSubType(type, value.getBytes(tlvEncodingCharSet));
    }

    public static ProxyTlv createForSubType(ProxyTlvType type, byte[] value) {
        if (type.subtype().isEmpty()) {
            throw new IllegalArgumentException("Type " + String.valueOf(type) + " does not have a subtype");
        }
        byte[] buf = new byte[value.length + 1];
        buf[0] = (byte)(type.subtype().get() & 0xFF);
        System.arraycopy(value, 0, buf, 1, value.length);
        return new ProxyTlv(type, buf);
    }

    public static ProxyTlv create(ProxyTlvType type, byte[] value) {
        if (type.subtype().isPresent()) {
            return ProxyTlv.createForSubType(type, value);
        }
        return new ProxyTlv(type, value);
    }

    public ProxyTlvType type() {
        return this.type;
    }

    public int length() {
        return this.length;
    }

    public byte[] rawValue() {
        return this.value;
    }

    public Object computedValue() {
        if (this.computedValue != null) {
            return this.computedValue;
        }
        return this.type.computeValue(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyTlv proxyTlv = (ProxyTlv)o;
        return this.length == proxyTlv.length && this.type.equals(proxyTlv.type) && Arrays.equals(this.value, proxyTlv.value);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.length);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ProxyTlv.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(this.type)).add("length=" + this.length).add("value=" + Arrays.toString(this.value)).toString();
    }
}

