/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class BrokerRegistrationResponse
extends AbstractResponse {
    private final BrokerRegistrationResponseData data;

    public BrokerRegistrationResponse(BrokerRegistrationResponseData data) {
        super(ApiKeys.BROKER_REGISTRATION);
        this.data = data;
    }

    @Override
    public BrokerRegistrationResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        errorCounts.put(Errors.forCode(this.data.errorCode()), 1);
        return errorCounts;
    }

    public static BrokerRegistrationResponse parse(Readable readable, short version, MessageContext context) {
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData(readable, version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public String toString() {
        return this.data.toString();
    }
}

