/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ConsumerGroupHeartbeatResponse
extends AbstractResponse {
    private final ConsumerGroupHeartbeatResponseData data;

    public ConsumerGroupHeartbeatResponse(ConsumerGroupHeartbeatResponseData data) {
        super(ApiKeys.CONSUMER_GROUP_HEARTBEAT);
        this.data = data;
    }

    @Override
    public ConsumerGroupHeartbeatResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ConsumerGroupHeartbeatResponse parse(Readable readable, short version, MessageContext context) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData(readable, version, context));
    }

    public static ConsumerGroupHeartbeatResponseData.Assignment createAssignment(Map<Uuid, Set<Integer>> assignment) {
        List<ConsumerGroupHeartbeatResponseData.TopicPartitions> topicPartitions = assignment.entrySet().stream().map(keyValue -> new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)keyValue.getKey()).setPartitions(new ArrayList<Integer>((Collection)keyValue.getValue()))).collect(Collectors.toList());
        return new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(topicPartitions);
    }
}

