/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class CreateTopicsResponse
extends AbstractResponse {
    private final CreateTopicsResponseData data;

    public CreateTopicsResponse(CreateTopicsResponseData data) {
        super(ApiKeys.CREATE_TOPICS);
        this.data = data;
    }

    @Override
    public CreateTopicsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.topics().forEach(result -> CreateTopicsResponse.updateErrorCounts(counts, Errors.forCode(result.errorCode())));
        return counts;
    }

    public static CreateTopicsResponse parse(Readable readable, short version, MessageContext context) {
        return new CreateTopicsResponse(new CreateTopicsResponseData(readable, version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }

    public CreateTopicsResponse updateResponseWithValidationErrors(Map<CreateTopicsRequestData.CreatableTopic, ApiError> validationErrors) {
        if (validationErrors.isEmpty()) {
            return this;
        }
        validationErrors.forEach((topic, error) -> this.data.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setErrorCode(error.error().code()).setErrorMessage(error.message()).setName(topic.name())));
        return this;
    }
}

