/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.common.message.DescribeEvenClusterLoadStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeEvenClusterLoadStatusResponse
extends AbstractResponse {
    private final DescribeEvenClusterLoadStatusResponseData data;

    public DescribeEvenClusterLoadStatusResponse(DescribeEvenClusterLoadStatusResponseData data) {
        super(ApiKeys.DESCRIBE_EVEN_CLUSTER_LOAD_STATUS);
        this.data = data;
    }

    @Override
    public DescribeEvenClusterLoadStatusResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short apiVersion) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static DescribeEvenClusterLoadStatusResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeEvenClusterLoadStatusResponse(new DescribeEvenClusterLoadStatusResponseData(readable, version, context));
    }

    public static DescribeEvenClusterLoadStatusResponse prepareResponse(short apiVersion, int throttleTimeMs, DescribeEvenClusterLoadStatusResponseData responseData) {
        responseData.setThrottleTimeMs(throttleTimeMs);
        if (apiVersion < 1 && responseData.evenClusterLoadStatus().healUnevenLoadTrigger().equals(BalancerSelfHealMode.EMPTY_BROKER.name())) {
            responseData.evenClusterLoadStatus().setCurrentStatus(EvenClusterLoadStatus.DISABLED.name());
            responseData.evenClusterLoadStatus().setCurrentStatusLastUpdateTimeMs(0L);
            responseData.evenClusterLoadStatus().setPreviousStatus(null);
            responseData.evenClusterLoadStatus().setPreviousStatusLastUpdateTimeMs(0L);
            responseData.evenClusterLoadStatus().setEvenClusterLoadErrorCode((short)0);
            responseData.evenClusterLoadStatus().setEvenClusterLoadErrorMessage(null);
        }
        return new DescribeEvenClusterLoadStatusResponse(responseData);
    }
}

