/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeProducersResponse
extends AbstractResponse {
    private final DescribeProducersResponseData data;

    public DescribeProducersResponse(DescribeProducersResponseData data) {
        super(ApiKeys.DESCRIBE_PRODUCERS);
        this.data = data;
    }

    @Override
    public DescribeProducersResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (DescribeProducersResponseData.TopicResponse topicResponse : this.data.topics()) {
            for (DescribeProducersResponseData.PartitionResponse partitionResponse : topicResponse.partitions()) {
                DescribeProducersResponse.updateErrorCounts(errorCounts, Errors.forCode(partitionResponse.errorCode()));
            }
        }
        return errorCounts;
    }

    public static DescribeProducersResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeProducersResponse(new DescribeProducersResponseData(readable, version, context));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }
}

