/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public final class FetchSnapshotResponse
extends AbstractResponse {
    private final FetchSnapshotResponseData data;

    public FetchSnapshotResponse(FetchSnapshotResponseData data) {
        super(ApiKeys.FETCH_SNAPSHOT);
        this.data = data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errors = new EnumMap<Errors, Integer>(Errors.class);
        Errors topLevelError = Errors.forCode(this.data.errorCode());
        if (topLevelError != Errors.NONE) {
            errors.put(topLevelError, 1);
        }
        for (FetchSnapshotResponseData.TopicSnapshot topicResponse : this.data.topics()) {
            for (FetchSnapshotResponseData.PartitionSnapshot partitionResponse : topicResponse.partitions()) {
                errors.compute(Errors.forCode(partitionResponse.errorCode()), (error, count) -> count == null ? 1 : count + 1);
            }
        }
        return errors;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public FetchSnapshotResponseData data() {
        return this.data;
    }

    public static FetchSnapshotResponseData withTopLevelError(Errors error) {
        return new FetchSnapshotResponseData().setErrorCode(error.code());
    }

    public static Optional<FetchSnapshotResponseData.PartitionSnapshot> forTopicPartition(FetchSnapshotResponseData data, TopicPartition topicPartition) {
        return data.topics().stream().filter(topic -> topic.name().equals(topicPartition.topic())).flatMap(topic -> topic.partitions().stream()).filter(partition -> partition.index() == topicPartition.partition()).findAny();
    }

    public static FetchSnapshotResponse parse(Readable readable, short version, MessageContext context) {
        return new FetchSnapshotResponse(new FetchSnapshotResponseData(readable, version, context));
    }
}

