/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class IncrementalAlterConfigsResponse
extends AbstractResponse {
    private final IncrementalAlterConfigsResponseData data;

    public IncrementalAlterConfigsResponse(int requestThrottleMs, Map<ConfigResource, ApiError> results) {
        super(ApiKeys.INCREMENTAL_ALTER_CONFIGS);
        ArrayList<IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse> newResults = new ArrayList<IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse>(results.size());
        results.forEach((resource, error) -> newResults.add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(error.error().code()).setErrorMessage(error.message()).setResourceName(resource.name()).setResourceType(resource.type().id())));
        this.data = new IncrementalAlterConfigsResponseData().setResponses(newResults).setThrottleTimeMs(requestThrottleMs);
    }

    public static Map<ConfigResource, ApiError> fromResponseData(IncrementalAlterConfigsResponseData data) {
        HashMap<ConfigResource, ApiError> map = new HashMap<ConfigResource, ApiError>();
        for (IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse response : data.responses()) {
            map.put(new ConfigResource(ConfigResource.Type.forId(response.resourceType()), response.resourceName()), new ApiError(Errors.forCode(response.errorCode()), response.errorMessage()));
        }
        return map;
    }

    public IncrementalAlterConfigsResponse(IncrementalAlterConfigsResponseData data) {
        super(ApiKeys.INCREMENTAL_ALTER_CONFIGS);
        this.data = data;
    }

    @Override
    public IncrementalAlterConfigsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.responses().forEach(response -> IncrementalAlterConfigsResponse.updateErrorCounts(counts, Errors.forCode(response.errorCode())));
        return counts;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 0;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static IncrementalAlterConfigsResponse parse(Readable readable, short version, MessageContext context) {
        return new IncrementalAlterConfigsResponse(new IncrementalAlterConfigsResponseData(readable, version, context));
    }
}

