/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitiateReverseConnectionsResponse;

public class InitiateReverseConnectionsRequest
extends AbstractRequest {
    private final InitiateReverseConnectionsRequestData data;

    public InitiateReverseConnectionsRequest(InitiateReverseConnectionsRequestData data, short apiVersion) {
        super(ApiKeys.INITIATE_REVERSE_CONNECTIONS, apiVersion);
        this.data = data;
    }

    public static InitiateReverseConnectionsRequest parse(Readable readable, short version, MessageContext context) {
        return new InitiateReverseConnectionsRequest(new InitiateReverseConnectionsRequestData(readable, version, context), version);
    }

    @Override
    public InitiateReverseConnectionsRequestData data() {
        return this.data;
    }

    @Override
    public InitiateReverseConnectionsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<Integer> entries = new ArrayList<Integer>(this.data.entries().size());
        for (InitiateReverseConnectionsRequestData.EntryData entryData : this.data.entries()) {
            entries.add(entryData.initiateRequestId());
        }
        return new InitiateReverseConnectionsResponse(entries, throttleTimeMs, e);
    }

    public static class Builder
    extends AbstractRequest.Builder<InitiateReverseConnectionsRequest> {
        private final InitiateReverseConnectionsRequestData data;

        public Builder(InitiateReverseConnectionsRequestData data) {
            super(ApiKeys.INITIATE_REVERSE_CONNECTIONS);
            this.data = data;
        }

        @Override
        public InitiateReverseConnectionsRequest build(short version) {
            return new InitiateReverseConnectionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

