/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Optional;
import org.apache.kafka.common.message.ListMirrorsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListMirrorsResponse;

public class ListMirrorsRequest
extends AbstractRequest {
    private final ListMirrorsRequestData data;

    public ListMirrorsRequest(ListMirrorsRequestData data, short version) {
        super(ApiKeys.LIST_MIRRORS, version);
        this.data = data;
    }

    public Optional<String> linkName() {
        return Optional.ofNullable(this.data.linkName());
    }

    public boolean includeStopped() {
        return this.data.includeStopped();
    }

    public boolean listRemoteMirrors() {
        return this.data.listRemoteMirrors();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public ListMirrorsRequestData data() {
        return this.data;
    }

    @Override
    public ListMirrorsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new ListMirrorsResponse(throttleTimeMs, e);
    }

    public static ListMirrorsRequest parse(Readable readable, short version, MessageContext context) {
        return new ListMirrorsRequest(new ListMirrorsRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ListMirrorsRequest> {
        private final ListMirrorsRequestData data;

        public Builder(Optional<String> linkName, boolean includeStopped, int timeoutMs, boolean listRemoteMirrors) {
            super(ApiKeys.LIST_MIRRORS);
            this.data = new ListMirrorsRequestData().setLinkName(linkName.orElse(null)).setIncludeStopped(includeStopped).setTimeoutMs(timeoutMs).setListRemoteMirrors(listRemoteMirrors);
        }

        @Override
        public ListMirrorsRequest build(short version) {
            return new ListMirrorsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

