/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReadShareGroupStateSummaryResponse
extends AbstractResponse {
    private final ReadShareGroupStateSummaryResponseData data;

    public ReadShareGroupStateSummaryResponse(ReadShareGroupStateSummaryResponseData data) {
        super(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY);
        this.data = data;
    }

    @Override
    public ReadShareGroupStateSummaryResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result -> result.partitions().forEach(partitionResult -> ReadShareGroupStateSummaryResponse.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static ReadShareGroupStateSummaryResponse parse(Readable readable, short version, MessageContext context) {
        return new ReadShareGroupStateSummaryResponse(new ReadShareGroupStateSummaryResponseData(readable, version, context));
    }

    public static ReadShareGroupStateSummaryResponseData toErrorResponseData(Uuid topicId, int partitionId, Errors error, String errorMessage) {
        return new ReadShareGroupStateSummaryResponseData().setResults(List.of(new ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult().setTopicId(topicId).setPartitions(List.of(new ReadShareGroupStateSummaryResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage)))));
    }

    public static ReadShareGroupStateSummaryResponseData.PartitionResult toErrorResponsePartitionResult(int partitionId, Errors error, String errorMessage) {
        return new ReadShareGroupStateSummaryResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    public static ReadShareGroupStateSummaryResponseData toResponseData(Uuid topicId, int partition, long startOffset, int leaderEpoch, int stateEpoch) {
        return new ReadShareGroupStateSummaryResponseData().setResults(List.of(new ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult().setTopicId(topicId).setPartitions(List.of(new ReadShareGroupStateSummaryResponseData.PartitionResult().setPartition(partition).setStartOffset(startOffset).setLeaderEpoch(leaderEpoch).setStateEpoch(stateEpoch)))));
    }

    public static ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult toResponseReadStateSummaryResult(Uuid topicId, List<ReadShareGroupStateSummaryResponseData.PartitionResult> partitionResults) {
        return new ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult().setTopicId(topicId).setPartitions(partitionResults);
    }

    public static ReadShareGroupStateSummaryResponseData toGlobalErrorResponse(ReadShareGroupStateSummaryRequestData request, Errors error) {
        ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult> readStateSummaryResults = new ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult>();
        request.topics().forEach(topicData -> {
            ArrayList<ReadShareGroupStateSummaryResponseData.PartitionResult> partitionResults = new ArrayList<ReadShareGroupStateSummaryResponseData.PartitionResult>();
            topicData.partitions().forEach(partitionData -> partitionResults.add(ReadShareGroupStateSummaryResponse.toErrorResponsePartitionResult(partitionData.partition(), error, error.message())));
            readStateSummaryResults.add(ReadShareGroupStateSummaryResponse.toResponseReadStateSummaryResult(topicData.topicId(), partitionResults));
        });
        return new ReadShareGroupStateSummaryResponseData().setResults(readStateSummaryResults);
    }
}

