/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ResolveOffsetRangeRequestData;
import org.apache.kafka.common.message.ResolveOffsetRangeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ResolveOffsetRangeResponse;

public class ResolveOffsetRangeRequest
extends AbstractRequest {
    private final ResolveOffsetRangeRequestData data;

    private ResolveOffsetRangeRequest(ResolveOffsetRangeRequestData data, short version) {
        super(ApiKeys.RESOLVE_OFFSET_RANGE, version);
        this.data = data;
    }

    @Override
    public ResolveOffsetRangeResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short errorCode = Errors.forException(e).code();
        ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse> responses = new ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse>();
        for (ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic topic : this.data.topics()) {
            ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse topicResponse = new ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse().setTopicId(topic.topicId());
            ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse> partitions = new ArrayList<ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse>();
            for (ResolveOffsetRangeRequestData.ResolveOffsetRangePartition partition : topic.partitions()) {
                ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse partitionResponse = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setErrorCode(errorCode).setErrorMessage(e.getMessage()).setPartitionIndex(partition.partitionIndex());
                partitions.add(partitionResponse);
            }
            topicResponse.setPartitions(partitions);
            responses.add(topicResponse);
        }
        ResolveOffsetRangeResponseData responseData = new ResolveOffsetRangeResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(responses);
        return new ResolveOffsetRangeResponse(responseData);
    }

    @Override
    public ResolveOffsetRangeRequestData data() {
        return this.data;
    }

    public IsolationLevel isolationLevel() {
        return IsolationLevel.forId(this.data.isolationLevel());
    }

    public int numRanges() {
        return this.data.maxNumRanges();
    }

    public List<Uuid> topicIds() {
        return this.data.topics().stream().map(ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic::topicId).collect(Collectors.toList());
    }

    public List<ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic> topics() {
        return this.data.topics();
    }

    public static ResolveOffsetRangeRequest parse(Readable readable, short version, MessageContext context) {
        return new ResolveOffsetRangeRequest(new ResolveOffsetRangeRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ResolveOffsetRangeRequest> {
        private final ResolveOffsetRangeRequestData data;

        public Builder(short oldestAllowedVersion, short latestAllowedVersion, IsolationLevel isolationLevel, int maxRanges) {
            super(ApiKeys.RESOLVE_OFFSET_RANGE, oldestAllowedVersion, latestAllowedVersion);
            this.data = new ResolveOffsetRangeRequestData().setIsolationLevel(isolationLevel.id()).setMaxNumRanges(maxRanges);
        }

        public Builder(IsolationLevel isolationLevel, int maxRanges) {
            this(0, ApiKeys.RESOLVE_OFFSET_RANGE.latestVersion(), isolationLevel, maxRanges);
        }

        public Builder setRanges(List<ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic> topics) {
            this.data.setTopics(topics);
            return this;
        }

        @Override
        public ResolveOffsetRangeRequest build(short version) {
            return new ResolveOffsetRangeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

