/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class UpdateFeaturesResponse
extends AbstractResponse {
    private final UpdateFeaturesResponseData data;

    public UpdateFeaturesResponse(UpdateFeaturesResponseData data) {
        super(ApiKeys.UPDATE_FEATURES);
        this.data = data;
    }

    public ApiError topLevelError() {
        return new ApiError(Errors.forCode(this.data.errorCode()), this.data.errorMessage());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        UpdateFeaturesResponse.updateErrorCounts(errorCounts, Errors.forCode(this.data.errorCode()));
        for (UpdateFeaturesResponseData.UpdatableFeatureResult result : this.data.results()) {
            UpdateFeaturesResponse.updateErrorCounts(errorCounts, Errors.forCode(result.errorCode()));
        }
        return errorCounts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public UpdateFeaturesResponseData data() {
        return this.data;
    }

    public static UpdateFeaturesResponse parse(Readable readable, short version, MessageContext context) {
        return new UpdateFeaturesResponse(new UpdateFeaturesResponseData(readable, version, context));
    }

    public static UpdateFeaturesResponse createWithErrors(ApiError topLevelError, Set<String> updates, int throttleTimeMs) {
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        if (topLevelError == ApiError.NONE) {
            for (String feature : updates) {
                UpdateFeaturesResponseData.UpdatableFeatureResult result = new UpdateFeaturesResponseData.UpdatableFeatureResult();
                result.setFeature(feature).setErrorCode(topLevelError.error().code()).setErrorMessage(topLevelError.message());
                results.add(result);
            }
        }
        UpdateFeaturesResponseData responseData = new UpdateFeaturesResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(topLevelError.error().code()).setErrorMessage(topLevelError.message()).setResults(results).setThrottleTimeMs(throttleTimeMs);
        return new UpdateFeaturesResponse(responseData);
    }
}

