/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.util.Objects;

public class PathAwareSniHostName {
    private final String routingPathPrefix;
    private final String strippedHostName;
    private final String logicalClusterId;
    private final String subdomain;

    public PathAwareSniHostName(String rawHostName) {
        this(rawHostName, null);
    }

    public PathAwareSniHostName(String rawHostName, String subdomainPrefix) {
        int subdomainPos;
        Objects.requireNonNull(rawHostName);
        if (rawHostName.length() > 3 && rawHostName.charAt(2) == '-' && (rawHostName.startsWith("lkc-", 3) || rawHostName.startsWith("e-", 3))) {
            this.routingPathPrefix = rawHostName.substring(0, 2);
            this.strippedHostName = rawHostName.substring(3);
        } else {
            this.routingPathPrefix = null;
            this.strippedHostName = rawHostName;
        }
        int endLkcPos = -1;
        if (this.strippedHostName.startsWith("lkc-")) {
            int dashPos = this.strippedHostName.indexOf(45, 4);
            int dotPos = this.strippedHostName.indexOf(46, 4);
            int n = endLkcPos = dashPos == -1 || dotPos == -1 ? Math.max(dashPos, dotPos) : Math.min(dashPos, dotPos);
            this.logicalClusterId = endLkcPos != -1 ? this.strippedHostName.substring(0, endLkcPos) : null;
        } else {
            this.logicalClusterId = null;
        }
        int n = endLkcPos = endLkcPos == -1 ? 0 : endLkcPos;
        this.subdomain = subdomainPrefix == null || subdomainPrefix == "" ? null : ((subdomainPos = this.strippedHostName.indexOf(subdomainPrefix, endLkcPos)) != -1 ? this.strippedHostName.substring(subdomainPos) : null);
    }

    public String routingPathPrefix() {
        return this.routingPathPrefix;
    }

    public String strippedHostname() {
        return this.strippedHostName;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathAwareSniHostName that = (PathAwareSniHostName)o;
        return Objects.equals(this.routingPathPrefix, that.routingPathPrefix) && this.strippedHostName.equals(that.strippedHostName) && Objects.equals(this.logicalClusterId, that.logicalClusterId);
    }

    public int hashCode() {
        return Objects.hash(this.routingPathPrefix, this.strippedHostName, this.logicalClusterId);
    }

    public String toString() {
        return "PathAwareSniHostName[routingPathPrefix=" + this.routingPathPrefix + ",strippedHostName=" + this.strippedHostName + ",logicalClusterId=" + this.logicalClusterId + ",subdomain=" + this.subdomain;
    }
}

