/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.datapolicy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;

public class DefaultDataPolicyStore {
    private static final Map<String, DefaultDataPolicyStore> INSTANCES = new HashMap<String, DefaultDataPolicyStore>();
    private static final String METRICS_GROUP = "default-data-policy";
    private static final String CROSS_ORG_DENIED_SENSOR_NAME = "default-data-policy-cross-org-denied-sensor";
    private final Map<String, Boolean> policies = new ConcurrentHashMap<String, Boolean>();
    private volatile boolean defaultDataPolicyEnforcement = true;
    private Metrics metrics;
    private MetricName enforcementMetricName;
    private MetricName crossOrgDeniedTotalMetricName;
    private Sensor crossOrgDeniedSensor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultDataPolicyStore getInstance(String brokerSessionUuid) {
        Map<String, DefaultDataPolicyStore> map = INSTANCES;
        synchronized (map) {
            return INSTANCES.computeIfAbsent(brokerSessionUuid, k -> new DefaultDataPolicyStore());
        }
    }

    public void updateDefaultDataPolicyEnforcement(Boolean enforceDefaultDataPolicy) {
        this.defaultDataPolicyEnforcement = enforceDefaultDataPolicy == null ? true : enforceDefaultDataPolicy;
    }

    public boolean getDefaultDataPolicyEnforcement() {
        return this.defaultDataPolicyEnforcement;
    }

    public Sensor crossOrgDeniedSensor() {
        return this.crossOrgDeniedSensor;
    }

    public void startup(Metrics metrics) {
        this.metrics = metrics;
        this.enforcementMetricName = metrics.metricName("default-data-policy-enforcement", METRICS_GROUP, "Default data policy is enforced or not");
        this.metrics.addMetricIfAbsent(this.enforcementMetricName, null, (config, now) -> this.defaultDataPolicyEnforcement ? 1 : 0);
        this.crossOrgDeniedSensor = metrics.sensor(CROSS_ORG_DENIED_SENSOR_NAME);
        this.crossOrgDeniedTotalMetricName = new MetricName("cross-org-denied-total", METRICS_GROUP, "Total number of cross org denied", Collections.emptyMap());
        this.crossOrgDeniedSensor.add(this.crossOrgDeniedTotalMetricName, new CumulativeSum());
        this.crossOrgDeniedSensor.add(new MetricName("cross-org-denied-rate", METRICS_GROUP, "Rate of cross org denied", Collections.emptyMap()), new Rate());
    }

    public void shutdown() {
        if (this.metrics != null) {
            if (this.enforcementMetricName != null) {
                this.metrics.removeMetric(this.enforcementMetricName);
            }
            if (this.crossOrgDeniedSensor != null) {
                this.metrics.removeSensor(CROSS_ORG_DENIED_SENSOR_NAME);
                this.crossOrgDeniedSensor = null;
            }
        }
    }

    public boolean containsPolicy(String environmentId) {
        return this.policies.containsKey(environmentId);
    }

    public boolean getPolicy(String environmentId) {
        return this.policies.getOrDefault(environmentId, false);
    }

    public void addPolicy(String environmentId, boolean defaultDataPolicy) {
        this.policies.put(environmentId, defaultDataPolicy);
    }

    public void removePolicy(String environmentId) {
        this.policies.remove(environmentId);
    }

    public static boolean getDefaultDataPolicyEnforcement(String brokerSessionUuid) {
        return DefaultDataPolicyStore.getInstance(brokerSessionUuid).getDefaultDataPolicyEnforcement();
    }

    public static void updateDefaultDataPolicyEnforcement(String brokerSessionUuid, Boolean enforceDefaultDataPolicy) {
        DefaultDataPolicyStore.getInstance(brokerSessionUuid).updateDefaultDataPolicyEnforcement(enforceDefaultDataPolicy);
    }

    public static Sensor crossOrgDeniedSensor(String brokerSessionUuid) {
        return DefaultDataPolicyStore.getInstance(brokerSessionUuid).crossOrgDeniedSensor();
    }

    public static void startup(String brokerSessionUuid, Metrics metrics) {
        if (brokerSessionUuid == null) {
            return;
        }
        DefaultDataPolicyStore.getInstance(brokerSessionUuid).startup(metrics);
    }

    public static void shutdown(String brokerSessionUuid) {
        if (brokerSessionUuid == null) {
            return;
        }
        DefaultDataPolicyStore.getInstance(brokerSessionUuid).shutdown();
    }

    public static MetricName defaultDataPolicyEnforcementMetricName(String brokerSessionUuid) {
        return DefaultDataPolicyStore.getInstance((String)brokerSessionUuid).enforcementMetricName;
    }

    public static MetricName crossOrgDeniedTotalMetricName(String brokerSessionUuid) {
        return DefaultDataPolicyStore.getInstance((String)brokerSessionUuid).crossOrgDeniedTotalMetricName;
    }

    public static boolean getPolicy(String brokerSessionUuid, String environmentId) {
        return DefaultDataPolicyStore.getInstance(brokerSessionUuid).getPolicy(environmentId);
    }

    public static void addPolicy(String brokerSessionUuid, String environmentId, boolean defaultDataPolicy) {
        DefaultDataPolicyStore.getInstance(brokerSessionUuid).addPolicy(environmentId, defaultDataPolicy);
    }

    public static void removePolicy(String brokerSessionUuid, String environmentId) {
        DefaultDataPolicyStore.getInstance(brokerSessionUuid).removePolicy(environmentId);
    }
}

