/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.link;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.Uuid;

public class ClusterLinkInfoStore {
    private static final Map<String, ClusterLinkInfoStore> INSTANCES = new HashMap<String, ClusterLinkInfoStore>();
    private final Map<Uuid, Boolean> linkIdToDestinationInboundMode = new ConcurrentHashMap<Uuid, Boolean>();
    private static final String INBOUND = "INBOUND";
    private static final String DESTINATION = "DESTINATION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterLinkInfoStore getInstance(String brokerSessionUuid) {
        Map<String, ClusterLinkInfoStore> map = INSTANCES;
        synchronized (map) {
            return INSTANCES.computeIfAbsent(brokerSessionUuid, k -> new ClusterLinkInfoStore());
        }
    }

    public static void startup(String brokerSessionUuid) {
        if (brokerSessionUuid == null) {
            return;
        }
        ClusterLinkInfoStore.getInstance(brokerSessionUuid);
    }

    public void updateClusterLinkInfo(Uuid linkId, String linkMode, String connectionMode) {
        this.linkIdToDestinationInboundMode.put(linkId, INBOUND.equals(connectionMode) && DESTINATION.equals(linkMode));
    }

    public boolean hasDestinationLink(Uuid linkId) {
        return this.linkIdToDestinationInboundMode.getOrDefault(linkId, false);
    }

    public void removeClusterLinkInfo(Uuid linkId) {
        this.linkIdToDestinationInboundMode.remove(linkId);
    }

    public static void updateClusterLinkInfo(String brokerSessionUuid, Uuid linkId, String linkMode, String connectionMode) {
        ClusterLinkInfoStore.getInstance(brokerSessionUuid).updateClusterLinkInfo(linkId, linkMode, connectionMode);
    }

    public static boolean hasDestinationLink(String brokerSessionUuid, Uuid linkId) {
        return ClusterLinkInfoStore.getInstance(brokerSessionUuid).hasDestinationLink(linkId);
    }

    public static void removeClusterLinkInfo(String brokerSessionUuid, Uuid linkId) {
        ClusterLinkInfoStore.getInstance(brokerSessionUuid).removeClusterLinkInfo(linkId);
    }
}

