/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.multitenant;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;

public interface MultiTenantMetadata
extends Configurable {
    public static final String CONFLUENT_ENV_ID = "t0";

    public void close(String var1);

    public void startClients(Function<String, Admin> var1);

    default public void registerTenantCallback(Function<String, Boolean> callback) {
    }

    default public void registerTenantMetadataUpdateCallback(Function<String, Boolean> callback) {
    }

    default public void registerTenantDeactivatedCallback(Function<String, Boolean> callback) {
    }

    public Map<Endpoint, CompletableFuture<Void>> start(Map<String, Object> var1, Collection<Endpoint> var2);

    public String dedicatedLogicalClusterId();

    public Set<String> kafkaLogicalClusterIds();

    public Set<String> logicalClusterIds();

    public LogicalClusterMetadata metadata(String var1);

    public boolean isUp();

    default public void ensureOpen() {
        if (!this.isUp()) {
            throw new IllegalStateException("Metadata consumer isn't up");
        }
    }

    default public LogicalClusterMetadata firstActiveUserLkcMetadata() {
        Set<String> lkcIds = this.kafkaLogicalClusterIds();
        for (String lkcId : lkcIds) {
            LogicalClusterMetadata lkcMetadata = this.metadata(lkcId);
            if (lkcMetadata == null || !lkcMetadata.isActive() || lkcMetadata.isHealthcheckLogicalCluster() || lkcMetadata.environmentId().equals(CONFLUENT_ENV_ID)) continue;
            return lkcMetadata;
        }
        return null;
    }
}

