/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi.retry;

import java.time.Duration;
import java.util.function.UnaryOperator;
import lombok.Generated;

public class ExponentialBackoffPolicy {
    public static final ExponentialBackoffPolicy DEFAULT = new ExponentialBackoffPolicy();
    public static final int UNLIMITED_RETRIES = 0;
    private static final int BACKOFF_MULTIPLIER = 2;
    private Duration initialDelay = Duration.ofSeconds(1L);
    private Duration maxDelay = Duration.ofSeconds(60L);
    private int maxRetries = 0;
    private int backoffMultiplier = 2;
    private UnaryOperator<Duration> backoffFunction = d -> d.multipliedBy(this.backoffMultiplier);

    public ExponentialBackoffPolicy(Duration initialDelay, Duration maxDelay, int maxRetries, int backoffMultiplier) {
        this.initialDelay = initialDelay != null ? initialDelay : Duration.ofSeconds(1L);
        this.maxDelay = maxDelay != null ? maxDelay : Duration.ofSeconds(60L);
        this.maxRetries = maxRetries != 0 ? maxRetries : 0;
        this.backoffMultiplier = backoffMultiplier != 0 ? backoffMultiplier : 2;
    }

    private ExponentialBackoffPolicy() {
    }

    public Duration nextDelay(Duration currentDelay) {
        if (currentDelay.compareTo(this.maxDelay) < 0) {
            return this.calculateNextDelay(currentDelay);
        }
        return this.maxDelay;
    }

    public boolean reachedMaxRetries(int retriesCount) {
        return this.maxRetries != 0 && retriesCount >= this.maxRetries;
    }

    private Duration calculateNextDelay(Duration currentDelay) {
        Duration next = (Duration)this.backoffFunction.apply(currentDelay);
        if (next.compareTo(this.maxDelay) > 0) {
            return this.maxDelay;
        }
        return next;
    }

    @Generated
    public static ExponentialBackoffPolicyBuilder builder() {
        return new ExponentialBackoffPolicyBuilder();
    }

    @Generated
    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    @Generated
    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public int getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    @Generated
    public UnaryOperator<Duration> getBackoffFunction() {
        return this.backoffFunction;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialBackoffPolicy)) {
            return false;
        }
        ExponentialBackoffPolicy other = (ExponentialBackoffPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxRetries() != other.getMaxRetries()) {
            return false;
        }
        if (this.getBackoffMultiplier() != other.getBackoffMultiplier()) {
            return false;
        }
        Duration this$initialDelay = this.getInitialDelay();
        Duration other$initialDelay = other.getInitialDelay();
        if (this$initialDelay == null ? other$initialDelay != null : !((Object)this$initialDelay).equals(other$initialDelay)) {
            return false;
        }
        Duration this$maxDelay = this.getMaxDelay();
        Duration other$maxDelay = other.getMaxDelay();
        if (this$maxDelay == null ? other$maxDelay != null : !((Object)this$maxDelay).equals(other$maxDelay)) {
            return false;
        }
        UnaryOperator<Duration> this$backoffFunction = this.getBackoffFunction();
        UnaryOperator<Duration> other$backoffFunction = other.getBackoffFunction();
        return !(this$backoffFunction == null ? other$backoffFunction != null : !this$backoffFunction.equals(other$backoffFunction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExponentialBackoffPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxRetries();
        result = result * 59 + this.getBackoffMultiplier();
        Duration $initialDelay = this.getInitialDelay();
        result = result * 59 + ($initialDelay == null ? 43 : ((Object)$initialDelay).hashCode());
        Duration $maxDelay = this.getMaxDelay();
        result = result * 59 + ($maxDelay == null ? 43 : ((Object)$maxDelay).hashCode());
        UnaryOperator<Duration> $backoffFunction = this.getBackoffFunction();
        result = result * 59 + ($backoffFunction == null ? 43 : $backoffFunction.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExponentialBackoffPolicy(initialDelay=" + this.getInitialDelay() + ", maxDelay=" + this.getMaxDelay() + ", maxRetries=" + this.getMaxRetries() + ", backoffMultiplier=" + this.getBackoffMultiplier() + ", backoffFunction=" + this.getBackoffFunction() + ")";
    }

    @Generated
    public static class ExponentialBackoffPolicyBuilder {
        @Generated
        private Duration initialDelay;
        @Generated
        private Duration maxDelay;
        @Generated
        private int maxRetries;
        @Generated
        private int backoffMultiplier;

        @Generated
        ExponentialBackoffPolicyBuilder() {
        }

        @Generated
        public ExponentialBackoffPolicyBuilder initialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        @Generated
        public ExponentialBackoffPolicyBuilder maxDelay(Duration maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        @Generated
        public ExponentialBackoffPolicyBuilder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public ExponentialBackoffPolicyBuilder backoffMultiplier(int backoffMultiplier) {
            this.backoffMultiplier = backoffMultiplier;
            return this;
        }

        @Generated
        public ExponentialBackoffPolicy build() {
            return new ExponentialBackoffPolicy(this.initialDelay, this.maxDelay, this.maxRetries, this.backoffMultiplier);
        }

        @Generated
        public String toString() {
            return "ExponentialBackoffPolicy.ExponentialBackoffPolicyBuilder(initialDelay=" + this.initialDelay + ", maxDelay=" + this.maxDelay + ", maxRetries=" + this.maxRetries + ", backoffMultiplier=" + this.backoffMultiplier + ")";
        }
    }
}

