/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import com.google.common.collect.Streams;
import io.confluent.kafka.schemaregistry.client.rest.entities.ContextId;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.ExtendedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SchemasResource {
    public static final String apiTag = "Schemas (v1)";
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public SchemasResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @DocumentedName(value="getSchemas")
    @Operation(summary="List schemas", description="Get the schemas matching the specified parameters.", responses={@ApiResponse(responseCode="200", description="List of schemas matching the specified parameters.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=io.confluent.kafka.schemaregistry.client.rest.entities.Schema.class)))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.get-schemas")
    public List<ExtendedSchema> getSchemas(@Parameter(description="Filters results by the respective subject prefix") @DefaultValue(value="") @QueryParam(value="subjectPrefix") String subjectPrefix, @Parameter(description="Whether to include aliases in the search") @DefaultValue(value="false") @QueryParam(value="aliases") boolean aliases, @Parameter(description="Whether to return soft deleted schemas") @DefaultValue(value="false") @QueryParam(value="deleted") boolean lookupDeletedSchema, @Parameter(description="Whether to return latest schema versions only for each matching subject") @DefaultValue(value="false") @QueryParam(value="latestOnly") boolean latestOnly, @Parameter(description="Filters results by the given rule type") @DefaultValue(value="") @QueryParam(value="ruleType") String ruleType, @Parameter(description="Pagination offset for results") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Pagination size for results. Ignored if negative") @DefaultValue(value="-1") @QueryParam(value="limit") int limit) {
        Iterator<ExtendedSchema> schemas;
        String errorMessage = "Error while getting schemas for prefix " + subjectPrefix;
        LookupFilter filter = lookupDeletedSchema ? LookupFilter.INCLUDE_DELETED : LookupFilter.DEFAULT;
        try {
            Predicate<io.confluent.kafka.schemaregistry.client.rest.entities.Schema> postFilter = ruleType != null && !ruleType.isEmpty() ? schema -> schema.getRuleSet() != null && schema.getRuleSet().hasRulesWithType(ruleType) : null;
            schemas = this.schemaRegistry.getVersionsWithSubjectPrefix(subjectPrefix, aliases, filter, latestOnly, postFilter);
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        limit = this.schemaRegistry.normalizeSchemaLimit(limit);
        return Streams.stream(schemas).skip(offset).limit(limit).collect(Collectors.toList());
    }

    @GET
    @Path(value="/ids/{id}")
    @DocumentedName(value="getSchemaById")
    @Operation(summary="Get schema by ID", description="Retrieves the schema identified by the input ID.", responses={@ApiResponse(responseCode="200", description="The schema.", content={@Content(schema=@Schema(implementation=SchemaString.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40403 indicates schema not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.ids.get-schema")
    public SchemaString getSchema(@Parameter(description="unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @Parameter(description="Name of the subject") @QueryParam(value="subject") String subject, @Parameter(description="Desired output format, dependent on schema type") @DefaultValue(value="") @QueryParam(value="format") String format, @Parameter(description="Desired output format for references") @DefaultValue(value="") @QueryParam(value="referenceFormat") String referenceFormat, @Parameter(description="Find tagged entities for the given tags or * for all tags") @QueryParam(value="findTags") List<String> tags, @Parameter(description="Whether to fetch the maximum schema identifier that exists") @DefaultValue(value="false") @QueryParam(value="fetchMaxId") boolean fetchMaxId) {
        SchemaString schema;
        String errorMessage = "Error while retrieving schema with id " + id + " from the schema registry";
        try {
            boolean hasRefs;
            QualifiedSubject qs;
            schema = this.schemaRegistry.get(id, subject, format, fetchMaxId);
            if (schema == null) {
                throw Errors.schemaNotFoundException(id);
            }
            if (tags != null && !tags.isEmpty()) {
                io.confluent.kafka.schemaregistry.client.rest.entities.Schema s = new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(null, null, null, schema);
                this.schemaRegistry.extractSchemaTags(s, tags);
                schema.setSchemaTags(s.getSchemaTags());
            }
            boolean isQualifiedSubject = (qs = QualifiedSubject.create((String)this.schemaRegistry.tenant(), (String)schema.getSubject())) != null && !".".equals(qs.getContext());
            List refs = schema.getReferences();
            boolean bl = hasRefs = refs != null && !refs.isEmpty();
            if (isQualifiedSubject && hasRefs && referenceFormat != null && referenceFormat.equals("qualified")) {
                List qualifiedRefs = refs.stream().map(ref -> {
                    QualifiedSubject refSubject = QualifiedSubject.qualifySubjectWithParent((String)this.schemaRegistry.tenant(), (String)qs.toQualifiedSubject(), (String)ref.getSubject());
                    return new SchemaReference(ref.getName(), refSubject.toUnqualifiedSubject(), ref.getVersion());
                }).collect(Collectors.toList());
                schema.setReferences(qualifiedRefs);
            }
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        return schema;
    }

    @GET
    @Path(value="/ids/{id}/subjects")
    @DocumentedName(value="getAllSubjectsById")
    @Operation(summary="List subjects associated to schema ID", description="Retrieves all the subjects associated with a particular schema ID.", responses={@ApiResponse(responseCode="200", description="List of subjects matching the specified parameters.", content={@Content(array=@ArraySchema(schema=@Schema(example="User")))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40403 indicates schema not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.get-subjects")
    public Set<String> getSubjects(@Parameter(description="Unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @Parameter(description="Filters results by the respective subject") @QueryParam(value="subject") String subject, @Parameter(description="Whether to include subjects where the schema was deleted") @QueryParam(value="deleted") boolean lookupDeletedSchema, @Parameter(description="Pagination offset for results") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Pagination size for results. Ignored if negative") @DefaultValue(value="-1") @QueryParam(value="limit") int limit) {
        Set<String> subjects;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            subjects = this.schemaRegistry.listSubjectsForId(id, subject, lookupDeletedSchema);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (subjects == null) {
            throw Errors.schemaNotFoundException();
        }
        limit = this.schemaRegistry.normalizeSubjectLimit(limit);
        return subjects.stream().skip(offset).limit(limit).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @GET
    @Path(value="/ids/{id}/versions")
    @DocumentedName(value="getAllVersionsById")
    @Operation(summary="List subject-versions associated to schema ID", description="Get all the subject-version pairs associated with the input ID.", responses={@ApiResponse(responseCode="200", description="List of subject versions matching the specified parameters.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SubjectVersion.class)))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40403 indicates schema not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.get-versions")
    public List<SubjectVersion> getVersions(@Parameter(description="Unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @Parameter(description="Filters results by the respective subject") @QueryParam(value="subject") String subject, @Parameter(description="Whether to include subject versions where the schema was deleted") @QueryParam(value="deleted") boolean lookupDeletedSchema, @Parameter(description="Pagination offset for results") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Pagination size for results. Ignored if negative") @DefaultValue(value="-1") @QueryParam(value="limit") int limit) {
        List<SubjectVersion> versions;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            versions = this.schemaRegistry.listVersionsForId(id, subject, lookupDeletedSchema);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (versions == null) {
            throw Errors.schemaNotFoundException();
        }
        limit = this.schemaRegistry.normalizeSubjectVersionLimit(limit);
        return versions.stream().skip(offset).limit(limit).collect(Collectors.toList());
    }

    @GET
    @Path(value="/ids/{id}/schema")
    @DocumentedName(value="getOnlySchemaById")
    @Operation(summary="Get schema by ID", description="Retrieves the schema identified by the input ID.", responses={@ApiResponse(responseCode="200", description="Raw schema string.", content={@Content(schema=@Schema(example="{\"schema\": \"{\"type\": \"string\"}\"}"))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40403 indicates schema not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.ids.get-schema.only")
    public String getSchemaOnly(@Parameter(description="Unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @Parameter(description="Name of the subject") @QueryParam(value="subject") String subject, @Parameter(description="Desired output format, dependent on schema type") @DefaultValue(value="") @QueryParam(value="format") String format) {
        String schema;
        String errorMessage = "Error while retrieving schema with id " + id + " from the schema registry";
        try {
            schema = this.schemaRegistry.get(id, subject, format, false).getSchemaString();
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (schema == null) {
            throw Errors.schemaNotFoundException(id);
        }
        return schema;
    }

    @GET
    @Path(value="/guids/{guid}")
    @DocumentedName(value="getSchemaByGuid")
    @Operation(summary="Get schema by GUID", description="Retrieves the schema identified by the input GUID.", responses={@ApiResponse(responseCode="200", description="The schema.", content={@Content(schema=@Schema(implementation=SchemaString.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40403 indicates schema not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.guids.get-schema")
    public SchemaString getSchemaByGuid(@Parameter(description="Globally unique identifier of the schema", required=true) @PathParam(value="guid") String guid, @Parameter(description="Desired output format, dependent on schema type") @DefaultValue(value="") @QueryParam(value="format") String format) {
        SchemaString schema;
        String errorMessage = "Error while retrieving schema with guid " + guid + " from the schema registry";
        try {
            schema = this.schemaRegistry.getByGuid(guid, format);
            if (schema == null) {
                throw Errors.schemaNotFoundException(guid);
            }
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        return schema;
    }

    @GET
    @Path(value="/guids/{guid}/ids")
    @DocumentedName(value="getAllIdsByGuid")
    @Operation(summary="Get IDs by GUID", description="Retrieves the IDs identified by the input GUID.", responses={@ApiResponse(responseCode="200", description="List of IDs for the given GUID.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ContextId.class)))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40403 indicates schema not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.guids.get-ids")
    public List<ContextId> getIdsByGuid(@Parameter(description="Globally unique identifier of the schema", required=true) @PathParam(value="guid") String guid) {
        List<ContextId> ids;
        String errorMessage = "Error while retrieving all ids with guid " + guid + " from the schema registry";
        try {
            ids = this.schemaRegistry.listIdsForGuid(guid);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        return ids;
    }

    @GET
    @Path(value="/types")
    @DocumentedName(value="getSchemaTypes")
    @Operation(summary="List supported schema types", description="Retrieve the schema types supported by this registry.", responses={@ApiResponse(responseCode="200", description="List of supported schema types.", content={@Content(array=@ArraySchema(schema=@Schema(example="AVRO")))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Schemas (v1)")})
    @PerformanceMetric(value="schemas.get-types")
    public Set<String> getSchemaTypes() {
        return this.schemaRegistry.schemaTypes();
    }
}

