/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.Rule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RuleSet {
    private final List<Rule> migrationRules;
    private final List<Rule> domainRules;
    private final List<Rule> encodingRules;

    @JsonCreator
    public RuleSet(@JsonProperty(value="migrationRules") List<Rule> migrationRules, @JsonProperty(value="domainRules") List<Rule> domainRules, @JsonProperty(value="encodingRules") List<Rule> encodingRules) {
        this.migrationRules = migrationRules != null ? Collections.unmodifiableList(migrationRules) : Collections.emptyList();
        this.domainRules = domainRules != null ? Collections.unmodifiableList(domainRules) : Collections.emptyList();
        this.encodingRules = encodingRules != null ? Collections.unmodifiableList(encodingRules) : Collections.emptyList();
    }

    public RuleSet(io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet) {
        this.migrationRules = ruleSet.getMigrationRules().stream().map(Rule::new).collect(Collectors.toList());
        this.domainRules = ruleSet.getDomainRules().stream().map(Rule::new).collect(Collectors.toList());
        this.encodingRules = ruleSet.getEncodingRules().stream().map(Rule::new).collect(Collectors.toList());
    }

    public List<Rule> getMigrationRules() {
        return this.migrationRules;
    }

    public List<Rule> getDomainRules() {
        return this.domainRules;
    }

    public List<Rule> getEncodingRules() {
        return this.encodingRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSet ruleSet = (RuleSet)o;
        return Objects.equals(this.migrationRules, ruleSet.migrationRules) && Objects.equals(this.domainRules, ruleSet.domainRules) && Objects.equals(this.encodingRules, ruleSet.encodingRules);
    }

    public int hashCode() {
        return Objects.hash(this.migrationRules, this.domainRules, this.encodingRules);
    }

    public String toString() {
        return "Rules{migrationRules=" + String.valueOf(this.migrationRules) + ", domainRules=" + String.valueOf(this.domainRules) + ", encodingRules=" + String.valueOf(this.encodingRules) + "}";
    }

    public io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet toRuleSetEntity() {
        return new io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet(this.getMigrationRules().stream().map(Rule::toRuleEntity).collect(Collectors.toList()), this.getDomainRules().stream().map(Rule::toRuleEntity).collect(Collectors.toList()), this.getEncodingRules().stream().map(Rule::toRuleEntity).collect(Collectors.toList()));
    }
}

